/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;

public class MovieAssignMovieSetTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieAssignMovieSetTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToScrape;

    public MovieAssignMovieSetTask(List<Movie> moviesToScrape) {
        super(BUNDLE.getString("movie.assignmovieset"));
        this.moviesToScrape = moviesToScrape;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(1, "scrape");
        this.start();
        for (Movie movie : this.moviesToScrape) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done assigning movies to movie sets");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class Worker
    implements Runnable {
        private MovieList movieList = MovieList.getInstance();
        private Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            block15: {
                if (this.movie.getMovieSet() != null) {
                    return;
                }
                try {
                    MediaScraper movieScraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
                    MediaScraper movieSetScraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE_SET);
                    MovieSearchAndScrapeOptions movieOptions = new MovieSearchAndScrapeOptions();
                    movieOptions.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage());
                    for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
                        movieOptions.setId(entry.getKey(), entry.getValue().toString());
                    }
                    MediaMetadata md = ((IMovieMetadataProvider)movieScraper.getMediaProvider()).getMetadata(movieOptions);
                    int collectionId = 0;
                    try {
                        collectionId = (Integer)md.getId("tmdbSet");
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not parse collectionId: {}", md.getId("tmdbSet"));
                    }
                    if (collectionId <= 0) break block15;
                    String collectionName = md.getCollectionName();
                    MovieSet movieSet = this.movieList.getMovieSet(collectionName, collectionId);
                    if (movieSet != null && movieSet.getTmdbId() == 0) {
                        movieSet.setTmdbId(collectionId);
                        try {
                            MovieSetSearchAndScrapeOptions movieSetOptions = new MovieSetSearchAndScrapeOptions();
                            movieSetOptions.setTmdbId(collectionId);
                            movieSetOptions.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage());
                            MediaMetadata info = ((IMovieSetMetadataProvider)movieSetScraper.getMediaProvider()).getMetadata(movieSetOptions);
                            if (info != null && StringUtils.isNotBlank((CharSequence)info.getTitle())) {
                                movieSet.setTitle(info.getTitle());
                                movieSet.setPlot(info.getPlot());
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                                    movieSet.setArtworkUrl(info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0).getDefaultUrl(), MediaFileType.POSTER);
                                }
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                                    movieSet.setArtworkUrl(info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0).getDefaultUrl(), MediaFileType.FANART);
                                }
                            }
                        }
                        catch (ScrapeException e) {
                            LOGGER.error("getMovieSet", (Throwable)e);
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                        }
                        catch (MissingIdException | NothingFoundException e) {
                            LOGGER.debug("could not fetch movie set data: {}", (Object)e.getMessage());
                        }
                    }
                    if (movieSet != null) {
                        this.movie.setMovieSet(null);
                        this.movie.setMovieSet(movieSet);
                        movieSet.insertMovie(this.movie);
                        this.movie.writeNFO();
                        this.movie.saveToDb();
                        movieSet.saveToDb();
                    }
                }
                catch (ScrapeException e) {
                    LOGGER.error("getMovieSet", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException | NothingFoundException e) {
                    LOGGER.debug("could not fetch movie data: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

