/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieScrapeTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToScrape;
    private boolean doSearch;
    private MovieSearchAndScrapeOptions searchAndScrapeOptions;
    private List<MovieScraperMetadataConfig> scraperMetadataConfig;
    private List<Movie> smartScrapeList;

    public MovieScrapeTask(List<Movie> moviesToScrape, boolean doSearch, MovieSearchAndScrapeOptions options, List<MovieScraperMetadataConfig> metadataConfig) {
        super(BUNDLE.getString("movie.scraping"));
        this.moviesToScrape = moviesToScrape;
        this.doSearch = doSearch;
        this.searchAndScrapeOptions = options;
        this.scraperMetadataConfig = metadataConfig;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "scrape");
        this.start();
        this.smartScrapeList = new ArrayList<Movie>(0);
        for (Movie movie : this.moviesToScrape) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        if (!this.smartScrapeList.isEmpty() && !GraphicsEnvironment.isHeadless()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    int selectedCount = this.smartScrapeList.size();
                    int index = 0;
                    do {
                        Movie movie = this.smartScrapeList.get(index);
                        MovieChooserDialog dialogMovieChooser = new MovieChooserDialog(movie, index, selectedCount);
                        dialogMovieChooser.setVisible(true);
                        if (!dialogMovieChooser.isContinueQueue()) break;
                        if (dialogMovieChooser.isNavigateBack()) {
                            --index;
                            continue;
                        }
                        ++index;
                    } while (index < selectedCount);
                });
            }
            catch (Exception e) {
                LOGGER.error("SmartScrape crashed: {}", (Object)e.getMessage());
            }
        }
        if (MovieModuleManager.SETTINGS.getSyncTrakt()) {
            SyncTraktTvTask task = new SyncTraktTvTask(this.moviesToScrape, null);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.info("Done scraping movies)");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private MovieList movieList;
        private Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    this.movieList = MovieList.getInstance();
                    MediaScraper mediaMetadataScraper = MovieScrapeTask.this.searchAndScrapeOptions.getMetadataScraper();
                    List<MediaScraper> artworkScrapers = MovieScrapeTask.this.searchAndScrapeOptions.getArtworkScrapers();
                    List<MediaScraper> trailerScrapers = MovieScrapeTask.this.searchAndScrapeOptions.getTrailerScrapers();
                    MediaSearchResult result1 = null;
                    if (MovieScrapeTask.this.doSearch && (result1 = this.searchForMovie(mediaMetadataScraper)) == null) {
                        List list = MovieScrapeTask.this.smartScrapeList;
                        synchronized (list) {
                            MovieScrapeTask.this.smartScrapeList.add(this.movie);
                            return;
                        }
                    }
                    if ((!MovieScrapeTask.this.doSearch || result1 == null) && MovieScrapeTask.this.doSearch) break block14;
                    MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions(MovieScrapeTask.this.searchAndScrapeOptions);
                    options.setSearchResult(result1);
                    if (MovieScrapeTask.this.doSearch) {
                        options.setIds(result1.getIds());
                        mediaMetadataScraper = this.movieList.getMediaScraperById(result1.getProviderId());
                    } else {
                        options.setIds(this.movie.getIds());
                    }
                    MediaMetadata md = null;
                    if (mediaMetadataScraper == null || mediaMetadataScraper.getMediaProvider() == null) break block14;
                    LOGGER.info("=====================================================");
                    LOGGER.info("Scraper metadata with scraper: " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getId() + ", " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getVersion());
                    LOGGER.info(options.toString());
                    LOGGER.info("=====================================================");
                    try {
                        md = ((IMovieMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("searchMovieFallback", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException e) {
                        LOGGER.warn("missing id for scrape");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "scraper.error.missingid"));
                    }
                    if (ScraperMetadataConfig.containsAnyMetadata(MovieScrapeTask.this.scraperMetadataConfig) || ScraperMetadataConfig.containsAnyCast(MovieScrapeTask.this.scraperMetadataConfig)) {
                        this.movie.setMetadata(md, MovieScrapeTask.this.scraperMetadataConfig);
                    }
                    if (ScraperMetadataConfig.containsAnyArtwork(MovieScrapeTask.this.scraperMetadataConfig)) {
                        this.movie.setArtwork(this.getArtwork(this.movie, md, artworkScrapers), (List<MovieScraperMetadataConfig>)MovieScrapeTask.this.scraperMetadataConfig);
                    }
                    if (MovieScrapeTask.this.scraperMetadataConfig.contains(MovieScraperMetadataConfig.TRAILER)) {
                        this.movie.setTrailers(this.getTrailers(this.movie, md, trailerScrapers));
                        this.movie.saveToDb();
                        this.movie.writeNFO();
                        MovieHelpers.startAutomaticTrailerDownload(this.movie);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        private MediaSearchResult searchForMovie(MediaScraper mediaMetadataProvider) {
            List<MediaSearchResult> results = this.movieList.searchMovie(this.movie.getTitle(), this.movie.getYear(), this.movie.getIds(), mediaMetadataProvider);
            MediaSearchResult result = null;
            if (results != null && !results.isEmpty()) {
                result = results.get(0);
                if (results.size() > 1) {
                    MediaSearchResult result2 = results.get(1);
                    if (result.getScore() == 1.0f && result2.getScore() == 1.0f) {
                        LOGGER.info("two 100% results, can't decide which to take - ignore result");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.toosimilar"));
                        return null;
                    }
                }
                double scraperTreshold = MovieModuleManager.SETTINGS.getScraperThreshold();
                LOGGER.info("using treshold from settings of {}", (Object)scraperTreshold);
                if ((double)result.getScore() < scraperTreshold) {
                    LOGGER.info("score is lower than {} ({}) - ignore result", (Object)scraperTreshold, (Object)Float.valueOf(result.getScore()));
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "movie.scrape.toolowscore", new String[]{String.format("%.2f", scraperTreshold)}));
                    return null;
                }
            } else {
                LOGGER.info("no result found for {}", (Object)this.movie.getTitle());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.nomatchfound"));
            }
            return result;
        }

        private List<MediaArtwork> getArtwork(Movie movie, MediaMetadata metadata, List<MediaScraper> artworkScrapers) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE);
            options.setDataFromOtherOptions(MovieScrapeTask.this.searchAndScrapeOptions);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            options.setIds(metadata.getIds());
            options.setLanguage(MovieModuleManager.SETTINGS.getImageScraperLanguage());
            options.setFanartSize(MovieModuleManager.SETTINGS.getImageFanartSize());
            options.setPosterSize(MovieModuleManager.SETTINGS.getImagePosterSize());
            for (MediaScraper scraper : artworkScrapers) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException missingIdException) {}
            }
            return artwork;
        }

        private List<MediaTrailer> getTrailers(Movie movie, MediaMetadata metadata, List<MediaScraper> trailerScrapers) {
            ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.MOVIE);
            options.setDataFromOtherOptions(MovieScrapeTask.this.searchAndScrapeOptions);
            options.setMetadata(metadata);
            options.setIds(metadata.getIds());
            for (MediaScraper trailerScraper : trailerScrapers) {
                try {
                    IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                    trailers.addAll(trailerProvider.getTrailers(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("no usable ID found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
            }
            return trailers;
        }
    }
}

