/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YTDownloadTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;

public class MovieTrailerDownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieTrailerDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private final Movie movie;
    private final List<MovieTrailerNaming> trailernames = new ArrayList<MovieTrailerNaming>();
    private final TrailerQuality desiredQuality;
    private final TrailerSources desiredSource;

    public MovieTrailerDownloadTask(Movie movie) {
        super(BUNDLE.getString("trailer.download") + " - " + movie.getTitle(), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.movie = movie;
        if (movie.isMultiMovieDir()) {
            this.trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
        } else {
            this.trailernames.addAll(MovieModuleManager.SETTINGS.getTrailerFilenames());
        }
        this.desiredSource = MovieModuleManager.SETTINGS.getTrailerSource();
        this.desiredQuality = MovieModuleManager.SETTINGS.getTrailerQuality();
    }

    @Override
    protected void doInBackground() {
        LinkedHashSet<MediaTrailer> trailers = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : this.movie.getTrailer()) {
            if (!this.desiredQuality.containsQuality(trailer.getQuality()) || !this.desiredSource.containsSource(trailer.getProvider())) continue;
            trailers.add(trailer);
        }
        for (MediaTrailer trailer : this.movie.getTrailer()) {
            if (!this.desiredQuality.containsQuality(trailer.getQuality())) continue;
            trailers.add(trailer);
        }
        trailers.addAll(this.movie.getTrailer());
        if (trailers.isEmpty()) {
            LOGGER.warn("no trailers for '{}' available", (Object)this.movie.getTitle());
            return;
        }
        LOGGER.info("downloading trailer for '{}'", (Object)this.movie.getTitle());
        for (MediaTrailer trailer : trailers) {
            String url = trailer.getUrl();
            if (!url.startsWith("http")) continue;
            try {
                LOGGER.debug("try to download trailer '{}'", (Object)url);
                Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(url);
                TmmTask task = matcher.matches() ? new YTDownloadTask(trailer, this.desiredQuality){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return MovieTrailerDownloadTask.this.getDestination();
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return MovieTrailerDownloadTask.this.movie;
                    }
                } : new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return MovieTrailerDownloadTask.this.getDestination();
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return MovieTrailerDownloadTask.this.movie;
                    }
                };
                task.addListener(taskEvent -> {
                    this.setProgressDone(taskEvent.getProgressDone());
                    this.setTaskDescription(taskEvent.getTaskDescription());
                    this.setWorkUnits(taskEvent.getWorkUnits());
                    this.informListeners();
                });
                task.run();
                if (task.getState() != TmmTaskHandle.TaskState.FINISHED && task.getState() != TmmTaskHandle.TaskState.CANCELLED) continue;
                break;
            }
            catch (Exception e) {
                LOGGER.debug("could download trailer - {}", (Object)e.getMessage());
            }
        }
    }

    protected Path getDestination() {
        String filename = !this.trailernames.isEmpty() ? this.movie.getTrailerFilename(this.trailernames.get(0)) : this.movie.getTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        return this.movie.getPathNIO().resolve(filename);
    }
}

