/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;

public class MovieUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpdateDatasourceTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private static long preDirAll = 0L;
    private static long postDirAll = 0L;
    private static long visFileAll = 0L;
    private static final List<String> skipFolders = Arrays.asList(".", "..", "CERTIFICATE", "BACKUP", "PLAYLIST", "CLPINF", "SSIF", "AUXDATA", "AUDIO_TS", "JAR", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR", "ADV_OBJ");
    private static final String skipRegex = "(?i)^[.@](?!45|buelos)[\\w@]+.*";
    private static Pattern video3DPattern = Pattern.compile("(?i)[ ._\\(\\[-]3D[ ._\\)\\]-]?");
    private List<String> dataSources;
    private List<Movie> movieFolders = new ArrayList<Movie>();
    private MovieList movieList;
    private Set<Path> filesFound = ConcurrentHashMap.newKeySet();
    private List<Runnable> miTasks = Collections.synchronizedList(new ArrayList());

    public MovieUpdateDatasourceTask() {
        super(BUNDLE.getString("update.datasource"));
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(MovieModuleManager.SETTINGS.getMovieDataSource());
    }

    public MovieUpdateDatasourceTask(String datasource) {
        super(BUNDLE.getString("update.datasource") + " (" + datasource + ")");
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    public MovieUpdateDatasourceTask(List<Movie> movies) {
        super(BUNDLE.getString("update.datasource"));
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(0);
        this.movieFolders.addAll(movies);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.movieFolders.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        preDir = 0L;
        postDir = 0L;
        visFile = 0L;
        preDirAll = 0L;
        postDirAll = 0L;
        visFileAll = 0L;
        ArrayList<Path> existing = new ArrayList<Path>();
        for (Movie movie : this.movieList.getMovies()) {
            existing.add(movie.getPathNIO());
        }
        try {
            TmmTask task;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
            if (this.movieFolders.isEmpty()) {
                for (String ds : this.dataSources) {
                    LOGGER.info("Start UDS on datasource: {}", (Object)ds);
                    this.miTasks.clear();
                    this.initThreadPool(3, "update");
                    this.setTaskName(BUNDLE.getString("update.datasource") + " '" + ds + "'");
                    this.publishState();
                    Path path = Paths.get(ds, new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    this.publishState();
                    ArrayList<Path> newMovieDirs = new ArrayList<Path>();
                    ArrayList<Path> existingMovieDirs = new ArrayList<Path>();
                    List<Path> rootList = MovieUpdateDatasourceTask.listFilesAndDirs(path);
                    if (rootList.isEmpty() && !Platform.isWindows()) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    ArrayList<Path> rootFiles = new ArrayList<Path>();
                    for (Path path2 : rootList) {
                        if (Files.isDirectory(path2, new LinkOption[0])) {
                            if (existing.contains(path2)) {
                                existingMovieDirs.add(path2);
                                continue;
                            }
                            newMovieDirs.add(path2);
                            continue;
                        }
                        rootFiles.add(path2);
                    }
                    rootList.clear();
                    this.publishState();
                    for (Path path2 : newMovieDirs) {
                        this.searchAndParse(path.toAbsolutePath(), path2, Integer.MAX_VALUE);
                    }
                    for (Path path2 : existingMovieDirs) {
                        this.searchAndParse(path.toAbsolutePath(), path2, Integer.MAX_VALUE);
                    }
                    if (!rootFiles.isEmpty()) {
                        this.submitTask(new parseMultiMovieDirTask(path.toAbsolutePath(), path.toAbsolutePath(), rootFiles));
                    }
                    this.waitForCompletionOrCancel();
                    LOGGER.info("FilesFound: {}", (Object)this.filesFound.size());
                    LOGGER.info("moviesFound: {}", (Object)this.movieList.getMovieCount());
                    LOGGER.debug("PreDir: {}", (Object)preDir);
                    LOGGER.debug("PostDir: {}", (Object)postDir);
                    LOGGER.debug("VisFile: {}", (Object)visFile);
                    LOGGER.debug("PreDirAll: {}", (Object)preDirAll);
                    LOGGER.debug("PostDirAll: {}", (Object)postDirAll);
                    LOGGER.debug("VisFileAll: {}", (Object)visFileAll);
                    newMovieDirs.clear();
                    existingMovieDirs.clear();
                    rootFiles.clear();
                    if (this.cancel) break;
                    this.cleanup(ds);
                    this.gatherMediainfo(ds);
                    if (!this.cancel) {
                        if (!MovieModuleManager.SETTINGS.isBuildImageCacheOnImport()) continue;
                        for (Movie movie : this.movieList.getMovies()) {
                            if (!path.equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
                            imageFiles.addAll(movie.getImagesToCache());
                        }
                        continue;
                    }
                    break;
                }
            } else {
                LOGGER.info("Start UDS for selected movies");
                this.initThreadPool(3, "update");
                this.setTaskName(BUNDLE.getString("update.datasource"));
                this.publishState();
                HashMap<Path, String> folder = new HashMap<Path, String>(this.movieFolders.size());
                for (Movie movie : this.movieFolders) {
                    folder.put(movie.getPathNIO(), movie.getDataSource());
                }
                for (Map.Entry entry : folder.entrySet()) {
                    Path dir = (Path)entry.getKey();
                    String ds = (String)entry.getValue();
                    this.submitTask(new FindMovieTask(dir, Paths.get(ds, new String[0])));
                }
                this.waitForCompletionOrCancel();
                LOGGER.info("FilesFound: {}", (Object)this.filesFound.size());
                LOGGER.info("moviesFound: {}", (Object)this.movieList.getMovieCount());
                LOGGER.debug("PreDir: {}", (Object)preDir);
                LOGGER.debug("PostDir: {}", (Object)postDir);
                LOGGER.debug("VisFile: {}", (Object)visFile);
                LOGGER.debug("PreDirAll: {}", (Object)preDirAll);
                LOGGER.debug("PostDirAll: {}", (Object)postDirAll);
                LOGGER.debug("VisFileAll: {}", (Object)visFileAll);
                this.cleanup(this.movieFolders);
                this.gatherMediainfo(this.movieFolders);
            }
            if (!imageFiles.isEmpty()) {
                task = new ImageCacheTask(imageFiles);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            if (MovieModuleManager.SETTINGS.getSyncTrakt()) {
                task = new SyncTraktTvTask(true, true, false, false);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took {}", (Object)stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void parseMovieDirectory(Path movieDir, Path dataSource) {
        List<Path> movieDirList = MovieUpdateDatasourceTask.listFilesAndDirs(movieDir);
        ArrayList<Path> files = new ArrayList<Path>();
        HashSet<String> normalizedVideoFiles = new HashSet<String>();
        boolean isDiscFolder = false;
        boolean isMultiMovieDir = false;
        boolean videoFileFound = false;
        Path movieRoot = movieDir;
        for (Path path : movieDirList) {
            if (!Utils.isRegularFile(path)) continue;
            files.add(path.toAbsolutePath());
            MediaFile mf = new MediaFile();
            mf.setPath(path.getParent().toString());
            mf.setFilename(path.getFileName().toString());
            mf.setType(MediaFileHelper.parseMediaFileType(path));
            if (mf.getType() != MediaFileType.VIDEO) continue;
            videoFileFound = true;
            if (mf.isDiscFile()) {
                isDiscFolder = true;
                break;
            }
            String basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
            normalizedVideoFiles.add(basename);
        }
        if (!videoFileFound) {
            return;
        }
        if (isDiscFolder) {
            Path relative = dataSource.relativize(movieDir);
            while (relative.toString().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || relative.toString().toUpperCase(Locale.ROOT).contains("BDMV")) {
                movieDir = movieDir.getParent();
                relative = dataSource.relativize(movieDir);
            }
            movieRoot = movieDir;
        } else {
            if (normalizedVideoFiles.isEmpty()) {
                return;
            }
            if (normalizedVideoFiles.size() > 1 || movieDir.equals(dataSource)) {
                isMultiMovieDir = true;
            }
        }
        if (this.cancel) {
            return;
        }
        if (isMultiMovieDir) {
            this.createMultiMovieFromDir(dataSource, movieRoot, files);
        } else {
            this.createSingleMovieFromDir(dataSource, movieRoot, isDiscFolder);
        }
    }

    protected Movie parseNFOs(List<MediaFile> mfs) {
        Movie movie = null;
        for (MediaFile mf : mfs) {
            if (!mf.getType().equals((Object)MediaFileType.NFO)) continue;
            LOGGER.info("| parsing NFO {}", (Object)mf.getFileAsPath());
            Movie nfo = null;
            try {
                MovieNfoParser movieNfoParser = MovieNfoParser.parseNfo(mf.getFileAsPath());
                nfo = movieNfoParser.toMovie();
            }
            catch (Exception e) {
                LOGGER.warn("problem parsing NFO: {}", (Object)e.getMessage());
            }
            if (movie == null) {
                movie = nfo == null ? new Movie() : nfo;
            } else {
                movie.merge(nfo);
            }
            if (!movie.getImdbId().isEmpty() && movie.getTmdbId() != 0) continue;
            try {
                String content = Utils.readFileToString(mf.getFileAsPath());
                String imdb = ParserUtils.detectImdbId(content);
                if (movie.getImdbId().isEmpty() && !imdb.isEmpty()) {
                    LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                    movie.setImdbId(imdb);
                }
                String tmdb = StrgUtils.substr(content, "themoviedb\\.org\\/movie\\/(\\d+)");
                if (movie.getTmdbId() != 0 || tmdb.isEmpty()) continue;
                LOGGER.debug("| Found TMDB id: {}", (Object)tmdb);
                movie.setTmdbId(MetadataUtil.parseInt(tmdb, 0));
            }
            catch (IOException e) {
                LOGGER.warn("| couldn't read NFO {}", (Object)mf);
            }
        }
        for (MediaFile mf : mfs) {
            if (!mf.getType().equals((Object)MediaFileType.VSMETA)) continue;
            if (movie == null) {
                movie = new Movie();
            }
            VSMeta vsmeta = new VSMeta(mf.getFileAsPath());
            vsmeta.parseFile();
            movie.merge(vsmeta.getMovie());
        }
        return movie;
    }

    private void createSingleMovieFromDir(Path dataSource, Path movieDir, boolean isDiscFolder) {
        LOGGER.info("Parsing single movie directory: {}, (are we a disc folder? {})", (Object)movieDir, (Object)isDiscFolder);
        Path relative = dataSource.relativize(movieDir);
        if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(movieDir.getFileName().toString())) {
            movieDir = movieDir.getParent();
        }
        Movie movie = this.movieList.getMovieByPath(movieDir);
        HashSet<Path> allFiles = MovieUpdateDatasourceTask.getAllFilesRecursive(movieDir, 5);
        this.filesFound.add(movieDir.toAbsolutePath());
        this.filesFound.addAll(allFiles);
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        allFiles.clear();
        if (movie == null) {
            LOGGER.debug("| movie not found; looking for NFOs");
            movie = this.parseNFOs(mfs);
            if (movie == null) {
                movie = new Movie();
            }
            movie.setNewlyAdded(true);
        }
        String bdinfoTitle = "";
        String videoName = "";
        for (MediaFile mf : mfs) {
            if (mf.getType().equals((Object)MediaFileType.TEXT)) {
                try {
                    String txtFile = Utils.readFileToString(mf.getFileAsPath());
                    String bdinfo = StrgUtils.substr(txtFile, ".*Disc Title:\\s+(.*?)[\\n\\r]");
                    if (!bdinfo.isEmpty()) {
                        LOGGER.debug("| Found Disc Title in BDInfo.txt: {}", (Object)bdinfo);
                        bdinfoTitle = WordUtils.capitalizeFully((String)bdinfo);
                    }
                    String imdb = ParserUtils.detectImdbId(txtFile);
                    if (!movie.getImdbId().isEmpty() || imdb.isEmpty()) continue;
                    LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                    movie.setImdbId(imdb);
                }
                catch (Exception e) {
                    LOGGER.warn("| couldn't read TXT {}", (Object)mf.getFilename());
                }
                continue;
            }
            if (!mf.getType().equals((Object)MediaFileType.VIDEO)) continue;
            videoName = mf.getBasename();
        }
        if (movie.getTitle().isEmpty()) {
            String[] video = ParserUtils.detectCleanTitleAndYear(movieDir.getFileName().toString(), MovieModuleManager.SETTINGS.getBadWord());
            movie.setTitle(video[0]);
            if (!video[1].isEmpty()) {
                try {
                    movie.setYear(Integer.parseInt(video[1]));
                }
                catch (Exception mf) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)movie.getTitle()) && StringUtils.isNotBlank((CharSequence)bdinfoTitle)) {
            movie.setTitle(bdinfoTitle);
        } else if (StringUtils.isBlank((CharSequence)movie.getTitle())) {
            movie.setTitle(videoName);
        }
        if (movie.isNewlyAdded()) {
            MediaFile vid;
            Object matcher = video3DPattern.matcher(movieDir.getFileName().toString());
            if (((Matcher)matcher).find()) {
                movie.setVideoIn3D(true);
            }
            if ((vid = this.getMediaFile(mfs, MediaFileType.VIDEO)) != null && ((Matcher)(matcher = video3DPattern.matcher(vid.getFilename()))).find()) {
                movie.setVideoIn3D(true);
            }
            if (movie.getEdition() == MovieEdition.NONE) {
                movie.setEdition(MovieEdition.getMovieEditionFromString(movieDir.getFileName().toString()));
            }
        }
        movie.setPath(movieDir.toAbsolutePath().toString());
        movie.setDataSource(dataSource.toString());
        if (movie.getMovieSet() != null) {
            LOGGER.debug("| movie is part of a movieset");
            movie.getMovieSet().insertMovie(movie);
            this.movieList.sortMoviesInMovieSet(movie.getMovieSet());
            movie.getMovieSet().saveToDb();
        }
        for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.UNKNOWN)) {
            for (MediaFile vid : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                if (!mf.getFilename().startsWith(vid.getFilename())) continue;
                mf.setType(MediaFileType.DOUBLE_EXT);
            }
        }
        this.addMediafilesToMovie(movie, mfs);
        if (movie.getArtworkFilename(MediaFileType.POSTER).isEmpty()) {
            for (MediaFile mf : mfs) {
                String vfilename;
                if (!mf.getType().equals((Object)MediaFileType.GRAPHIC)) continue;
                LOGGER.debug("| parsing unknown graphic: {}", (Object)mf.getFilename());
                List<MediaFile> vid = movie.getMediaFiles(MediaFileType.VIDEO);
                if (vid == null || vid.isEmpty() || !FilenameUtils.getBaseName((String)(vfilename = ((MediaFile)vid.get(0)).getFilename())).equals(FilenameUtils.getBaseName((String)mf.getFilename())) && !FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(vfilename)).trim().equals(FilenameUtils.getBaseName((String)mf.getFilename())) && !movie.getTitle().equals(FilenameUtils.getBaseName((String)mf.getFilename()))) continue;
                mf.setType(MediaFileType.POSTER);
                movie.addToMediaFiles(mf);
            }
        }
        boolean isOffline = false;
        boolean videoAvailable = false;
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
            videoAvailable = true;
            if (!"disc".equalsIgnoreCase(mf.getExtension())) continue;
            isOffline = true;
        }
        if (videoAvailable) {
            LOGGER.debug("| store movie into DB as: {}", (Object)movie.getTitle());
            this.movieList.addMovie(movie);
            movie.setOffline(isOffline);
            movie.reEvaluateStacking();
            movie.saveToDb();
        } else {
            LOGGER.error("could not add '{}' because no VIDEO file found", (Object)movieDir);
        }
        if (MovieModuleManager.SETTINGS.isExtractArtworkFromVsmeta()) {
            List<MediaFile> vsmetas = movie.getMediaFiles(MediaFileType.VSMETA);
            if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty() && !vsmetas.isEmpty() && !MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty()) {
                LOGGER.debug("extracting POSTERs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                MovieArtworkHelper.extractArtworkFromVsmeta(movie, vsmetas.get(0), MediaArtwork.MediaArtworkType.POSTER);
            }
            if (movie.getMediaFiles(MediaFileType.FANART).isEmpty() && !vsmetas.isEmpty() && !MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty()) {
                LOGGER.debug("extracting FANARTs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                MovieArtworkHelper.extractArtworkFromVsmeta(movie, vsmetas.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
            }
        }
    }

    private void createMultiMovieFromDir(Path dataSource, Path movieDir) {
        this.createMultiMovieFromDir(dataSource, movieDir, MovieUpdateDatasourceTask.listFilesOnly(movieDir));
    }

    private void createMultiMovieFromDir(Path dataSource, Path movieDir, List<Path> allFiles) {
        LOGGER.info("Parsing multi  movie directory: {}", (Object)movieDir);
        List<Movie> movies = this.movieList.getMoviesByPath(movieDir);
        this.filesFound.add(movieDir);
        this.filesFound.addAll(allFiles);
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        mfs.sort((file1, file2) -> file2.getFileAsPath().getFileName().toString().length() - file1.getFileAsPath().getFileName().toString().length());
        for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
            Movie movie = null;
            String basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
            ArrayList<MediaFile> sameName = new ArrayList<MediaFile>();
            LOGGER.trace("UDS: basename: {}", (Object)basename);
            for (MediaFile mediaFile : mfs) {
                String smBasename = FilenameUtils.getBaseName((String)mediaFile.getFilename());
                String smNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                if (!smBasename.equals(basename) && !smBasename.matches(smNameRegexp)) continue;
                if (mediaFile.getType() == MediaFileType.GRAPHIC) {
                    mediaFile.setType(MediaFileType.POSTER);
                }
                sameName.add(mediaFile);
                LOGGER.trace("UDS: found matching MF: {}", (Object)mediaFile);
            }
            for (Movie movie2 : movies) {
                if (!movie2.getMediaFiles(MediaFileType.VIDEO).contains(mf)) continue;
                LOGGER.debug("| found movie '{}' from MediaFile {}", (Object)movie2.getTitle(), (Object)mf);
                movie = movie2;
                break;
            }
            if (movie == null) {
                movie = this.parseNFOs(sameName);
                if (movie == null) {
                    LOGGER.debug("| Create new movie from file: {}", (Object)mf);
                    movie = new Movie();
                    String[] ty = ParserUtils.detectCleanTitleAndYear(basename, MovieModuleManager.SETTINGS.getBadWord());
                    movie.setTitle(ty[0]);
                    if (!ty[1].isEmpty()) {
                        try {
                            movie.setYear(Integer.parseInt((String)ty[1]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    movie.setEdition(MovieEdition.getMovieEditionFromString(basename));
                    Matcher matcher = video3DPattern.matcher(basename);
                    if (matcher.find()) {
                        movie.setVideoIn3D(true);
                    }
                }
                movie.setDataSource(dataSource.toString());
                movie.setNewlyAdded(true);
                movie.setPath(mf.getPath());
                movies.add(movie);
            }
            if (!Utils.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
            }
            LOGGER.debug("| parsing video file {}", (Object)mf.getFilename());
            movie.setMultiMovieDir(true);
            for (MediaFile mediaFile : this.getMediaFiles(sameName, MediaFileType.UNKNOWN)) {
                for (MediaFile vid : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                    if (!mediaFile.getFilename().startsWith(vid.getFilename())) continue;
                    mediaFile.setType(MediaFileType.DOUBLE_EXT);
                }
            }
            this.addMediafilesToMovie(movie, sameName);
            mfs.removeAll(sameName);
            boolean isOffline = false;
            for (MediaFile mediaFiles : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (!"disc".equalsIgnoreCase(mediaFiles.getExtension())) continue;
                isOffline = true;
            }
            movie.setOffline(isOffline);
            if (movie.getMovieSet() != null) {
                LOGGER.debug("| movie is part of a movieset");
                movie.getMovieSet().insertMovie(movie);
                this.movieList.sortMoviesInMovieSet(movie.getMovieSet());
                movie.getMovieSet().saveToDb();
            }
            if (MovieModuleManager.SETTINGS.isExtractArtworkFromVsmeta()) {
                List<MediaFile> list = movie.getMediaFiles(MediaFileType.VSMETA);
                if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty() && !list.isEmpty() && !MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty()) {
                    LOGGER.debug("extracting POSTERs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                    MovieArtworkHelper.extractArtworkFromVsmeta(movie, list.get(0), MediaArtwork.MediaArtworkType.POSTER);
                }
                if (movie.getMediaFiles(MediaFileType.FANART).isEmpty() && !list.isEmpty() && !MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty()) {
                    LOGGER.debug("extracting FANARTs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                    MovieArtworkHelper.extractArtworkFromVsmeta(movie, list.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
                }
            }
            this.movieList.addMovie(movie);
            movie.saveToDb();
        }
        for (Movie m : this.movieList.getMoviesByPath(movieDir)) {
            m.reEvaluateStacking();
            m.saveToDb();
        }
    }

    private void addMediafilesToMovie(Movie movie, List<MediaFile> mediaFiles) {
        ArrayList<MediaFile> current = new ArrayList<MediaFile>(movie.getMediaFiles());
        block8: for (MediaFile mf : mediaFiles) {
            if (current.contains(mf)) continue;
            if (mf.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || mf.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || mf.getPath().toUpperCase(Locale.ROOT).contains("HVDVD_TS") || mf.isDiscFile()) {
                movie.setDisc(true);
                if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getPath()));
                }
            }
            if (!Utils.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            LOGGER.debug("| parsing {} {}", (Object)mf.getType().name(), (Object)mf.getFileAsPath());
            switch (mf.getType()) {
                case VIDEO: {
                    movie.addToMediaFiles(mf);
                    if (movie.getMediaSource() != MediaSource.UNKNOWN) break;
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                    break;
                }
                case TRAILER: {
                    movie.addToMediaFiles(mf);
                    break;
                }
                case SUBTITLE: {
                    if (mf.isPacked()) break;
                    movie.addToMediaFiles(mf);
                    break;
                }
                case FANART: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrafanart")) {
                        LOGGER.warn("problem: detected media file type FANART in extrafanart folder: {}", (Object)mf.getPath());
                        continue block8;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case THUMB: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrathumbs")) {
                        LOGGER.warn("| problem: detected media file type THUMB in extrathumbs folder: {}", (Object)mf.getPath());
                        continue block8;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case EXTRA: 
                case SAMPLE: 
                case NFO: 
                case TEXT: 
                case POSTER: 
                case SEASON_POSTER: 
                case EXTRAFANART: 
                case EXTRATHUMB: 
                case AUDIO: 
                case DISC: 
                case BANNER: 
                case CLEARART: 
                case LOGO: 
                case CLEARLOGO: 
                case MEDIAINFO: 
                case VSMETA: 
                case THEME: 
                case CHARACTERART: 
                case KEYART: 
                case DOUBLE_EXT: {
                    movie.addToMediaFiles(mf);
                    break;
                }
                default: {
                    LOGGER.debug("| NOT adding unknown media file type: {}", (Object)mf.getFileAsPath());
                }
            }
            if (mf.getType() == MediaFileType.GRAPHIC || mf.getType() == MediaFileType.UNKNOWN || mf.getType() == MediaFileType.NFO || movie.getMediaFiles().contains(mf)) continue;
            LOGGER.error("| Movie not added mf: {}", (Object)mf.getFileAsPath());
        }
    }

    private void cleanup(String datasource) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            Path movieDir = movie.getPathNIO();
            if (!this.filesFound.contains(movieDir)) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '{}' not found, removing from DB...", (Object)movieDir);
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.warn("dir {} not in hashset, but on hdd!", (Object)movieDir);
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file from DB: {}", (Object)mf.getFileAsPath());
                        movie.removeFromMediaFiles(mf);
                        continue;
                    }
                    LOGGER.warn("file {} not in hashset, but on hdd!", (Object)mf.getFileAsPath());
                }
                if (movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    LOGGER.debug("Movie ({}) without VIDEO files detected, removing from DB...", (Object)movie.getTitle());
                    moviesToRemove.add(movie);
                    continue;
                }
                movie.saveToDb();
                continue;
            }
            LOGGER.info("Movie ({}) is new - no need for cleanup", (Object)movie.getTitle());
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void cleanup(List<Movie> movies) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = movies.size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = movies.get(i);
            Path movieDir = movie.getPathNIO();
            if (!this.filesFound.contains(movieDir)) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '{}' not found, removing from DB...", (Object)movieDir);
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.warn("dir {} not in hashset, but on hdd!", (Object)movieDir);
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file from DB: {}", (Object)mf.getFileAsPath());
                        movie.removeFromMediaFiles(mf);
                        continue;
                    }
                    LOGGER.warn("file {} not in hashset, but on hdd!", (Object)mf.getFileAsPath());
                }
                if (movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    LOGGER.debug("Movie ({}) without VIDEO files detected, removing from DB...", (Object)movie.getTitle());
                    moviesToRemove.add(movie);
                    continue;
                }
                movie.saveToDb();
                continue;
            }
            LOGGER.info("Movie ({}) is new - no need for cleanup", (Object)movie.getTitle());
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void gatherMediainfo(String datasource) {
        this.setTaskName(BUNDLE.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (Runnable task : this.miTasks) {
            this.submitTask(task);
        }
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            boolean dirty = false;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, movie, false));
                    continue;
                }
                MediaFileHelper.gatherFileInformation(mf);
                dirty = true;
            }
            if (!dirty) continue;
            movie.saveToDb();
        }
        this.waitForCompletionOrCancel();
    }

    private void gatherMediainfo(List<Movie> movies) {
        this.setTaskName(BUNDLE.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (Movie movie : movies) {
            if (this.cancel) break;
            boolean dirty = false;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, movie, false));
                    continue;
                }
                MediaFileHelper.gatherFileInformation(mf);
                dirty = true;
            }
            if (!dirty) continue;
            movie.saveToDb();
        }
        this.waitForCompletionOrCancel();
    }

    private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
        MediaFile mf = null;
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf = new MediaFile(mediaFile);
        }
        return mf;
    }

    private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf.add(new MediaFile(mediaFile));
        }
        return mf;
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public static List<Path> listFilesOnly(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (!Utils.isRegularFile(path)) continue;
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || MovieModuleManager.SETTINGS.getSkipFolder().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: {}", (Object)path);
            }
        }
        catch (IOException e) {
            LOGGER.error("error on listFilesOnly: {}", (Object)e.getMessage());
        }
        return fileNames;
    }

    public static List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || MovieModuleManager.SETTINGS.getSkipFolder().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: {}", (Object)path);
            }
        }
        catch (IOException e) {
            LOGGER.error("error on listFilesAndDirs: {}", (Object)e.getMessage());
        }
        return fileNames;
    }

    public static HashSet<Path> getAllFilesRecursive(Path folder, int deep) {
        folder = folder.toAbsolutePath();
        AllFilesRecursive visitor = new AllFilesRecursive();
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.fFound;
    }

    public void searchAndParse(Path datasource, Path folder, int deep) {
        folder = folder.toAbsolutePath();
        SearchAndParseVisitor visitor = new SearchAndParseVisitor(datasource);
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized void incVisFile() {
        ++visFile;
    }

    private static synchronized void incPreDir() {
        ++preDir;
    }

    private static synchronized void incPostDir() {
        ++postDir;
    }

    private class SearchAndParseVisitor
    extends AbstractFileVisitor {
        private Path datasource;
        private ArrayList<String> unstackedRoot = new ArrayList();
        private HashSet<Path> videofolders = new HashSet();

        SearchAndParseVisitor(Path datasource) {
            this.datasource = datasource;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            MovieUpdateDatasourceTask.incVisFile();
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(MovieUpdateDatasourceTask.skipRegex) && Globals.settings.getVideoFileType().contains("." + FilenameUtils.getExtension((String)file.toString()).toLowerCase(Locale.ROOT))) {
                if (file.getParent().getFileName().toString().equals("STREAM")) {
                    return FileVisitResult.CONTINUE;
                }
                MediaFile mf = new MediaFile(file);
                if (mf.getType() == MediaFileType.VIDEO) {
                    this.videofolders.add(file.getParent());
                } else {
                    LOGGER.debug("no VIDEO (is {}) - do not parse {}", (Object)mf.getType(), (Object)file);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            MovieUpdateDatasourceTask.incPreDir();
            String fn = dir.getFileName().toString().toUpperCase(Locale.ROOT);
            if (skipFolders.contains(fn) || fn.matches(MovieUpdateDatasourceTask.skipRegex) || Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || MovieModuleManager.SETTINGS.getSkipFolder().contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            MovieUpdateDatasourceTask.incPostDir();
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            if (this.videofolders.contains(dir)) {
                boolean update = true;
                Path relative = this.datasource.relativize(dir);
                if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(dir.getFileName().toString())) {
                    if (this.unstackedRoot.contains(dir.getParent().toString())) {
                        update = false;
                    } else {
                        this.unstackedRoot.add(dir.getParent().toString());
                    }
                }
                if (update) {
                    for (Path sub : this.videofolders) {
                        if (sub.equals(dir) || !sub.startsWith(dir)) continue;
                        List<Path> rootFiles = MovieUpdateDatasourceTask.listFilesOnly(dir);
                        MovieUpdateDatasourceTask.this.submitTask(new parseMultiMovieDirTask(this.datasource.toAbsolutePath(), dir, rootFiles));
                        MovieUpdateDatasourceTask.this.publishState();
                        return FileVisitResult.CONTINUE;
                    }
                    MovieUpdateDatasourceTask.this.submitTask(new FindMovieTask(dir, this.datasource));
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class AllFilesRecursive
    extends AbstractFileVisitor {
        private HashSet<Path> fFound = new HashSet();

        private AllFilesRecursive() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            MovieUpdateDatasourceTask.incVisFile();
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(MovieUpdateDatasourceTask.skipRegex)) {
                this.fFound.add(file.toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            MovieUpdateDatasourceTask.incPreDir();
            if (dir.getFileName() != null && (Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || skipFolders.contains(dir.getFileName().toString().toUpperCase(Locale.ROOT)) || dir.getFileName().toString().matches(MovieUpdateDatasourceTask.skipRegex)) || MovieModuleManager.SETTINGS.getSkipFolder().contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            MovieUpdateDatasourceTask.incPostDir();
            return FileVisitResult.CONTINUE;
        }
    }

    private class parseMultiMovieDirTask
    implements Callable<Object> {
        private Path movieDir = null;
        private Path datasource = null;
        private List<Path> allFiles = null;

        public parseMultiMovieDirTask(Path dataSource, Path movieDir, List<Path> allFiles) {
            this.datasource = dataSource;
            this.movieDir = movieDir;
            this.allFiles = allFiles;
        }

        @Override
        public String call() {
            MovieUpdateDatasourceTask.this.createMultiMovieFromDir(this.datasource, this.movieDir, this.allFiles);
            return this.movieDir.toString();
        }
    }

    private class FindMovieTask
    implements Callable<Object> {
        private Path subdir = null;
        private Path datasource = null;
        private long uniqueId;

        public FindMovieTask(Path subdir, Path datasource) {
            this.subdir = subdir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() {
            String name = Thread.currentThread().getName();
            if (!name.contains("-G")) {
                name = name + "-G0";
            }
            name = name.replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName(name);
            MovieUpdateDatasourceTask.this.parseMovieDirectory(this.subdir, this.datasource);
            return this.subdir.toString();
        }
    }
}

