/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.UrlUtil;

public class UpdaterTask
extends SwingWorker<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdaterTask.class);
    private final boolean useCache;
    private String changelog = "";
    private boolean forceUpdate = false;

    public UpdaterTask() {
        this(false);
    }

    public UpdaterTask(boolean useCache) {
        this.useCache = useCache;
    }

    @Override
    public Boolean doInBackground() {
        if (ReleaseInfo.isGitBuild()) {
            return false;
        }
        Path getdownFile = Paths.get("getdown.txt", new String[0]);
        Path digestFile = Paths.get("digest.txt", new String[0]);
        ArrayList<String> updateUrls = new ArrayList<String>();
        try {
            Thread.currentThread().setName("updateThread");
            LOGGER.info("Checking for updates...");
            for (String line : UpdaterTask.readLines(new FileReader(getdownFile.toFile()))) {
                String[] kv = line.split("=");
                if (!"appbase".equals(kv[0].trim()) && !"mirror".equals(kv[0].trim())) continue;
                updateUrls.add(kv[1].trim());
            }
            boolean valid = false;
            String remoteDigest = "";
            String remoteUrl = "";
            for (String uu : updateUrls) {
                if (!uu.endsWith("/")) {
                    uu = uu + '/';
                }
                String urlAsString = uu + "digest.txt";
                LOGGER.trace("Checking {}", (Object)uu);
                try {
                    Url url = this.useCache ? new OnDiskCachedUrl(urlAsString, 7, TimeUnit.DAYS) : new Url(urlAsString);
                    remoteDigest = UrlUtil.getStringFromUrl(url);
                    if (remoteDigest != null && remoteDigest.contains("tmm.jar")) {
                        remoteDigest = remoteDigest.trim();
                        valid = true;
                        remoteUrl = uu;
                    }
                }
                catch (InterruptedIOException | InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to download from url {} - {}", (Object)urlAsString, (Object)e.getMessage());
                }
                if (!valid) continue;
                break;
            }
            if (!valid) {
                throw new Exception("Error downloading remote checksum information.");
            }
            String localDigest = Utils.readFileToString(digestFile);
            if (!(localDigest = localDigest.trim()).equals(remoteDigest)) {
                LOGGER.info("Update needed...");
                String remoteGD = UrlUtil.getStringFromUrl(remoteUrl + "getdown.txt");
                if (remoteGD.contains("forceUpdate")) {
                    this.forceUpdate = true;
                }
                this.changelog = UrlUtil.getStringFromUrl(remoteUrl + "changelog.txt");
                return true;
            }
            LOGGER.info("Already up2date :)");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Update task failed badly! {}", (Object)e.getMessage());
            try {
                LOGGER.info("Trying fallback...");
                String fallback = "https://www.tinymediamanager.org";
                fallback = ReleaseInfo.isPreRelease() ? fallback + "/getdown_prerelease_v3.txt" : (ReleaseInfo.isNightly() ? fallback + "/getdown_nightly_v3.txt" : fallback + "/getdown_v3.txt");
                String gd = UrlUtil.getStringFromUrl(fallback);
                if (StringUtils.isBlank((CharSequence)gd) || !gd.contains("appbase")) {
                    throw new Exception("could not even download our fallback");
                }
                Utils.writeStringToFile(getdownFile, gd);
                return true;
            }
            catch (InterruptedIOException | InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e2) {
                LOGGER.error("Update fallback failed! {}", (Object)e2.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Update check failed :(", e2.getMessage()));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(Reader in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader bin = new BufferedReader(in);
            String line = null;
            while ((line = bin.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public boolean isForcedUpdate() {
        return this.forceUpdate;
    }
}

