/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class TmmTaskManager
implements TmmTaskListener {
    public final AtomicLong GLOB_THRD_CNT = new AtomicLong(1L);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final TmmTaskManager instance = new TmmTaskManager();
    private final Set<TmmTaskListener> taskListener = new CopyOnWriteArraySet<TmmTaskListener>();
    private final Set<TmmTaskHandle> runningTasks = new CopyOnWriteArraySet<TmmTaskHandle>();
    private ThreadPoolExecutor imageDownloadExecutor;
    private ThreadPoolExecutor unnamedTaskExecutor;
    private ThreadPoolExecutor downloadExecutor;
    private final ThreadPoolExecutor mainTaskExecutor = this.createMainTaskQueue();
    private TmmTaskHandle imageQueueHandle;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    private TmmTaskManager() {
        this.imageQueueHandle = new ImageQueueTaskHandle();
        Settings.getInstance().addPropertyChangeListener("maximumDownloadThreads", e -> {
            if (this.downloadExecutor != null) {
                this.downloadExecutor.setCorePoolSize(Settings.getInstance().getMaximumDownloadThreads());
                this.downloadExecutor.setMaximumPoolSize(Settings.getInstance().getMaximumDownloadThreads());
                this.downloadExecutor.prestartAllCoreThreads();
            }
        });
    }

    public static TmmTaskManager getInstance() {
        return instance;
    }

    public void addTaskListener(TmmTaskListener listener) {
        this.taskListener.add(listener);
    }

    public void removeTaskListener(TmmTaskListener listener) {
        this.taskListener.remove(listener);
    }

    private ThreadPoolExecutor createImageDownloadExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new TmmThreadPool.TmmThreadFactory("image-download-task")){

            @Override
            protected void beforeExecute(Thread d, Runnable r) {
                super.beforeExecute(d, r);
                if (TmmTaskManager.this.imageQueueHandle != null) {
                    TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageQueueHandle);
                }
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (TmmTaskManager.this.imageQueueHandle != null) {
                    TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageQueueHandle);
                }
            }
        };
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private ThreadPoolExecutor createUnnamedTaskExecutor() {
        int threadCount = Runtime.getRuntime().availableProcessors() - 1;
        if (threadCount < 3) {
            threadCount = 3;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new TmmThreadPool.TmmThreadFactory("unnamed-task")){};
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public void addImageDownloadTask(Runnable task) {
        if (this.imageDownloadExecutor == null || this.imageDownloadExecutor.isShutdown()) {
            this.imageDownloadExecutor = this.createImageDownloadExecutor();
        }
        this.imageDownloadExecutor.execute(task);
    }

    public void addUnnamedTask(TmmTask task) {
        if (this.unnamedTaskExecutor == null || this.unnamedTaskExecutor.isShutdown()) {
            this.unnamedTaskExecutor = this.createUnnamedTaskExecutor();
        }
        task.setState(TmmTaskHandle.TaskState.QUEUED);
        task.addListener(this);
        this.processTaskEvent(task);
        this.unnamedTaskExecutor.execute(task);
    }

    public void addUnnamedTask(Runnable task) {
        if (this.unnamedTaskExecutor == null || this.unnamedTaskExecutor.isShutdown()) {
            this.unnamedTaskExecutor = this.createUnnamedTaskExecutor();
        }
        this.unnamedTaskExecutor.execute(task);
    }

    public void addDownloadTask(TmmTask task) {
        if (this.downloadExecutor == null) {
            this.downloadExecutor = new ThreadPoolExecutor(Settings.getInstance().getMaximumDownloadThreads(), Settings.getInstance().getMaximumDownloadThreads(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TmmThreadPool.TmmThreadFactory("download-task"));
            this.downloadExecutor.allowCoreThreadTimeOut(true);
        }
        task.setState(TmmTaskHandle.TaskState.QUEUED);
        task.addListener(this);
        this.processTaskEvent(task);
        this.downloadExecutor.execute(task);
    }

    public void cancelImageDownloads() {
        if (this.imageDownloadExecutor != null) {
            this.imageDownloadExecutor.shutdownNow();
        }
    }

    public void cancelUnnamedTasks() {
        if (this.unnamedTaskExecutor != null) {
            this.unnamedTaskExecutor.shutdownNow();
        }
    }

    public void addMainTask(TmmThreadPool newTask) {
        newTask.setState(TmmTaskHandle.TaskState.QUEUED);
        newTask.addListener(this);
        this.processTaskEvent(newTask);
        this.mainTaskExecutor.execute(newTask);
    }

    private ThreadPoolExecutor createMainTaskQueue() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TmmThreadPool.TmmThreadFactory("main-task"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public void shutdown() {
        if (this.imageDownloadExecutor != null) {
            this.imageDownloadExecutor.shutdown();
        }
        if (this.unnamedTaskExecutor != null) {
            this.unnamedTaskExecutor.shutdown();
        }
        if (this.downloadExecutor != null) {
            this.downloadExecutor.shutdown();
        }
        if (this.mainTaskExecutor != null) {
            this.mainTaskExecutor.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        for (TmmTaskHandle task : this.runningTasks) {
            task.cancel();
        }
    }

    public void shutdownNow() {
        if (this.poolRunning()) {
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.imageDownloadExecutor != null && !this.imageDownloadExecutor.isTerminated()) {
            this.imageDownloadExecutor.shutdownNow();
        }
        if (this.unnamedTaskExecutor != null && !this.unnamedTaskExecutor.isTerminated()) {
            this.unnamedTaskExecutor.shutdownNow();
        }
        if (this.downloadExecutor != null && !this.downloadExecutor.isTerminated()) {
            this.downloadExecutor.shutdownNow();
        }
        if (this.mainTaskExecutor != null && !this.mainTaskExecutor.isTerminated()) {
            this.mainTaskExecutor.shutdownNow();
        }
        if (this.scheduler != null && !this.scheduler.isTerminated()) {
            this.scheduler.shutdownNow();
        }
    }

    public boolean poolRunning() {
        return this.checkForThreadAlive("tmmpool");
    }

    private boolean checkForThreadAlive(String contains) {
        for (Thread t : this.getAllThreads()) {
            if (!t.isAlive() || !this.getThreadName(t).contains(contains)) continue;
            return true;
        }
        return false;
    }

    private Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        int nAlloc = root.activeCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    private String getThreadName(Thread t) {
        return t != null && !TmmTaskManager.isEmpty(t.getName()) ? t.getName().toLowerCase(Locale.ROOT) : "";
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Override
    public void processTaskEvent(TmmTaskHandle task) {
        if (task.getState() == TmmTaskHandle.TaskState.STARTED) {
            this.runningTasks.add(task);
        }
        if (task.getState() == TmmTaskHandle.TaskState.FINISHED || task.getState() == TmmTaskHandle.TaskState.CANCELLED) {
            this.runningTasks.remove(task);
        }
        for (TmmTaskListener listener : this.taskListener) {
            listener.processTaskEvent(task);
        }
    }

    private class ImageQueueTaskHandle
    implements TmmTaskHandle {
        private ImageQueueTaskHandle() {
        }

        @Override
        public String getTaskName() {
            return BUNDLE.getString("task.imagedownloads");
        }

        @Override
        public int getWorkUnits() {
            int unit = 0;
            if (TmmTaskManager.this.imageDownloadExecutor != null) {
                unit = (int)TmmTaskManager.this.imageDownloadExecutor.getTaskCount();
            }
            return unit;
        }

        @Override
        public int getProgressDone() {
            int done = 0;
            if (TmmTaskManager.this.imageDownloadExecutor != null) {
                done = (int)TmmTaskManager.this.imageDownloadExecutor.getCompletedTaskCount();
            }
            return done;
        }

        @Override
        public String getTaskDescription() {
            return this.getOpenTasks() + " " + BUNDLE.getString("task.remaining");
        }

        private int getOpenTasks() {
            int openTasks = 0;
            if (TmmTaskManager.this.imageDownloadExecutor != null) {
                openTasks = TmmTaskManager.this.imageDownloadExecutor.getQueue().size() + TmmTaskManager.this.imageDownloadExecutor.getActiveCount();
            }
            return openTasks;
        }

        @Override
        public TmmTaskHandle.TaskState getState() {
            if (TmmTaskManager.this.imageQueueHandle != null && this.getOpenTasks() > 0) {
                return TmmTaskHandle.TaskState.STARTED;
            }
            return TmmTaskHandle.TaskState.FINISHED;
        }

        @Override
        public TmmTaskHandle.TaskType getType() {
            return TmmTaskHandle.TaskType.BACKGROUND_TASK;
        }

        @Override
        public void cancel() {
            TmmTaskManager.this.cancelImageDownloads();
            TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageQueueHandle);
        }

        public String toString() {
            return this.getType().name() + " image " + this.getState().name() + " " + this.getProgressDone() + "/" + this.getWorkUnits();
        }
    }
}

