/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.util.ParserUtils;

public class TvShowEpisodeAndSeasonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeAndSeasonParser.class);
    private static Pattern date1 = Pattern.compile("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", 2);
    private static Pattern date2 = Pattern.compile("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", 2);
    public static Pattern SEASON_PATTERN = Pattern.compile("(staffel|season|series)[\\s_.-]*(\\d{1,4})", 2);
    private static Pattern episodePattern = Pattern.compile("[epx_-]+(\\d{1,4})", 2);
    private static Pattern episodePattern2 = Pattern.compile("(?:episode|ep)[\\. _-]*(\\d{1,4})", 2);
    private static Pattern romanPattern = Pattern.compile("(part|pt)[\\._\\s]+([MDCLXVI]+)", 2);
    private static Pattern seasonMultiEP = Pattern.compile("s(\\d{1,4})[ ]?((?:([epx_.-]+\\d{1,4})+))", 2);
    private static Pattern seasonMultiEP2 = Pattern.compile("(\\d{1,4})(?=x)((?:([epx]+\\d{1,4})+))", 2);
    private static Pattern numbers2Pattern = Pattern.compile("([0-9]{2})", 2);
    private static Pattern numbers3Pattern = Pattern.compile("([0-9])([0-9]{2})", 2);
    private static Pattern tvMultipartMatching = Pattern.compile("^[-_ex]+([0-9]+(?:(?:[a-i]|\\.[1-9])(?![0-9]))?)", 2);

    public static String cleanEpisodeTitle(String titleToClean, String tvShowName) {
        String basename = FilenameUtils.getBaseName((String)ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(titleToClean));
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher(basename);
        if (m.find()) {
            basename = basename.replaceAll(regex.pattern(), "");
        }
        basename = basename + " ";
        if (tvShowName != null && !tvShowName.isEmpty()) {
            basename = basename.replaceAll("(?i)^" + Pattern.quote(tvShowName) + "", "");
            basename = basename.replaceAll("(?i) " + Pattern.quote(tvShowName) + " ", "");
        }
        basename = basename.replaceFirst("\\.\\w{1,4}$", "");
        basename = basename.replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        return TvShowEpisodeAndSeasonParser.removeEpisodeVariantsFromTitle(basename);
    }

    private static String removeEpisodeVariantsFromTitle(String title) {
        String[] splitted;
        StringBuilder backup = new StringBuilder(title);
        StringBuilder ret = new StringBuilder();
        title = title.replaceAll("[Ss]([0-9]+)[\\]\\[ _.-]*[Ee]([0-9]+)", "");
        title = title.replaceAll("[ _.-]()[Ee][Pp]?_?([0-9]+)", "");
        title = title.replaceAll("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", "");
        title = title.replaceAll("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", "");
        title = title.replaceAll("[\\\\/\\._ \\[\\(-]([0-9]+)x([0-9]+)", "");
        title = title.replaceAll("[\\/ _.-]p(?:ar)?t[ _.-]()([ivx]+)", "");
        title = title.replaceAll("[epx_-]+(\\d{1,3})", "");
        title = title.replaceAll("episode[\\. _-]*(\\d{1,3})", "");
        title = title.replaceAll("(part|pt)[\\._\\s]+([MDCLXVI]+)", "");
        title = title.replaceAll("(staffel|season|series)[\\s_.-]*(\\d{1,4})", "");
        title = title.replaceAll("s(\\d{1,4})[ ]?((?:([epx_.-]+\\d{1,3})+))", "");
        title = title.replaceAll("(\\d{1,4})(?=x)((?:([epx]+\\d{1,3})+))", "");
        for (String s : splitted = StringUtils.split((String)title, (String)"[\\[\\]() _,.-]")) {
            ret.append(" ").append(s);
        }
        if (StringUtils.isEmpty((CharSequence)(ret = new StringBuilder(ret.toString().trim())).toString())) {
            String[] b = StringUtils.split((String)backup.toString(), (String)"[\\[\\]() _,.-]");
            backup = new StringBuilder();
            for (String s : b) {
                backup.append(" ").append(s);
            }
            ret = new StringBuilder(backup.toString().trim());
        }
        return ret.toString();
    }

    public static EpisodeMatchingResult detectEpisodeFromFilenameAlternative(String name, String showname) {
        EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detect(FilenameUtils.getName((String)name), showname);
        if (!result.episodes.isEmpty() && result.season == -1) {
            EpisodeMatchingResult result2 = TvShowEpisodeAndSeasonParser.detect(name, showname);
            result.season = result2.season;
        } else if (result.season == -1 && result.episodes.isEmpty()) {
            result = TvShowEpisodeAndSeasonParser.detect(name, showname);
        }
        return result;
    }

    public static EpisodeMatchingResult detect(String name, String showname) {
        int ep;
        String[] numbersOnly;
        int ep2;
        Matcher m2;
        Pattern regex2;
        String eps2;
        LOGGER.debug("parsing '" + name + "'");
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        String filename = FilenameUtils.getName((String)name);
        String extension = FilenameUtils.getExtension((String)name);
        if (filename.toLowerCase(Locale.ROOT).matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)") || filename.toLowerCase(Locale.ROOT).matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts)")) {
            name = FilenameUtils.getPath((String)name);
        }
        String basename = ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(name);
        String foldername = "";
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher(basename);
        if (m.find()) {
            foldername = m.group(1);
            basename = basename.replaceAll(regex.pattern(), "");
        }
        if (basename.isEmpty() && foldername.isEmpty()) {
            return result;
        }
        if (showname != null && !showname.isEmpty()) {
            basename = basename.replaceAll("(?i)^" + Pattern.quote(showname) + "", "");
            basename = basename.replaceAll("(?i) " + Pattern.quote(showname) + " ", "");
        }
        basename = basename.replaceFirst("\\.\\w{1,4}$", "");
        basename = basename.replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        basename = basename + " ";
        result.stackingMarkerFound = !Utils.getStackingMarker(filename).isEmpty();
        result.name = basename.trim();
        if (result.season == -1 && (m = (regex = SEASON_PATTERN).matcher(foldername + basename)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found season {}", (Object)s);
        }
        regex = seasonMultiEP;
        m = regex.matcher(foldername + basename);
        int lastFoundEpisode = 0;
        while (m.find()) {
            int s = -1;
            try {
                s = Integer.parseInt(m.group(1));
                eps2 = m.group(2);
                regex2 = episodePattern;
                m2 = regex2.matcher(eps2);
                while (m2.find()) {
                    ep2 = 0;
                    try {
                        ep2 = Integer.parseInt(m2.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (ep2 <= 0 || result.episodes.contains(ep2) || lastFoundEpisode != 0 && lastFoundEpisode + 1 != ep2) continue;
                    lastFoundEpisode = ep2;
                    result.episodes.add(ep2);
                    LOGGER.trace("add found EP " + ep2);
                }
            }
            catch (NumberFormatException eps2) {
                // empty catch block
            }
            if (s < 0) continue;
            result.season = s;
            LOGGER.trace("add found season " + s);
        }
        regex = seasonMultiEP2;
        m = regex.matcher(foldername + basename);
        while (m.find()) {
            int s = -1;
            try {
                if (m.group(2) != null && result.season == -1) {
                    s = Integer.parseInt(m.group(1));
                }
                eps2 = m.group(2);
                regex2 = episodePattern;
                m2 = regex2.matcher(eps2);
                while (m2.find()) {
                    ep2 = 0;
                    try {
                        ep2 = Integer.parseInt(m2.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (ep2 <= 0 || result.episodes.contains(ep2)) continue;
                    result.episodes.add(ep2);
                    LOGGER.trace("add found EP " + ep2);
                }
            }
            catch (NumberFormatException eps3) {
                // empty catch block
            }
            if (s < 0) continue;
            result.season = s;
            LOGGER.trace("add found season " + s);
        }
        if (result.episodes.isEmpty()) {
            regex = episodePattern2;
            m = regex.matcher(basename);
            while (m.find()) {
                int ep3 = 0;
                try {
                    ep3 = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException eps3) {
                    // empty catch block
                }
                if (ep3 <= 0 || result.episodes.contains(ep3)) continue;
                result.episodes.add(ep3);
                LOGGER.trace("add found EP " + ep3);
            }
        }
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        if (result.episodes.isEmpty()) {
            regex = romanPattern;
            m = regex.matcher(basename);
            while (m.find()) {
                int ep4 = 0;
                ep4 = TvShowEpisodeAndSeasonParser.decodeRoman(m.group(2));
                if (ep4 <= 0 || result.episodes.contains(ep4)) continue;
                result.episodes.add(ep4);
                LOGGER.trace("add found EP " + ep4);
            }
        }
        if (result.season == -1 && (m = date1.matcher(basename)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(1));
                result.date = new SimpleDateFormat("yyyy-MM-dd").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException eps3) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season " + s + " date: " + result.date);
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        if (result.season == -1 && (m = date2.matcher(basename)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(3));
                result.date = new SimpleDateFormat("dd-MM-yyyy").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException eps3) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season " + s + " date: " + result.date);
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        String delimitedNumbers = basename.replaceAll("\\|", "_");
        delimitedNumbers = delimitedNumbers.replaceAll("(\\d+)", "$1|");
        delimitedNumbers = delimitedNumbers.replaceAll("[^0-9\\|]", "");
        for (String num : numbersOnly = delimitedNumbers.split("\\|")) {
            if (num.length() != 3) continue;
            int s = Integer.parseInt(num.substring(0, 1));
            int ep5 = Integer.parseInt(num.substring(1));
            if (ep5 > 0 && !result.episodes.contains(ep5)) {
                result.episodes.add(ep5);
                LOGGER.trace("add found EP " + ep5);
            }
            LOGGER.trace("add found season " + s);
            result.season = s;
        }
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        for (String num : numbersOnly) {
            if (num.length() != 2) continue;
            ep = Integer.parseInt(num);
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP " + ep);
            }
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        for (String num : numbersOnly) {
            if (num.length() != 1) continue;
            ep = Integer.parseInt(num);
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP " + ep);
            }
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        return TvShowEpisodeAndSeasonParser.postClean(result);
    }

    private static EpisodeMatchingResult postClean(EpisodeMatchingResult emr) {
        emr.cleanedName = TvShowEpisodeAndSeasonParser.cleanFilename(emr.name, new Pattern[]{SEASON_PATTERN, seasonMultiEP, seasonMultiEP2, episodePattern, episodePattern2, numbers3Pattern, numbers2Pattern, romanPattern, date1, date2});
        Collections.sort(emr.episodes);
        LOGGER.debug("returning result " + emr);
        return emr;
    }

    private static String cleanFilename(String name, Pattern[] patterns) {
        String result = name;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(result);
            if (!matcher.find()) continue;
            result = matcher.replaceFirst("");
        }
        result = result.replaceAll("^[ \\.\\-_]+", "");
        result = result.replaceAll("[ \\.\\-_]+$", "");
        return result;
    }

    private static int decodeSingleRoman(char letter) {
        switch (letter) {
            case 'M': {
                return 1000;
            }
            case 'D': {
                return 500;
            }
            case 'C': {
                return 100;
            }
            case 'L': {
                return 50;
            }
            case 'X': {
                return 10;
            }
            case 'V': {
                return 5;
            }
            case 'I': {
                return 1;
            }
        }
        return 0;
    }

    public static int decodeRoman(String roman) {
        int result = 0;
        String uRoman = roman.toUpperCase(Locale.ROOT);
        for (int i = 0; i < uRoman.length() - 1; ++i) {
            if (TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i)) < TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i + 1))) {
                result -= TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
                continue;
            }
            result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
        }
        return result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(uRoman.length() - 1));
    }

    public static class EpisodeMatchingResult {
        public int season = -1;
        public List<Integer> episodes = new ArrayList<Integer>();
        public String name = "";
        public String cleanedName = "";
        public Date date = null;
        public boolean stackingMarkerFound = false;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

