/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.Token;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamer.class);
    private static final TvShowSettings SETTINGS = TvShowModuleManager.SETTINGS;
    private static final String[] seasonNumbers = new String[]{"seasonNr", "seasonNr2", "seasonNrDvd", "seasonNrDvd2"};
    private static final String[] episodeNumbers = new String[]{"episodeNr", "episodeNr2", "episodeNrDvd", "episodeNrDvd2"};
    private static final String[] episodeTitles = new String[]{"title", "titleSortable"};
    private static final String[] showTitles = new String[]{"showTitle", "showTitleSortable"};
    private static final Pattern epDelimiter = Pattern.compile("(\\s?(folge|episode|[epx]+)\\s?)\\$\\{.*?\\}", 2);
    private static final Pattern seDelimiter = Pattern.compile("((staffel|season|s)\\s?)\\$\\{.*?\\}", 2);
    public static final Map<String, String> TOKEN_MAP = TvShowRenamer.createTokenMap();

    private static Map<String, String> createTokenMap() {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("showTitle", "tvShow.title");
        tokenMap.put("showOriginalTitle", "tvShow.originalTitle");
        tokenMap.put("showTitleSortable", "tvShow.titleSortable");
        tokenMap.put("showYear", "tvShow.year");
        tokenMap.put("parent", "tvShow.parent");
        tokenMap.put("showNote", "tvShow.note");
        tokenMap.put("seasonName", "season.title");
        tokenMap.put("episodeNr", "episode.episode");
        tokenMap.put("episodeNr2", "episode.episode;number(%02d)");
        tokenMap.put("episodeNrDvd", "episode.dvdEpisode");
        tokenMap.put("episodeNrDvd2", "episode.dvdEpisode;number(%02d)");
        tokenMap.put("seasonNr", "episode.season;number(%d)");
        tokenMap.put("seasonNr2", "episode.season;number(%02d)");
        tokenMap.put("seasonNrDvd", "episode.dvdSeason;number(%d)");
        tokenMap.put("seasonNrDvd2", "episode.dvdSeason;number(%02d)");
        tokenMap.put("title", "episode.title");
        tokenMap.put("originalTitle", "episode.originalTitle");
        tokenMap.put("titleSortable", "episode.titleSortable");
        tokenMap.put("year", "episode.year");
        tokenMap.put("airedDate", "episode.firstAired;date(yyyy-MM-dd)");
        tokenMap.put("videoCodec", "episode.mediaInfoVideoCodec");
        tokenMap.put("videoFormat", "episode.mediaInfoVideoFormat");
        tokenMap.put("videoResolution", "episode.mediaInfoVideoResolution");
        tokenMap.put("videoBitDepth", "episode.mediaInfoVideoBitDepth");
        tokenMap.put("audioCodec", "episode.mediaInfoAudioCodec");
        tokenMap.put("audioCodecList", "episode.mediaInfoAudioCodecList");
        tokenMap.put("audioCodecsAsString", "episode.mediaInfoAudioCodecList;array");
        tokenMap.put("audioChannels", "episode.mediaInfoAudioChannels");
        tokenMap.put("audioChannelList", "episode.mediaInfoAudioChannelList");
        tokenMap.put("audioChannelsAsString", "episode.mediaInfoAudioChannelList;array");
        tokenMap.put("audioLanguage", "episode.mediaInfoAudioLanguage");
        tokenMap.put("audioLanguageList", "episode.mediaInfoAudioLanguageList");
        tokenMap.put("audioLanguagesAsString", "episode.mediaInfoAudioLanguageList;array");
        tokenMap.put("subtitleLanguageList", "episode.mediaInfoSubtitleLanguageList");
        tokenMap.put("subtitleLanguagesAsString", "episode.mediaInfoSubtitleLanguageList;array");
        tokenMap.put("3Dformat", "episode.video3DFormat");
        tokenMap.put("hdr", "episode.videoHDRFormat");
        tokenMap.put("filesize", "episode.videoFilesize;filesize");
        tokenMap.put("mediaSource", "episode.mediaSource");
        tokenMap.put("note", "episode.note");
        return tokenMap;
    }

    static String morphTemplate(String template) {
        Matcher matcher;
        Pattern pattern;
        String morphedTemplate = template;
        for (Map.Entry<String, String> entry : TOKEN_MAP.entrySet()) {
            pattern = Pattern.compile("\\$\\{" + entry.getKey() + "([^a-zA-Z0-9])", 2);
            matcher = pattern.matcher(morphedTemplate);
            while (matcher.find()) {
                morphedTemplate = morphedTemplate.replace(matcher.group(), "${" + entry.getValue() + matcher.group(1));
            }
        }
        for (Map.Entry<String, String> entry : TOKEN_MAP.entrySet()) {
            pattern = Pattern.compile("\\$\\{(.*?)," + entry.getKey() + "([^a-zA-Z0-9])", 2);
            matcher = pattern.matcher(morphedTemplate);
            while (matcher.find()) {
                morphedTemplate = morphedTemplate.replace(matcher.group(), "${" + matcher.group(1) + "," + entry.getValue() + matcher.group(2));
            }
        }
        morphedTemplate = morphedTemplate.replaceAll("\\\\(?![{}])", "\\\\\\\\");
        return morphedTemplate;
    }

    private static String lz(int num) {
        return String.format("%02d", num);
    }

    public static void renameTvShowRoot(TvShow show) {
        if (SETTINGS.getRenamerFilename().isEmpty() && SETTINGS.getRenamerSeasonFoldername().isEmpty() && SETTINGS.getRenamerTvShowFoldername().isEmpty()) {
            LOGGER.info("NOT renaming TvShow '{}' - renaming patterns are empty!", (Object)show.getTitle());
            return;
        }
        LOGGER.debug("TV show year: {}", (Object)show.getYear());
        LOGGER.debug("TV show path: {}", (Object)show.getPathNIO());
        String newPathname = TvShowRenamer.getTvShowFoldername(SETTINGS.getRenamerTvShowFoldername(), show);
        String oldPathname = show.getPathNIO().toString();
        if (!newPathname.isEmpty()) {
            Path srcDir = Paths.get(oldPathname, new String[0]);
            Path destDir = Paths.get(newPathname, new String[0]);
            if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
                try {
                    boolean ok;
                    for (MediaFile gfx : show.getMediaFiles()) {
                        ImageCache.invalidateCachedImage(gfx);
                    }
                    if (!Files.exists(destDir.getParent(), new LinkOption[0])) {
                        Files.createDirectory(destDir.getParent(), new FileAttribute[0]);
                    }
                    if (ok = Utils.moveDirectorySafe(srcDir, destDir)) {
                        show.updateMediaFilePath(srcDir, destDir);
                        show.setPath(newPathname);
                        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                            episode.replacePathForRenamedFolder(srcDir, destDir);
                            episode.updateMediaFilePath(srcDir, destDir);
                        }
                        show.saveToDb();
                        if (Settings.getInstance().isImageCache()) {
                            for (MediaFile gfx : show.getMediaFiles()) {
                                ImageCache.cacheImageSilently(gfx);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("error moving folder: {}", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
        TvShowRenamer.renameSeasonArtwork(show);
    }

    private static void renameSeasonArtwork(TvShow tvShow) {
        LinkedHashSet<MediaFile> needed = new LinkedHashSet<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        List<MediaArtwork.MediaArtworkType> types = Arrays.asList(MediaArtwork.MediaArtworkType.SEASON_POSTER, MediaArtwork.MediaArtworkType.SEASON_BANNER, MediaArtwork.MediaArtworkType.SEASON_THUMB);
        for (MediaArtwork.MediaArtworkType type : types) {
            Map<Integer, MediaFile> artwork = tvShow.getSeasonArtworks(type);
            block15: for (Map.Entry<Integer, MediaFile> entry : artwork.entrySet()) {
                Integer season = entry.getKey();
                MediaFile mf = entry.getValue();
                cleanup.add(mf);
                switch (type) {
                    case SEASON_POSTER: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonPosterNaming tvShowSeasonPosterNaming : SETTINGS.getSeasonPosterFilenames()) {
                            filename = tvShowSeasonPosterNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block15;
                    }
                    case SEASON_BANNER: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonBannerNaming tvShowSeasonBannerNaming : SETTINGS.getSeasonBannerFilenames()) {
                            filename = tvShowSeasonBannerNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block15;
                    }
                    case SEASON_THUMB: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonThumbNaming tvShowSeasonThumbNaming : SETTINGS.getSeasonThumbFilenames()) {
                            filename = tvShowSeasonThumbNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block15;
                    }
                    default: {
                        continue block15;
                    }
                }
            }
        }
        for (MediaFile gfx : tvShow.getMediaFiles()) {
            ImageCache.invalidateCachedImage(gfx);
        }
        LOGGER.info("Cleanup...");
        List<Path> existingFiles = Utils.listFilesRecursive(tvShow.getPathNIO());
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            if (needed.contains(cleanup.get(i))) continue;
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (existingFiles.contains(cl.getFileAsPath())) {
                LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                Utils.deleteFileWithBackup(cl.getFileAsPath(), tvShow.getDataSource());
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.error("cleanup of {} - {}", (Object)cl.getFileAsPath(), (Object)e.getMessage());
            }
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(tvShow.getPathNIO());
        }
        catch (Exception e) {
            LOGGER.warn("could not delete empty subfolders: {}", (Object)e.getMessage());
        }
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : tvShow.getMediaFiles()) {
                ImageCache.cacheImageSilently(gfx);
            }
        }
        tvShow.addToMediaFiles(new ArrayList<MediaFile>(needed));
        tvShow.saveToDb();
    }

    /*
     * WARNING - void declaration
     */
    public static void renameEpisode(TvShowEpisode episode) {
        void var9_22;
        void var7_11;
        if (SETTINGS.getRenamerFilename().isEmpty() && SETTINGS.getRenamerSeasonFoldername().isEmpty()) {
            LOGGER.info("NOT renaming TvShow '{}' Episode {} - renaming patterns are empty!", (Object)episode.getTvShow().getTitle(), (Object)episode.getEpisode());
            return;
        }
        MediaFile originalVideoMediaFile = new MediaFile(episode.getMainVideoFile());
        if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
            LOGGER.warn("failed to rename episode {} (TV show {}) - invalid season/episode number", (Object)episode.getTitle(), (Object)episode.getTvShow().getTitle());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode.getTvShow().getTitle(), "tvshow.renamer.failedrename", new String[]{episode.getTitle()}));
            return;
        }
        LOGGER.info("Renaming TvShow '{}', Episode {}", (Object)episode.getTvShow().getTitle(), (Object)episode.getEpisode());
        if (episode.isDisc()) {
            TvShowRenamer.renameEpisodeAsDisc(episode);
            return;
        }
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>(episode.getMediaFiles());
        cleanup.removeAll(Collections.singleton(null));
        String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
        Path seasonFolder = episode.getTvShow().getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonFoldername) && !Files.exists(seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername), new LinkOption[0])) {
            try {
                Files.createDirectory(seasonFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO)) {
            LOGGER.trace("Rename 1:1 {} {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            MediaFile newMF = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile).get(0);
            boolean bl = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), newMF.getFileAsPath());
            if (bl) {
                mediaFile.setFile(newMF.getFileAsPath());
                episode.setPath(newMF.getPath());
            }
            needed.add(mediaFile);
        }
        ArrayList<Object> mfs = new ArrayList<MediaFile>();
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.FANART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.POSTER));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.BANNER));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CLEARART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.THUMB));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.LOGO));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CLEARLOGO));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.DISC));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CHARACTERART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.KEYART));
        mfs.removeAll(Collections.singleton(null));
        for (Object mf : mfs) {
            LOGGER.trace("Rename 1:N {} {}", (Object)((MediaFile)mf).getType(), (Object)((MediaFile)mf).getFileAsPath());
            List<MediaFile> list = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), (MediaFile)mf);
            for (MediaFile newMF : list) {
                boolean ok = TvShowRenamer.copyFile(((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath());
                if (!ok) continue;
                needed.add(newMF);
            }
        }
        MediaFile mediaFile = new MediaFile();
        for (MediaFile mediaFile2 : episode.getMediaFiles(MediaFileType.NFO)) {
            if (mediaFile2.getFiledate() < var7_11.getFiledate()) continue;
            MediaFile mediaFile3 = new MediaFile(mediaFile2);
        }
        if (var7_11.getFiledate() > 0L) {
            List<MediaFile> newNFOs = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), (MediaFile)var7_11);
            if (!newNFOs.isEmpty()) {
                Iterator<MediaFile> iterator = newNFOs.iterator();
                while (iterator.hasNext()) {
                    MediaFile newNFO = iterator.next();
                    boolean ok = TvShowRenamer.copyFile(var7_11.getFileAsPath(), newNFO.getFileAsPath());
                    if (!ok) continue;
                    needed.add(newNFO);
                }
            } else {
                cleanup.add((MediaFile)var7_11);
            }
        } else {
            LOGGER.trace("No valid NFO found for this episode");
        }
        for (MediaFile mediaFile4 : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
            LOGGER.trace("Rename 1:1 {} {}", (Object)mediaFile4.getType(), (Object)mediaFile4.getFileAsPath());
            MediaFile sub = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile4).get(0);
            boolean ok = TvShowRenamer.moveFile(mediaFile4.getFileAsPath(), sub.getFileAsPath());
            if (ok) {
                if (sub.getFilename().endsWith(".sub")) {
                    try {
                        Path oldidx = mediaFile4.getFileAsPath().resolveSibling(mediaFile4.getFilename().replaceFirst("sub$", "idx"));
                        Path newidx = sub.getFileAsPath().resolveSibling(sub.getFilename().replaceFirst("sub$", "idx"));
                        Utils.moveFileSafe(oldidx, newidx);
                    }
                    catch (Exception oldidx) {
                        // empty catch block
                    }
                }
                mediaFile4.setFile(sub.getFileAsPath());
            }
            needed.add(mediaFile4);
        }
        mfs = new ArrayList<MediaFile>(episode.getMediaFilesExceptType(MediaFileType.VIDEO, MediaFileType.NFO, MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.DISC, MediaFileType.CHARACTERART, MediaFileType.KEYART, MediaFileType.SUBTITLE));
        mfs.removeAll(Collections.singleton(null));
        for (MediaFile mediaFile5 : mfs) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile5.getType(), (Object)mediaFile5.getFileAsPath());
            List<MediaFile> newMFs = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile5);
            newMFs.removeAll(Collections.singleton(null));
            for (MediaFile newMF : newMFs) {
                boolean ok = TvShowRenamer.copyFile(mediaFile5.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    needed.add(newMF);
                    continue;
                }
                needed.add(mediaFile5);
            }
        }
        for (MediaFile mediaFile6 : episode.getMediaFiles()) {
            ImageCache.invalidateCachedImage(mediaFile6);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        LOGGER.info("Cleanup...");
        int n = cleanup.size() - 1;
        while (var9_22 >= 0) {
            if (!needed.contains(cleanup.get((int)var9_22))) {
                MediaFile cl = cleanup.get((int)var9_22);
                if (Files.exists(cl.getFileAsPath(), new LinkOption[0])) {
                    LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                    Utils.deleteFileWithBackup(cl.getFileAsPath(), episode.getTvShow().getDataSource());
                }
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                    if (!directoryStream.iterator().hasNext()) {
                        LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                        Files.delete(cl.getFileAsPath().getParent());
                    }
                }
                catch (IOException e) {
                    LOGGER.error("cleanup of {} - {}", (Object)cl.getFileAsPath(), (Object)e.getMessage());
                }
            }
            --var9_22;
        }
        ArrayList<TvShowEpisode> arrayList = new ArrayList<TvShowEpisode>();
        arrayList.add(episode);
        arrayList.addAll(TvShowList.getTvEpisodesByFile(episode.getTvShow(), originalVideoMediaFile.getFile()));
        for (TvShowEpisode e : arrayList) {
            e.removeAllMediaFiles();
            e.addToMediaFiles(needed);
            e.setPath(episode.getPath());
            e.gatherMediaFileInformation(false);
            e.saveToDb();
            if (!Settings.getInstance().isImageCache()) continue;
            for (MediaFile gfx : e.getMediaFiles()) {
                ImageCache.cacheImageSilently(gfx);
            }
        }
    }

    private static void renameEpisodeAsDisc(TvShowEpisode episode) {
        block13: {
            String newFoldername;
            MediaFile mf = episode.getMainVideoFile();
            List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(episode.getTvShow(), mf.getFile());
            if (!episode.isDisc() || !mf.isDiscFile()) {
                return;
            }
            Path disc = mf.getFileAsPath().getParent();
            Path epFolder = disc.getParent();
            if (!(disc.getFileName().toString().equalsIgnoreCase("BDMV") || disc.getFileName().toString().equalsIgnoreCase("VIDEO_TS") || disc.getFileName().toString().equalsIgnoreCase("HVDVD_TS"))) {
                LOGGER.error("Episode is labeled as 'on BD/DVD', but structure seems not to match. Better exit and do nothing... o_O");
                return;
            }
            String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
            Path seasonFolder = episode.getTvShow().getPathNIO();
            if (StringUtils.isNotBlank((CharSequence)seasonFoldername) && !Files.exists(seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername), new LinkOption[0])) {
                try {
                    Files.createDirectory(seasonFolder, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank((CharSequence)(newFoldername = FilenameUtils.getBaseName((String)TvShowRenamer.generateFoldername(episode.getTvShow(), mf))))) {
                LOGGER.warn("empty disc folder name - exiting");
                return;
            }
            Path newEpFolder = seasonFolder.resolve(newFoldername);
            Path newDisc = newEpFolder.resolve(disc.getFileName());
            try {
                if (epFolder.toAbsolutePath().toString().equals(newEpFolder.toAbsolutePath().toString())) break block13;
                boolean ok = false;
                try {
                    if (!Files.exists(newEpFolder.getParent(), new LinkOption[0])) {
                        Files.createDirectory(newEpFolder.getParent(), new FileAttribute[0]);
                    }
                    ok = Utils.moveDirectorySafe(epFolder, newEpFolder);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)epFolder, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
                if (ok) {
                    LOGGER.debug("updating *all* MFs for new path -> {}", (Object)newEpFolder);
                    for (TvShowEpisode e : eps) {
                        e.updateMediaFilePath(disc, newDisc);
                        e.setPath(newEpFolder.toAbsolutePath().toString());
                        e.saveToDb();
                    }
                }
                TvShowRenamer.cleanEmptyDir(epFolder);
            }
            catch (Exception e) {
                LOGGER.error("error moving video file " + disc + " to " + newFoldername, (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    private static void cleanEmptyDir(Path dir) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            if (!directoryStream.iterator().hasNext()) {
                LOGGER.debug("Deleting empty Directory - {}", (Object)dir);
                Files.delete(dir);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String generateFoldername(TvShow tvShow, MediaFile mf) {
        List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile());
        if (ListUtils.isEmpty(eps)) {
            return "";
        }
        return TvShowRenamer.createDestination(SETTINGS.getRenamerFilename(), eps);
    }

    public static List<MediaFile> generateEpisodeFilenames(TvShow tvShow, MediaFile mf) {
        return TvShowRenamer.generateEpisodeFilenames("", tvShow, mf);
    }

    /*
     * Unable to fully structure code
     */
    public static List<MediaFile> generateEpisodeFilenames(String template, TvShow tvShow, MediaFile mf) {
        newFiles = new ArrayList<MediaFile>();
        eps = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile());
        if (ListUtils.isEmpty(eps)) {
            return newFiles;
        }
        newFilename = StringUtils.isBlank((CharSequence)template) != false ? TvShowRenamer.createDestination(TvShowRenamer.SETTINGS.getRenamerFilename(), eps) : TvShowRenamer.createDestination(template, eps);
        seasonFoldername = TvShowRenamer.getSeasonFoldername(tvShow, eps.get(0));
        seasonFolder = tvShow.getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonFoldername)) {
            seasonFolder = tvShow.getPathNIO().resolve(seasonFoldername);
        }
        if (StringUtils.isBlank((CharSequence)newFilename)) {
            mediaFile = new MediaFile(mf);
            mediaFile.setFile(seasonFolder.resolve(mf.getFilename()));
            newFiles.add(mediaFile);
            return newFiles;
        }
        switch (1.$SwitchMap$org$tinymediamanager$core$MediaFileType[mf.getType().ordinal()]) {
            case 1: {
                video = new MediaFile(mf);
                newFilename = newFilename + TvShowRenamer.getStackingString(mf);
                newFilename = newFilename + "." + mf.getExtension();
                video.setFile(seasonFolder.resolve(newFilename));
                newFiles.add(video);
                break;
            }
            case 2: {
                nfo = new MediaFile(mf);
                newFilename = newFilename + "." + mf.getExtension();
                nfo.setFile(seasonFolder.resolve(newFilename));
                newFiles.add(nfo);
                break;
            }
            case 3: {
                for (TvShowEpisodeThumbNaming thumbNaming : TvShowRenamer.SETTINGS.getEpisodeThumbFilenames()) {
                    thumbFilename = thumbNaming.getFilename(newFilename, TvShowRenamer.getArtworkExtension(mf));
                    thumb = new MediaFile(mf);
                    thumb.setFile(seasonFolder.resolve(thumbFilename));
                    newFiles.add(thumb);
                }
                break;
            }
            case 4: {
                subtitles = mf.getSubtitles();
                subtitleFilename = "";
                if (subtitles != null && !subtitles.isEmpty() && (mfs = mf.getSubtitles().get(0)) != null) {
                    if (!mfs.getLanguage().isEmpty()) {
                        lang = LanguageStyle.getLanguageCodeForStyle(mfs.getLanguage(), TvShowModuleManager.SETTINGS.getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = mfs.getLanguage();
                        }
                        subtitleFilename = newFilename + "." + lang;
                    }
                    if (mfs.isForced()) {
                        subtitleFilename = newFilename + ".forced";
                    }
                }
                if (!StringUtils.isBlank((CharSequence)subtitleFilename)) ** GOTO lbl75
                shortname = mf.getBasename().toLowerCase(Locale.ROOT).replace(eps.get(0).getVideoBasenameWithoutStacking(), "");
                originalLang = "";
                lang = "";
                forced = "";
                if (mf.getFilename().toLowerCase(Locale.ROOT).contains("forced")) {
                    forced = ".forced";
                    shortname = shortname.replaceAll("\\p{Punct}*forced", "");
                }
                try {
                    for (String s : LanguageUtils.KEY_TO_LOCALE_MAP.keySet()) {
                        if (!LanguageUtils.doesStringEndWithLanguage(shortname, s)) continue;
                        originalLang = s;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                lang = LanguageStyle.getLanguageCodeForStyle(originalLang, TvShowModuleManager.SETTINGS.getSubtitleLanguageStyle());
                if (StringUtils.isBlank((CharSequence)lang)) {
                    lang = originalLang;
                }
                if (StringUtils.isNotBlank((CharSequence)lang)) {
                    subtitleFilename = newFilename + "." + lang;
                }
                if (StringUtils.isNotBlank((CharSequence)forced)) {
                    subtitleFilename = subtitleFilename + forced;
                }
lbl75:
                // 4 sources

                if (StringUtils.isBlank((CharSequence)subtitleFilename)) {
                    subtitleFilename = newFilename;
                }
                if (!StringUtils.isNotBlank((CharSequence)subtitleFilename)) break;
                subtitle = new MediaFile(mf);
                subtitle.setFile(seasonFolder.resolve(subtitleFilename + "." + mf.getExtension()));
                newFiles.add(subtitle);
                break;
            }
            case 5: {
                fanart = new MediaFile(mf);
                fanart.setFile(seasonFolder.resolve(newFilename + "-fanart." + TvShowRenamer.getArtworkExtension(mf)));
                newFiles.add(fanart);
                break;
            }
            case 6: {
                trailer = new MediaFile(mf);
                trailer.setFile(seasonFolder.resolve(newFilename + "-trailer." + mf.getExtension()));
                newFiles.add(trailer);
                break;
            }
            case 7: {
                mediainfo = new MediaFile(mf);
                mediainfo.setFile(seasonFolder.resolve(newFilename + "-mediainfo." + mf.getExtension()));
                newFiles.add(mediainfo);
                break;
            }
            case 8: {
                vsmeta = new MediaFile(mf);
                videoExt = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                newFilename = newFilename + "." + videoExt + ".vsmeta";
                vsmeta.setFile(seasonFolder.resolve(newFilename));
                newFiles.add(vsmeta);
                break;
            }
            case 9: 
            case 10: {
                extra = new MediaFile(mf);
                result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(mf.getFilename(), tvShow.getTitle());
                extra.setFile(seasonFolder.resolve("extras/" + newFilename + "-" + result.cleanedName + "." + mf.getExtension()));
                newFiles.add(extra);
                break;
            }
            case 11: {
                sample = new MediaFile(mf);
                sample.setFile(seasonFolder.resolve(newFilename + "-sample." + mf.getExtension()));
                newFiles.add(sample);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(mf.getFilename(), tvShow.getTitle());
                other = new MediaFile(mf);
                spaceSubstitution = TvShowRenamer.SETTINGS.isRenamerFilenameSpaceSubstitution();
                spaceReplacement = TvShowRenamer.SETTINGS.getRenamerFilenameSpaceReplacement();
                destination = TvShowRenamer.cleanupDestination(newFilename + "-" + result.cleanedName, spaceSubstitution, spaceReplacement);
                other.setFile(seasonFolder.resolve(destination + "." + mf.getExtension()));
                newFiles.add(other);
                break;
            }
        }
        return newFiles;
    }

    public static String getSeasonFoldername(TvShow show, TvShowEpisode episode) {
        return TvShowRenamer.getSeasonFoldername(SETTINGS.getRenamerSeasonFoldername(), show, episode);
    }

    public static String getSeasonFoldername(String template, TvShow show, TvShowEpisode episode) {
        String seasonFolderName = template;
        TvShowSeason tvShowSeason = show.getSeason(episode.getSeason());
        if (tvShowSeason == null) {
            return "";
        }
        seasonFolderName = tvShowSeason.getSeason() == 0 && TvShowModuleManager.SETTINGS.isSpecialSeason() ? "Specials" : TvShowRenamer.createDestination(seasonFolderName, tvShowSeason, episode);
        if (StringUtils.isBlank((CharSequence)seasonFolderName) && !TvShowRenamer.isRecommended(template, TvShowModuleManager.SETTINGS.getRenamerFilename())) {
            seasonFolderName = "Season " + tvShowSeason.getSeason();
        }
        return seasonFolderName;
    }

    public static String getTvShowFoldername(TvShow tvShow) {
        return TvShowRenamer.getTvShowFoldername(SETTINGS.getRenamerTvShowFoldername(), tvShow);
    }

    public static String getTvShowFoldername(String template, TvShow tvShow) {
        String newPathname = StringUtils.isNotBlank((CharSequence)SETTINGS.getRenamerTvShowFoldername()) ? Paths.get(tvShow.getDataSource(), TvShowRenamer.createDestination(template, tvShow)).toString() : tvShow.getPathNIO().toString();
        return newPathname;
    }

    public static String getTokenValue(TvShow show, TvShowEpisode episode, String token) {
        try {
            Engine engine = Engine.createEngine();
            engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new TvShowNamedFirstCharacterRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
            engine.setModelAdaptor((ModelAdaptor)new TvShowRenamerModelAdaptor());
            HashMap<String, AbstractModelObject> root = new HashMap<String, AbstractModelObject>();
            if (episode != null) {
                root.put("episode", episode);
                root.put("season", episode.getTvShowSeason());
            }
            root.put("tvShow", show);
            return engine.transform(TvShowRenamer.morphTemplate(token), root);
        }
        catch (Exception e) {
            LOGGER.warn("unable to process token: {}", (Object)token);
            return token;
        }
    }

    public static String createDestination(String template, TvShow show) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        boolean spaceSubstitution = SETTINGS.isRenamerShowPathnameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerShowPathnameSpaceReplacement();
        return TvShowRenamer.cleanupDestination(TvShowRenamer.getTokenValue(show, null, template), spaceSubstitution, spaceReplacement);
    }

    public static String createDestination(String template, TvShowSeason season, TvShowEpisode episode) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        String newDestination = TvShowRenamer.getTokenValue(season.getTvShow(), episode, template);
        boolean spaceSubstitution = SETTINGS.isRenamerSeasonPathnameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerSeasonPathnameSpaceReplacement();
        newDestination = TvShowRenamer.cleanupDestination(newDestination, spaceSubstitution, spaceReplacement);
        return newDestination;
    }

    public static String createDestination(String template, List<TvShowEpisode> episodes) {
        TvShowEpisode firstEp;
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        String newDestination = template;
        if (episodes.size() == 1) {
            firstEp = episodes.get(0);
            newDestination = TvShowRenamer.getTokenValue(firstEp.getTvShow(), firstEp, template);
        } else {
            Pattern pattern;
            Matcher matcher;
            String episodeToken;
            firstEp = episodes.get(0);
            String loopNumbers = "";
            String seasonToken = TvShowRenamer.getTokenFromTemplate(newDestination, seasonNumbers);
            if (StringUtils.isNotBlank((CharSequence)seasonToken)) {
                String seasonPart = "";
                Matcher matcher2 = seDelimiter.matcher(newDestination);
                if (matcher2.find()) {
                    seasonPart = matcher2.group(0);
                } else {
                    Pattern pattern2 = Pattern.compile("\\$\\{" + seasonToken + ".*?\\}");
                    matcher2 = pattern2.matcher(newDestination);
                    if (matcher2.find()) {
                        seasonPart = matcher2.group(0);
                    }
                }
                loopNumbers = loopNumbers + seasonPart;
            }
            if (StringUtils.isNotBlank((CharSequence)(episodeToken = TvShowRenamer.getTokenFromTemplate(newDestination, episodeNumbers)))) {
                String episodePart = "";
                Object matcher3 = epDelimiter.matcher(newDestination);
                if (((Matcher)matcher3).find()) {
                    episodePart = episodePart + ((Matcher)matcher3).group(0);
                } else {
                    Pattern pattern3 = Pattern.compile("\\$\\{" + episodeToken + ".*?\\}");
                    matcher3 = pattern3.matcher(newDestination);
                    if (((Matcher)matcher3).find()) {
                        episodePart = ((Matcher)matcher3).group(0);
                    }
                }
                loopNumbers = loopNumbers + episodePart;
            }
            loopNumbers = loopNumbers.trim();
            StringBuilder episodeParts = new StringBuilder();
            for (TvShowEpisode episode : episodes) {
                String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, loopNumbers);
                episodeParts.append(" ").append(episodePart);
            }
            if (!loopNumbers.isEmpty()) {
                newDestination = newDestination.replace(loopNumbers, episodeParts.toString());
            }
            String loopTitles = "";
            String titleToken = TvShowRenamer.getTokenFromTemplate(template, episodeTitles);
            if (StringUtils.isNotBlank((CharSequence)titleToken) && (matcher = (pattern = Pattern.compile("\\$\\{" + titleToken + ".*?\\}", 2)).matcher(template)).find()) {
                loopTitles = loopTitles + matcher.group(0);
            }
            loopTitles = loopTitles.trim();
            episodeParts = new StringBuilder();
            for (TvShowEpisode episode : episodes) {
                String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, loopTitles);
                if (StringUtils.isNotBlank((CharSequence)episodeParts.toString())) {
                    episodeParts.append(" -");
                }
                episodeParts.append(" ").append(episodePart);
            }
            if (StringUtils.isNotBlank((CharSequence)loopTitles)) {
                newDestination = newDestination.replace(loopTitles, episodeParts.toString());
            }
            newDestination = TvShowRenamer.getTokenValue(firstEp.getTvShow(), firstEp, newDestination);
        }
        boolean spaceSubstitution = SETTINGS.isRenamerFilenameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerFilenameSpaceReplacement();
        newDestination = TvShowRenamer.cleanupDestination(newDestination, spaceSubstitution, spaceReplacement);
        return newDestination;
    }

    private static String cleanupDestination(String destination, Boolean spaceSubstitution, String spaceReplacement) {
        destination = destination.replaceAll("\\([ ]?\\)", "");
        destination = destination.replaceAll("\\[[ ]?\\]", "");
        destination = destination.replaceAll("\\{[ ]?\\}", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            destination = destination.replaceAll("\\\\{2,}", "\\\\");
            destination = destination.replaceAll("^\\\\", "");
            destination = destination.replaceAll("\\s+\\\\", "\\\\");
            destination = destination.replaceAll("\\\\\\s+", "\\\\");
            destination = destination.replaceAll("[ \\.\\-_]+\\\\", "\\\\");
        } else {
            destination = destination.replaceAll(File.separator + "{2,}", File.separator);
            destination = destination.replaceAll("^" + File.separator, "");
            destination = destination.replaceAll("\\s+/", "/");
            destination = destination.replaceAll("/\\s+", "/");
            destination = destination.replaceAll("[ \\.\\-_]+/", "/");
        }
        if (spaceSubstitution.booleanValue()) {
            destination = destination.replace(" ", spaceReplacement);
            destination = destination.replaceAll(Pattern.quote(spaceReplacement) + "+", spaceReplacement);
        }
        if (SETTINGS.isAsciiReplacement()) {
            destination = StrgUtils.convertToAscii(destination, false);
        }
        destination = destination.trim();
        destination = destination.replaceAll(" +", " ").trim();
        destination = destination.replaceAll("^[ \\.\\-_]+", "");
        destination = destination.replaceAll("[ \\.\\-_]+$", "");
        destination = destination.replace(": ", " - ");
        destination = destination.replace(":", "-");
        return destination.trim();
    }

    public static boolean isRecommended(String seasonPattern, String filePattern) {
        int epCnt = TvShowRenamer.count(filePattern, episodeNumbers);
        int titleCnt = TvShowRenamer.count(filePattern, episodeTitles);
        int seCnt = TvShowRenamer.count(filePattern, seasonNumbers);
        int seFolderCnt = TvShowRenamer.count(seasonPattern, seasonNumbers);
        if (epCnt != 1 || titleCnt != 1 || seCnt > 1 || seFolderCnt > 1 || seCnt + seFolderCnt == 0) {
            LOGGER.debug("Too many/less episode/season/title replacer patterns");
            return false;
        }
        int epPos = TvShowRenamer.getPatternPos(filePattern, episodeNumbers);
        int sePos = TvShowRenamer.getPatternPos(filePattern, seasonNumbers);
        int titlePos = TvShowRenamer.getPatternPos(filePattern, episodeTitles);
        if (sePos > epPos) {
            LOGGER.debug("Season pattern should be before episode pattern!");
            return false;
        }
        if (titleCnt == 1 && seCnt == 1 && titlePos < epPos && titlePos > sePos) {
            LOGGER.debug("Title should not be between season/episode pattern");
            return false;
        }
        return true;
    }

    private static int count(String pattern, String[] possibleValues) {
        int count = 0;
        for (String r : possibleValues) {
            if (!TvShowRenamer.containsToken(pattern, r)) continue;
            ++count;
        }
        return count;
    }

    private static int getPatternPos(String pattern, String[] possibleValues) {
        int pos = -1;
        for (String r : possibleValues) {
            if (!TvShowRenamer.containsToken(pattern, r)) continue;
            pos = pattern.indexOf(r);
        }
        return pos;
    }

    private static String getTokenFromTemplate(String template, String[] possibleTokens) {
        for (String token : possibleTokens) {
            if (!TvShowRenamer.containsToken(template, token)) continue;
            return token;
        }
        return "";
    }

    private static boolean containsToken(String template, String token) {
        Pattern pattern = Pattern.compile("\\$\\{" + token + "[\\};]");
        Matcher matcher = pattern.matcher(template);
        return matcher.find();
    }

    private static String getArtworkExtension(MediaFile mf) {
        String ext = mf.getExtension().replaceAll("jpeg", "jpg");
        if (ext.equalsIgnoreCase("tbn")) {
            String cont = mf.getContainerFormat();
            if (cont.equalsIgnoreCase("PNG")) {
                ext = "png";
            } else if (cont.equalsIgnoreCase("JPEG")) {
                ext = "jpg";
            }
        }
        return ext;
    }

    private static boolean moveFile(Path oldFilename, Path newFilename) {
        try {
            boolean ok;
            if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveFileSafe(oldFilename, newFilename)) {
                return true;
            }
            LOGGER.error("Could not move MF '" + oldFilename + "' to '" + newFilename + "'");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("error moving file", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldFilename, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    private static boolean copyFile(Path oldFilename, Path newFilename) {
        if (!oldFilename.toAbsolutePath().toString().equals(newFilename.toAbsolutePath().toString())) {
            LOGGER.info("copy file " + oldFilename + " to " + newFilename);
            if (oldFilename.equals(newFilename)) {
                return TvShowRenamer.moveFile(oldFilename, newFilename);
            }
            try {
                if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                    Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
                }
                Utils.copyFileSafe(oldFilename, newFilename, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static String getStackingString(MediaFile mf) {
        String delimiter = ".";
        if (TvShowModuleManager.SETTINGS.isRenamerFilenameSpaceSubstitution()) {
            delimiter = TvShowModuleManager.SETTINGS.getRenamerFilenameSpaceReplacement();
        }
        if (!mf.getStackingMarker().isEmpty()) {
            return delimiter + mf.getStackingMarker();
        }
        if (mf.getStacking() != 0) {
            return delimiter + "CD" + mf.getStacking();
        }
        return "";
    }

    public static String replaceInvalidCharacters(String source) {
        String result = source;
        if ("-".equals(TvShowModuleManager.SETTINGS.getRenamerColonReplacement())) {
            result = result.replaceAll(": ", " - ");
            result = result.replaceAll(":", "-");
        } else {
            result = result.replaceAll(":", TvShowModuleManager.SETTINGS.getRenamerColonReplacement());
        }
        return result.replaceAll("([\":<>|?*])", "");
    }

    public static String isPatternValid(String pattern) {
        String err = "";
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = p.matcher(pattern);
        while (matcher.find()) {
            String tok;
            String fulltoken = matcher.group(1);
            String token = "";
            if (fulltoken.contains(",")) {
                String[] split = fulltoken.split(",");
                token = split[1];
            } else if (fulltoken.contains("[")) {
                token = fulltoken.substring(0, fulltoken.indexOf(91));
            } else if (fulltoken.contains(";")) {
                token = fulltoken.substring(0, fulltoken.indexOf(59));
                String first = fulltoken.substring(fulltoken.indexOf(59) + 1);
                if (!first.equals("first")) {
                    err = err + "  " + matcher.group();
                }
            } else {
                token = fulltoken;
            }
            if ((tok = TOKEN_MAP.get(token.trim())) != null) continue;
            err = err + "  " + matcher.group();
        }
        return err;
    }

    public static class TvShowNamedFirstCharacterRenderer
    implements NamedRenderer {
        public String render(Object o, String s, Locale locale, Map<String, Object> map) {
            if (o instanceof String && StringUtils.isNotBlank((CharSequence)((String)o))) {
                String first;
                String source = (String)o;
                if (TvShowModuleManager.SETTINGS.isAsciiReplacement()) {
                    source = StrgUtils.convertToAscii(source, false);
                }
                if ((first = source.trim().substring(0, 1)).matches("[\\p{L}]")) {
                    return first.toUpperCase(Locale.ROOT);
                }
                return "#";
            }
            if (o instanceof Number) {
                return "#";
            }
            if (o instanceof Date) {
                return "#";
            }
            return "";
        }

        public String getName() {
            return "first";
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Date.class, String.class, Integer.class, Long.class};
        }
    }

    public static class TvShowRenamerModelAdaptor
    extends TmmModelAdaptor {
        public Object getValue(Map<String, Object> model, String expression) {
            Object value = super.getValue(model, expression);
            if (value instanceof String) {
                value = TvShowRenamer.replaceInvalidCharacters((String)value);
            }
            return value;
        }

        public Object getValue(TemplateContext context, Token token, List<String> segments, String expression) {
            Object value = super.getValue(context, token, segments, expression);
            if (value instanceof String) {
                value = TvShowRenamer.replaceInvalidCharacters((String)value);
                if (!token.getText().contains("parent")) {
                    value = ((String)value).replaceAll("\\/", " ");
                    value = ((String)value).replaceAll("\\\\", " ");
                }
            }
            return value;
        }
    }
}

