/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.UTF8Control;

public enum TvShowScraperMetadataConfig implements ScraperMetadataConfig
{
    TITLE(ScraperMetadataConfig.Type.METADATA),
    ORIGINAL_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.originaltitle"),
    PLOT(ScraperMetadataConfig.Type.METADATA),
    YEAR(ScraperMetadataConfig.Type.METADATA),
    AIRED(ScraperMetadataConfig.Type.METADATA, "metatag.aired"),
    STATUS(ScraperMetadataConfig.Type.METADATA),
    RATING(ScraperMetadataConfig.Type.METADATA),
    RUNTIME(ScraperMetadataConfig.Type.METADATA),
    CERTIFICATION(ScraperMetadataConfig.Type.METADATA),
    GENRES(ScraperMetadataConfig.Type.METADATA, "metatag.genre"),
    COUNTRY(ScraperMetadataConfig.Type.METADATA),
    STUDIO(ScraperMetadataConfig.Type.METADATA, "metatag.studio"),
    TAGS(ScraperMetadataConfig.Type.METADATA),
    TRAILER(ScraperMetadataConfig.Type.METADATA),
    SEASON_NAMES(ScraperMetadataConfig.Type.METADATA, "metatag.seasonname"),
    ACTORS(ScraperMetadataConfig.Type.CAST),
    POSTER(ScraperMetadataConfig.Type.ARTWORK),
    FANART(ScraperMetadataConfig.Type.ARTWORK),
    BANNER(ScraperMetadataConfig.Type.ARTWORK),
    CLEARART(ScraperMetadataConfig.Type.ARTWORK),
    THUMB(ScraperMetadataConfig.Type.ARTWORK),
    LOGO(ScraperMetadataConfig.Type.ARTWORK),
    CLEARLOGO(ScraperMetadataConfig.Type.ARTWORK),
    DISCART(ScraperMetadataConfig.Type.ARTWORK, "mediafiletype.disc"),
    KEYART(ScraperMetadataConfig.Type.ARTWORK),
    CHARACTERART(ScraperMetadataConfig.Type.ARTWORK),
    EXTRAFANART(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_POSTER(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_BANNER(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_THUMB(ScraperMetadataConfig.Type.ARTWORK);

    private static final ResourceBundle BUNDLE;
    private ScraperMetadataConfig.Type type;
    private String description;
    private String tooltip;

    private TvShowScraperMetadataConfig(ScraperMetadataConfig.Type type) {
        this(type, null, null);
    }

    private TvShowScraperMetadataConfig(ScraperMetadataConfig.Type type, String description) {
        this(type, description, null);
    }

    private TvShowScraperMetadataConfig(ScraperMetadataConfig.Type type, String description, String tooltip) {
        this.type = type;
        this.description = description;
        this.tooltip = tooltip;
    }

    @Override
    public ScraperMetadataConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            try {
                if (this.type == ScraperMetadataConfig.Type.ARTWORK) {
                    return BUNDLE.getString("mediafiletype." + this.name().toLowerCase(Locale.ROOT));
                }
                return BUNDLE.getString("metatag." + this.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception exception) {}
        } else {
            try {
                return BUNDLE.getString(this.description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (StringUtils.isBlank((CharSequence)this.tooltip)) {
            return null;
        }
        try {
            return BUNDLE.getString(this.tooltip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    }
}

