/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.DateField;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.filenaming.TvShowBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowCharacterartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowClearartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowClearlogoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowDiscartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowKeyartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowLogoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;

public class TvShowSettings
extends AbstractSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSettings.class);
    public static final String DEFAULT_RENAMER_FOLDER_PATTERN = "${showTitle} (${showYear})";
    public static final String DEFAULT_RENAMER_SEASON_PATTERN = "Season ${seasonNr}";
    public static final String DEFAULT_RENAMER_FILE_PATTERN = "${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}";
    private static final String CONFIG_FILE = "tvShows.json";
    private static TvShowSettings instance;
    private static final String TV_SHOW_DATA_SOURCE = "tvShowDataSource";
    private static final String ARTWORK_SCRAPERS = "artworkScrapers";
    private static final String TRAILER_SCRAPERS = "trailerScrapers";
    private static final String TRAILER_FILENAME = "trailerFilename";
    private static final String CERTIFICATION_COUNTRY = "certificationCountry";
    private static final String RENAMER_SEASON_FOLDER = "renamerSeasonFoldername";
    private static final String BAD_WORD = "badWord";
    private static final String SKIP_FOLDER = "skipFolder";
    private static final String SUBTITLE_SCRAPERS = "subtitleScrapers";
    private static final String UI_FILTERS = "uiFilters";
    private static final String NFO_FILENAME = "nfoFilename";
    private static final String POSTER_FILENAME = "posterFilename";
    private static final String FANART_FILENAME = "fanartFilename";
    private static final String BANNER_FILENAME = "bannerFilename";
    private static final String DISCART_FILENAME = "discartFilename";
    private static final String CLEARART_FILENAME = "clearartFilename";
    private static final String THUMB_FILENAME = "thumbFilename";
    private static final String LOGO_FILENAME = "logoFilename";
    private static final String CLEARLOGO_FILENAME = "clearlogoFilename";
    private static final String CHARACTERART_FILENAME = "characterartFilename";
    private static final String KEYART_FILENAME = "keyartFilename";
    private static final String SEASON_POSTER_FILENAME = "seasonPosterFilename";
    private static final String SEASON_BANNER_FILENAME = "seasonBannerFilename";
    private static final String SEASON_THUMB_FILENAME = "seasonThumbFilename";
    private static final String EPISODE_NFO_FILENAME = "episodeNfoFilename";
    private static final String EPISODE_THUMB_FILENAME = "episodeThumbFilename";
    private static final String EPISODE_CHECK_IMAGES = "episodeCheckImages";
    private static final String SEASON_CHECK_IMAGES = "seasonCheckImages";
    private static final String TVSHOW_CHECK_IMAGES = "TvShowCheckImages";
    private final List<String> tvShowDataSources = ObservableCollections.observableList(new ArrayList());
    private final List<String> badWords = ObservableCollections.observableList(new ArrayList());
    private final List<String> artworkScrapers = ObservableCollections.observableList(new ArrayList());
    private final List<String> trailerScrapers = ObservableCollections.observableList(new ArrayList());
    private final List<String> skipFolders = ObservableCollections.observableList(new ArrayList());
    private final List<String> subtitleScrapers = ObservableCollections.observableList(new ArrayList());
    private final List<TvShowNfoNaming> nfoFilenames = new ArrayList<TvShowNfoNaming>();
    private final List<TvShowPosterNaming> posterFilenames = new ArrayList<TvShowPosterNaming>();
    private final List<TvShowFanartNaming> fanartFilenames = new ArrayList<TvShowFanartNaming>();
    private final List<TvShowBannerNaming> bannerFilenames = new ArrayList<TvShowBannerNaming>();
    private final List<TvShowDiscartNaming> discartFilenames = new ArrayList<TvShowDiscartNaming>();
    private final List<TvShowClearartNaming> clearartFilenames = new ArrayList<TvShowClearartNaming>();
    private final List<TvShowThumbNaming> thumbFilenames = new ArrayList<TvShowThumbNaming>();
    private final List<TvShowClearlogoNaming> clearlogoFilenames = new ArrayList<TvShowClearlogoNaming>();
    private final List<TvShowLogoNaming> logoFilenames = new ArrayList<TvShowLogoNaming>();
    private final List<TvShowCharacterartNaming> characterartFilenames = new ArrayList<TvShowCharacterartNaming>();
    private final List<TvShowKeyartNaming> keyartFilenames = new ArrayList<TvShowKeyartNaming>();
    private final List<TvShowSeasonPosterNaming> seasonPosterFilenames = new ArrayList<TvShowSeasonPosterNaming>();
    private final List<TvShowSeasonBannerNaming> seasonBannerFilenames = new ArrayList<TvShowSeasonBannerNaming>();
    private final List<TvShowSeasonThumbNaming> seasonThumbFilenames = new ArrayList<TvShowSeasonThumbNaming>();
    private final List<TvShowEpisodeNfoNaming> episodeNfoFilenames = new ArrayList<TvShowEpisodeNfoNaming>();
    private final List<TvShowEpisodeThumbNaming> episodeThumbFilenames = new ArrayList<TvShowEpisodeThumbNaming>();
    private final List<MediaArtwork.MediaArtworkType> episodeCheckImages = new ArrayList<MediaArtwork.MediaArtworkType>();
    private final List<MediaArtwork.MediaArtworkType> seasonCheckImages = new ArrayList<MediaArtwork.MediaArtworkType>();
    private final List<MediaArtwork.MediaArtworkType> tvShowCheckImages = new ArrayList<MediaArtwork.MediaArtworkType>();
    private final List<TvShowTrailerNaming> trailerFilenames = new ArrayList<TvShowTrailerNaming>();
    private List<AbstractSettings.UIFilters> uiFilters = new ArrayList<AbstractSettings.UIFilters>();
    private final List<String> tvShowTableHiddenColumns = ObservableCollections.observableList(new ArrayList());
    private TvShowConnectors tvShowConnector = TvShowConnectors.XBMC;
    private CertificationStyle certificationStyle = CertificationStyle.LARGE;
    private boolean writeCleanNfo = false;
    private DateField nfoDateAddedField = DateField.DATE_ADDED;
    private MediaLanguages nfoLanguage = MediaLanguages.en;
    private boolean renameAfterScrape = false;
    private String renamerTvShowFoldername = "${showTitle} (${showYear})";
    private String renamerSeasonFoldername = "Season ${seasonNr}";
    private String renamerFilename = "${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}";
    private boolean renamerShowPathnameSpaceSubstitution = false;
    private String renamerShowPathnameSpaceReplacement = "_";
    private boolean renamerSeasonPathnameSpaceSubstitution = false;
    private String renamerSeasonPathnameSpaceReplacement = "_";
    private boolean renamerFilenameSpaceSubstitution = false;
    private String renamerFilenameSpaceReplacement = "_";
    private String renamerColonReplacement = "";
    private boolean asciiReplacement = false;
    private boolean specialSeason = true;
    private String scraper = "tvdb";
    private MediaLanguages scraperLanguage = MediaLanguages.en;
    private CountryCode certificationCountry = CountryCode.US;
    private List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = new ArrayList<TvShowScraperMetadataConfig>();
    private List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
    private MediaLanguages imageScraperLanguage = MediaLanguages.en;
    private MediaArtwork.PosterSizes imagePosterSize = MediaArtwork.PosterSizes.LARGE;
    private MediaArtwork.FanartSizes imageFanartSize = MediaArtwork.FanartSizes.LARGE;
    private boolean scrapeBestImage = true;
    private boolean writeActorImages = false;
    private boolean imageExtraFanart = false;
    private int imageExtraFanartCount = 5;
    private boolean useTrailerPreference = true;
    private boolean automaticTrailerDownload = false;
    private TrailerQuality trailerQuality = TrailerQuality.HD_720;
    private TrailerSources trailerSource = TrailerSources.YOUTUBE;
    private MediaLanguages subtitleScraperLanguage = MediaLanguages.en;
    private LanguageStyle subtitleLanguageStyle = LanguageStyle.ISO3T;
    private boolean buildImageCacheOnImport = false;
    private boolean syncTrakt = false;
    private boolean dvdOrder = false;
    private boolean preferPersonalRating = true;
    private String preferredRating = "tvdb";
    private boolean extractArtworkFromVsmeta = false;
    private boolean storeUiFilters = false;
    private boolean displayMissingEpisodes = false;
    private boolean displayMissingSpecials = false;
    private boolean capitalWordsinTitles = false;
    private boolean showLogosPanel = true;

    public TvShowSettings() {
        this.addDefaultEntries();
        this.addPropertyChangeListener(evt -> this.setDirty());
    }

    private void addDefaultEntries() {
        this.nfoFilenames.clear();
        this.addNfoFilename(TvShowNfoNaming.TV_SHOW);
        this.posterFilenames.clear();
        this.addPosterFilename(TvShowPosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(TvShowFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(TvShowBannerNaming.BANNER);
        this.discartFilenames.clear();
        this.addDiscartFilename(TvShowDiscartNaming.DISCART);
        this.clearartFilenames.clear();
        this.addClearartFilename(TvShowClearartNaming.CLEARART);
        this.logoFilenames.clear();
        this.addLogoFilename(TvShowLogoNaming.LOGO);
        this.characterartFilenames.clear();
        this.addCharacterartFilename(TvShowCharacterartNaming.CHARACTERART);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(TvShowClearlogoNaming.CLEARLOGO);
        this.thumbFilenames.clear();
        this.addThumbFilename(TvShowThumbNaming.THUMB);
        this.keyartFilenames.clear();
        this.addKeyartFilename(TvShowKeyartNaming.KEYART);
        this.seasonPosterFilenames.clear();
        this.addSeasonPosterFilename(TvShowSeasonPosterNaming.SEASON_POSTER);
        this.seasonBannerFilenames.clear();
        this.addSeasonBannerFilename(TvShowSeasonBannerNaming.SEASON_BANNER);
        this.seasonThumbFilenames.clear();
        this.addSeasonThumbFilename(TvShowSeasonThumbNaming.SEASON_THUMB);
        this.episodeNfoFilenames.clear();
        this.addEpisodeNfoFilename(TvShowEpisodeNfoNaming.FILENAME);
        this.episodeThumbFilenames.clear();
        this.addEpisodeThumbFilename(TvShowEpisodeThumbNaming.FILENAME_THUMB);
        this.episodeCheckImages.clear();
        this.addEpisodeCheckImages(MediaArtwork.MediaArtworkType.THUMB);
        this.seasonCheckImages.clear();
        this.addSeasonCheckImages(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        this.addSeasonCheckImages(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        this.addSeasonCheckImages(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        this.tvShowCheckImages.clear();
        this.addTvShowCheckImages(MediaArtwork.MediaArtworkType.POSTER);
        this.addTvShowCheckImages(MediaArtwork.MediaArtworkType.BACKGROUND);
        this.addTvShowCheckImages(MediaArtwork.MediaArtworkType.BANNER);
        this.trailerFilenames.clear();
        this.addTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        this.tvShowScraperMetadataConfig.addAll(Arrays.asList(TvShowScraperMetadataConfig.values()));
        this.episodeScraperMetadataConfig.addAll(Arrays.asList(TvShowEpisodeScraperMetadataConfig.values()));
    }

    @Override
    protected ObjectWriter createObjectWriter() {
        return objectMapper.writerFor(TvShowSettings.class);
    }

    public static synchronized TvShowSettings getInstance() {
        return TvShowSettings.getInstance(Globals.settings.getSettingsFolder());
    }

    public static synchronized TvShowSettings getInstance(String folder) {
        if (instance == null) {
            instance = (TvShowSettings)TvShowSettings.getInstance(folder, CONFIG_FILE, TvShowSettings.class);
        }
        return instance;
    }

    @Override
    public String getConfigFilename() {
        return CONFIG_FILE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void writeDefaultSettings() {
        this.setTvShowTableHiddenColumns(Arrays.asList("format", "fileSize", "aired"));
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.SUBTITLE)) {
            this.addTvShowSubtitleScraper(ms.getId());
        }
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.TV_SHOW_ARTWORK)) {
            this.addTvShowArtworkScraper(ms.getId());
        }
        String defaultLang = Locale.getDefault().getLanguage();
        CountryCode cc = CountryCode.getByCode(defaultLang.toUpperCase(Locale.ROOT));
        if (cc != null) {
            this.setCertificationCountry(cc);
        }
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (!ml.name().equals(defaultLang)) continue;
            this.setScraperLanguage(ml);
        }
        this.addDefaultEntries();
        this.saveSettings();
        Path mig = Paths.get("cache", "migv3shows.ds");
        if (mig.toFile().exists()) {
            try {
                List<String> datasources = Files.readAllLines(mig);
                for (String ds : datasources) {
                    this.addTvShowDataSources(ds);
                }
                Files.delete(mig);
                this.saveSettings();
            }
            catch (IOException e) {
                LOGGER.warn("Could not migrate TV show datasources!", (Throwable)e);
            }
        }
    }

    public void addTvShowDataSources(String path) {
        if (!this.tvShowDataSources.contains(path)) {
            this.tvShowDataSources.add(path);
            this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
            this.firePropertyChange("dataSource", null, this.tvShowDataSources);
        }
    }

    public void removeTvShowDataSources(String path) {
        TvShowList tvShowList = TvShowList.getInstance();
        tvShowList.removeDatasource(path);
        this.tvShowDataSources.remove(path);
        this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
        this.firePropertyChange("dataSource", null, this.tvShowDataSources);
    }

    public List<String> getTvShowDataSource() {
        return this.tvShowDataSources;
    }

    public String getScraper() {
        if (StringUtils.isBlank((CharSequence)this.scraper)) {
            return "tvdb";
        }
        return this.scraper;
    }

    public void setScraper(String newValue) {
        String oldValue = this.scraper;
        this.scraper = newValue;
        this.firePropertyChange("scraper", oldValue, newValue);
    }

    public void addTvShowArtworkScraper(String newValue) {
        if (!this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.add(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public void removeTvShowArtworkScraper(String newValue) {
        if (this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.remove(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public void addTrailerFilename(TvShowTrailerNaming filename) {
        if (!this.trailerFilenames.contains(filename)) {
            this.trailerFilenames.add(filename);
            this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
        }
    }

    public void clearTrailerFilenames() {
        this.trailerFilenames.clear();
        this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
    }

    public List<TvShowTrailerNaming> getTrailerFilenames() {
        return new ArrayList<TvShowTrailerNaming>(this.trailerFilenames);
    }

    public boolean isUseTrailerPreference() {
        return this.useTrailerPreference;
    }

    public void setUseTrailerPreference(boolean newValue) {
        boolean oldValue = this.useTrailerPreference;
        this.useTrailerPreference = newValue;
        this.firePropertyChange("useTrailerPreference", oldValue, newValue);
    }

    public boolean isAutomaticTrailerDownload() {
        return this.automaticTrailerDownload;
    }

    public void setAutomaticTrailerDownload(boolean newValue) {
        boolean oldValue = this.automaticTrailerDownload;
        this.automaticTrailerDownload = newValue;
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public TrailerQuality getTrailerQuality() {
        return this.trailerQuality;
    }

    public void setTrailerQuality(TrailerQuality newValue) {
        TrailerQuality oldValue = this.trailerQuality;
        this.trailerQuality = newValue;
        this.firePropertyChange("trailerQuality", (Object)oldValue, (Object)newValue);
    }

    public TrailerSources getTrailerSource() {
        return this.trailerSource;
    }

    public void setTrailerSource(TrailerSources newValue) {
        TrailerSources oldValue = this.trailerSource;
        this.trailerSource = newValue;
        this.firePropertyChange("trailerSource", (Object)oldValue, (Object)newValue);
    }

    public void addTvShowTrailerScraper(String newValue) {
        if (!this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.add(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public void removeTvShowTrailerScraper(String newValue) {
        if (this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.remove(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public List<String> getTrailerScrapers() {
        return this.trailerScrapers;
    }

    public List<String> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public boolean isScrapeBestImage() {
        return this.scrapeBestImage;
    }

    public void setScrapeBestImage(boolean newValue) {
        boolean oldValue = this.scrapeBestImage;
        this.scrapeBestImage = newValue;
        this.firePropertyChange("scrapeBestImage", oldValue, newValue);
    }

    public MediaLanguages getScraperLanguage() {
        return this.scraperLanguage;
    }

    public void setScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.scraperLanguage;
        this.scraperLanguage = newValue;
        this.firePropertyChange("scraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public MediaLanguages getSubtitleScraperLanguage() {
        return this.subtitleScraperLanguage;
    }

    public void setSubtitleScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.subtitleScraperLanguage;
        this.subtitleScraperLanguage = newValue;
        this.firePropertyChange("subtitleScraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public void setCertificationCountry(CountryCode newValue) {
        CountryCode oldValue = this.certificationCountry;
        this.certificationCountry = newValue;
        this.firePropertyChange(CERTIFICATION_COUNTRY, (Object)oldValue, (Object)newValue);
    }

    public String getRenamerSeasonFoldername() {
        return this.renamerSeasonFoldername;
    }

    public void setRenamerSeasonFoldername(String newValue) {
        String oldValue = this.renamerSeasonFoldername;
        this.renamerSeasonFoldername = newValue;
        this.firePropertyChange(RENAMER_SEASON_FOLDER, oldValue, newValue);
    }

    public String getRenamerTvShowFoldername() {
        return this.renamerTvShowFoldername;
    }

    public void setRenamerTvShowFoldername(String newValue) {
        String oldValue = this.renamerTvShowFoldername;
        this.renamerTvShowFoldername = newValue;
        this.firePropertyChange("renamerTvShowFoldername", oldValue, newValue);
    }

    public String getRenamerFilename() {
        return this.renamerFilename;
    }

    public void setRenamerFilename(String newValue) {
        String oldValue = this.renamerFilename;
        this.renamerFilename = newValue;
        this.firePropertyChange("renamerFilename", oldValue, newValue);
    }

    public boolean isBuildImageCacheOnImport() {
        return this.buildImageCacheOnImport;
    }

    public void setBuildImageCacheOnImport(boolean newValue) {
        boolean oldValue = this.buildImageCacheOnImport;
        this.buildImageCacheOnImport = newValue;
        this.firePropertyChange("buildImageCacheOnImport", oldValue, newValue);
    }

    public boolean isExtractArtworkFromVsmeta() {
        return this.extractArtworkFromVsmeta;
    }

    public void setExtractArtworkFromVsmeta(boolean newValue) {
        boolean oldValue = this.extractArtworkFromVsmeta;
        this.extractArtworkFromVsmeta = newValue;
        this.firePropertyChange("extractArtworkFromVsmeta", oldValue, newValue);
    }

    public boolean isAsciiReplacement() {
        return this.asciiReplacement;
    }

    public void setAsciiReplacement(boolean newValue) {
        boolean oldValue = this.asciiReplacement;
        this.asciiReplacement = newValue;
        this.firePropertyChange("asciiReplacement", oldValue, newValue);
    }

    public boolean isSpecialSeason() {
        return this.specialSeason;
    }

    public void setSpecialSeason(boolean newValue) {
        boolean oldValue = this.specialSeason;
        this.specialSeason = newValue;
        this.firePropertyChange("specialSeason", oldValue, newValue);
    }

    public String getRenamerShowPathnameSpaceReplacement() {
        return this.renamerShowPathnameSpaceReplacement;
    }

    public void setRenamerShowPathnameSpaceReplacement(String newValue) {
        String oldValue = this.renamerShowPathnameSpaceReplacement;
        this.renamerShowPathnameSpaceReplacement = newValue;
        this.firePropertyChange("renamerShowPathnameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerSeasonPathnameSpaceReplacement() {
        return this.renamerSeasonPathnameSpaceReplacement;
    }

    public void setRenamerSeasonPathnameSpaceReplacement(String newValue) {
        String oldValue = this.renamerSeasonPathnameSpaceReplacement;
        this.renamerSeasonPathnameSpaceReplacement = newValue;
        this.firePropertyChange("renamerSeasonPathnameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerFilenameSpaceReplacement() {
        return this.renamerFilenameSpaceReplacement;
    }

    public void setRenamerFilenameSpaceReplacement(String newValue) {
        String oldValue = this.renamerFilenameSpaceReplacement;
        this.renamerFilenameSpaceReplacement = newValue;
        this.firePropertyChange("renamerFilenameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerColonReplacement() {
        return this.renamerColonReplacement;
    }

    public void setRenamerColonReplacement(String newValue) {
        String oldValue = this.renamerColonReplacement;
        this.renamerColonReplacement = newValue;
        this.firePropertyChange("renamerColonReplacement", oldValue, newValue);
    }

    public boolean isRenamerShowPathnameSpaceSubstitution() {
        return this.renamerShowPathnameSpaceSubstitution;
    }

    public void setRenamerShowPathnameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerShowPathnameSpaceSubstitution;
        this.renamerShowPathnameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerShowPathnameSpaceSubstitution", oldValue, newValue);
    }

    public boolean isRenamerSeasonPathnameSpaceSubstitution() {
        return this.renamerSeasonPathnameSpaceSubstitution;
    }

    public void setRenamerSeasonPathnameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerSeasonPathnameSpaceSubstitution;
        this.renamerSeasonPathnameSpaceSubstitution = newValue;
        this.firePropertyChange("renamereasonPathnameSpaceSubstitution", oldValue, newValue);
    }

    public boolean isRenamerFilenameSpaceSubstitution() {
        return this.renamerFilenameSpaceSubstitution;
    }

    public void setRenamerFilenameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerFilenameSpaceSubstitution;
        this.renamerFilenameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerFilenameSpaceSubstitution", oldValue, newValue);
    }

    public void setSyncTrakt(boolean newValue) {
        boolean oldValue = this.syncTrakt;
        this.syncTrakt = newValue;
        this.firePropertyChange("syncTrakt", oldValue, newValue);
    }

    public boolean getSyncTrakt() {
        return this.syncTrakt;
    }

    public boolean isDvdOrder() {
        return this.dvdOrder;
    }

    public void setDvdOrder(boolean newValue) {
        boolean oldValue = this.dvdOrder;
        this.dvdOrder = newValue;
        this.firePropertyChange("dvdOrder", oldValue, newValue);
    }

    public void addSkipFolder(String newValue) {
        if (!this.skipFolders.contains(newValue)) {
            this.skipFolders.add(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public void removeSkipFolder(String newValue) {
        if (this.skipFolders.contains(newValue)) {
            this.skipFolders.remove(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public List<String> getSkipFolder() {
        return this.skipFolders;
    }

    public void addBadWord(String badWord) {
        if (!this.badWords.contains(badWord.toLowerCase(Locale.ROOT))) {
            this.badWords.add(badWord.toLowerCase(Locale.ROOT));
            this.firePropertyChange(BAD_WORD, null, this.badWords);
        }
    }

    public void removeBadWord(String badWord) {
        this.badWords.remove(badWord.toLowerCase(Locale.ROOT));
        this.firePropertyChange(BAD_WORD, null, this.badWords);
    }

    public List<String> getBadWord() {
        ListIterator<String> iterator = this.badWords.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toLowerCase(Locale.ROOT));
        }
        return this.badWords;
    }

    public void addEpisodeThumbFilename(TvShowEpisodeThumbNaming filename) {
        if (!this.episodeThumbFilenames.contains(filename)) {
            this.episodeThumbFilenames.add(filename);
            this.firePropertyChange(EPISODE_THUMB_FILENAME, null, this.episodeThumbFilenames);
        }
    }

    public void clearEpisodeThumbFilenames() {
        this.episodeThumbFilenames.clear();
        this.firePropertyChange(EPISODE_THUMB_FILENAME, null, this.episodeThumbFilenames);
    }

    public List<TvShowEpisodeThumbNaming> getEpisodeThumbFilenames() {
        return new ArrayList<TvShowEpisodeThumbNaming>(this.episodeThumbFilenames);
    }

    public void addTvShowSubtitleScraper(String newValue) {
        if (!this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.add(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public void removeTvShowSubtitleScraper(String newValue) {
        if (this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.remove(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public List<String> getSubtitleScrapers() {
        return this.subtitleScrapers;
    }

    public LanguageStyle getSubtitleLanguageStyle() {
        return this.subtitleLanguageStyle;
    }

    public void setSubtitleLanguageStyle(LanguageStyle newValue) {
        LanguageStyle oldValue = this.subtitleLanguageStyle;
        this.subtitleLanguageStyle = newValue;
        this.firePropertyChange("subtitleLanguageStyle", (Object)oldValue, (Object)newValue);
    }

    public void setTvShowTableHiddenColumns(List<String> hiddenColumns) {
        this.tvShowTableHiddenColumns.clear();
        this.tvShowTableHiddenColumns.addAll(hiddenColumns);
        this.firePropertyChange("tvShowTableHiddenColumns", null, this.tvShowTableHiddenColumns);
    }

    public List<String> getTvShowTableHiddenColumns() {
        return this.tvShowTableHiddenColumns;
    }

    public void setUiFilters(List<AbstractSettings.UIFilters> filters) {
        this.uiFilters.clear();
        this.uiFilters.addAll(filters);
        this.firePropertyChange(UI_FILTERS, null, this.uiFilters);
    }

    public List<AbstractSettings.UIFilters> getUiFilters() {
        if (this.storeUiFilters) {
            return this.uiFilters;
        }
        return new ArrayList<AbstractSettings.UIFilters>();
    }

    public void setStoreUiFilters(boolean newValue) {
        boolean oldValue = this.storeUiFilters;
        this.storeUiFilters = newValue;
        this.firePropertyChange("storeUiFilters", oldValue, newValue);
    }

    public boolean isStoreUiFilters() {
        return this.storeUiFilters;
    }

    public boolean isDisplayMissingEpisodes() {
        return this.displayMissingEpisodes;
    }

    public void setDisplayMissingEpisodes(boolean newValue) {
        boolean oldValue = this.displayMissingEpisodes;
        this.displayMissingEpisodes = newValue;
        this.firePropertyChange("displayMissingEpisodes", oldValue, newValue);
    }

    public boolean isDisplayMissingSpecials() {
        return this.displayMissingSpecials;
    }

    public void setDisplayMissingSpecials(boolean newValue) {
        boolean oldValue = this.displayMissingSpecials;
        this.displayMissingSpecials = newValue;
        this.firePropertyChange("displayMissingSpecials", oldValue, newValue);
    }

    public List<TvShowScraperMetadataConfig> getTvShowScraperMetadataConfig() {
        return this.tvShowScraperMetadataConfig;
    }

    public void setTvShowScraperMetadataConfig(List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig) {
        this.tvShowScraperMetadataConfig.clear();
        this.tvShowScraperMetadataConfig.addAll(tvShowScraperMetadataConfig);
        this.firePropertyChange("scraperMetadataConfig", null, tvShowScraperMetadataConfig);
    }

    public List<TvShowEpisodeScraperMetadataConfig> getEpisodeScraperMetadataConfig() {
        return this.episodeScraperMetadataConfig;
    }

    public void setEpisodeScraperMetadataConfig(List<TvShowEpisodeScraperMetadataConfig> scraperMetadataConfig) {
        this.episodeScraperMetadataConfig.clear();
        this.episodeScraperMetadataConfig.addAll(scraperMetadataConfig);
        this.firePropertyChange("episodeScraperMetadataConfig", null, this.episodeScraperMetadataConfig);
    }

    public MediaLanguages getImageScraperLanguage() {
        return this.imageScraperLanguage;
    }

    public void setImageScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.imageScraperLanguage;
        this.imageScraperLanguage = newValue;
        this.firePropertyChange("imageScraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public MediaArtwork.PosterSizes getImagePosterSize() {
        return this.imagePosterSize;
    }

    public void setImagePosterSize(MediaArtwork.PosterSizes newValue) {
        MediaArtwork.PosterSizes oldValue = this.imagePosterSize;
        this.imagePosterSize = newValue;
        this.firePropertyChange("imagePosterSize", (Object)oldValue, (Object)newValue);
    }

    public MediaArtwork.FanartSizes getImageFanartSize() {
        return this.imageFanartSize;
    }

    public void setImageFanartSize(MediaArtwork.FanartSizes newValue) {
        MediaArtwork.FanartSizes oldValue = this.imageFanartSize;
        this.imageFanartSize = newValue;
        this.firePropertyChange("imageFanartSize", (Object)oldValue, (Object)newValue);
    }

    public void addNfoFilename(TvShowNfoNaming filename) {
        if (!this.nfoFilenames.contains(filename)) {
            this.nfoFilenames.add(filename);
            this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
        }
    }

    public void clearNfoFilenames() {
        this.nfoFilenames.clear();
        this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
    }

    public List<TvShowNfoNaming> getNfoFilenames() {
        return new ArrayList<TvShowNfoNaming>(this.nfoFilenames);
    }

    public void addPosterFilename(TvShowPosterNaming filename) {
        if (!this.posterFilenames.contains(filename)) {
            this.posterFilenames.add(filename);
            this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
        }
    }

    public void clearPosterFilenames() {
        this.posterFilenames.clear();
        this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
    }

    public List<TvShowPosterNaming> getPosterFilenames() {
        return new ArrayList<TvShowPosterNaming>(this.posterFilenames);
    }

    public void addFanartFilename(TvShowFanartNaming filename) {
        if (!this.fanartFilenames.contains(filename)) {
            this.fanartFilenames.add(filename);
            this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
        }
    }

    public void clearFanartFilenames() {
        this.fanartFilenames.clear();
        this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
    }

    public List<TvShowFanartNaming> getFanartFilenames() {
        return new ArrayList<TvShowFanartNaming>(this.fanartFilenames);
    }

    public void addBannerFilename(TvShowBannerNaming filename) {
        if (!this.bannerFilenames.contains(filename)) {
            this.bannerFilenames.add(filename);
            this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
        }
    }

    public void clearBannerFilenames() {
        this.bannerFilenames.clear();
        this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
    }

    public List<TvShowBannerNaming> getBannerFilenames() {
        return new ArrayList<TvShowBannerNaming>(this.bannerFilenames);
    }

    public void addDiscartFilename(TvShowDiscartNaming filename) {
        if (!this.discartFilenames.contains(filename)) {
            this.discartFilenames.add(filename);
            this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
        }
    }

    public void clearDiscartFilenames() {
        this.discartFilenames.clear();
        this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
    }

    public List<TvShowDiscartNaming> getDiscartFilenames() {
        return new ArrayList<TvShowDiscartNaming>(this.discartFilenames);
    }

    public void addClearartFilename(TvShowClearartNaming filename) {
        if (!this.clearartFilenames.contains(filename)) {
            this.clearartFilenames.add(filename);
            this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
        }
    }

    public void clearClearartFilenames() {
        this.clearartFilenames.clear();
        this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
    }

    public List<TvShowClearartNaming> getClearartFilenames() {
        return new ArrayList<TvShowClearartNaming>(this.clearartFilenames);
    }

    public void addThumbFilename(TvShowThumbNaming filename) {
        if (!this.thumbFilenames.contains(filename)) {
            this.thumbFilenames.add(filename);
            this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
        }
    }

    public void clearThumbFilenames() {
        this.thumbFilenames.clear();
        this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
    }

    public List<TvShowThumbNaming> getThumbFilenames() {
        return new ArrayList<TvShowThumbNaming>(this.thumbFilenames);
    }

    public void addLogoFilename(TvShowLogoNaming filename) {
        if (!this.logoFilenames.contains(filename)) {
            this.logoFilenames.add(filename);
            this.firePropertyChange(LOGO_FILENAME, null, this.logoFilenames);
        }
    }

    public void clearLogoFilenames() {
        this.logoFilenames.clear();
        this.firePropertyChange(LOGO_FILENAME, null, this.logoFilenames);
    }

    public void addCharacterartFilename(TvShowCharacterartNaming filename) {
        if (!this.characterartFilenames.contains(filename)) {
            this.characterartFilenames.add(filename);
            this.firePropertyChange(CHARACTERART_FILENAME, null, this.characterartFilenames);
        }
    }

    public void clearCharacterartFilenames() {
        this.characterartFilenames.clear();
    }

    public List<TvShowCharacterartNaming> getCharacterartFilenames() {
        return this.characterartFilenames;
    }

    public void addKeyartFilename(TvShowKeyartNaming filename) {
        if (!this.keyartFilenames.contains(filename)) {
            this.keyartFilenames.add(filename);
            this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
        }
    }

    public void clearKeyartFilenames() {
        this.keyartFilenames.clear();
        this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
    }

    public List<TvShowKeyartNaming> getKeyartFilenames() {
        return this.keyartFilenames;
    }

    public List<TvShowLogoNaming> getLogoFilenames() {
        return new ArrayList<TvShowLogoNaming>(this.logoFilenames);
    }

    public void addClearlogoFilename(TvShowClearlogoNaming filename) {
        if (!this.clearlogoFilenames.contains(filename)) {
            this.clearlogoFilenames.add(filename);
            this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
        }
    }

    public void clearClearlogoFilenames() {
        this.clearlogoFilenames.clear();
        this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
    }

    public List<TvShowClearlogoNaming> getClearlogoFilenames() {
        return new ArrayList<TvShowClearlogoNaming>(this.clearlogoFilenames);
    }

    public void addSeasonPosterFilename(TvShowSeasonPosterNaming filename) {
        if (!this.seasonPosterFilenames.contains(filename)) {
            this.seasonPosterFilenames.add(filename);
            this.firePropertyChange(SEASON_POSTER_FILENAME, null, this.seasonPosterFilenames);
        }
    }

    public void clearSeasonPosterFilenames() {
        this.seasonPosterFilenames.clear();
        this.firePropertyChange(SEASON_POSTER_FILENAME, null, this.seasonPosterFilenames);
    }

    public List<TvShowSeasonPosterNaming> getSeasonPosterFilenames() {
        return new ArrayList<TvShowSeasonPosterNaming>(this.seasonPosterFilenames);
    }

    public void addSeasonBannerFilename(TvShowSeasonBannerNaming filename) {
        if (!this.seasonBannerFilenames.contains(filename)) {
            this.seasonBannerFilenames.add(filename);
            this.firePropertyChange(SEASON_BANNER_FILENAME, null, this.seasonBannerFilenames);
        }
    }

    public void clearSeasonBannerFilenames() {
        this.seasonBannerFilenames.clear();
        this.firePropertyChange(SEASON_BANNER_FILENAME, null, this.seasonBannerFilenames);
    }

    public List<TvShowSeasonBannerNaming> getSeasonBannerFilenames() {
        return new ArrayList<TvShowSeasonBannerNaming>(this.seasonBannerFilenames);
    }

    public void addSeasonThumbFilename(TvShowSeasonThumbNaming filename) {
        if (!this.seasonThumbFilenames.contains(filename)) {
            this.seasonThumbFilenames.add(filename);
            this.firePropertyChange(SEASON_THUMB_FILENAME, null, this.seasonThumbFilenames);
        }
    }

    public void clearSeasonThumbFilenames() {
        this.seasonThumbFilenames.clear();
        this.firePropertyChange(SEASON_THUMB_FILENAME, null, this.seasonThumbFilenames);
    }

    public List<TvShowSeasonThumbNaming> getSeasonThumbFilenames() {
        return new ArrayList<TvShowSeasonThumbNaming>(this.seasonThumbFilenames);
    }

    public void addEpisodeNfoFilename(TvShowEpisodeNfoNaming filename) {
        if (!this.episodeNfoFilenames.contains(filename)) {
            this.episodeNfoFilenames.add(filename);
            this.firePropertyChange(EPISODE_NFO_FILENAME, null, this.episodeNfoFilenames);
        }
    }

    public void clearEpisodeNfoFilenames() {
        this.episodeNfoFilenames.clear();
        this.firePropertyChange(EPISODE_NFO_FILENAME, null, this.episodeNfoFilenames);
    }

    public List<TvShowEpisodeNfoNaming> getEpisodeNfoFilenames() {
        return new ArrayList<TvShowEpisodeNfoNaming>(this.episodeNfoFilenames);
    }

    public void addEpisodeCheckImages(MediaArtwork.MediaArtworkType type) {
        if (!this.episodeCheckImages.contains((Object)type)) {
            this.episodeCheckImages.add(type);
            this.firePropertyChange(EPISODE_CHECK_IMAGES, null, this.episodeCheckImages);
        }
    }

    public void clearEpisodeCheckImages() {
        this.episodeCheckImages.clear();
        this.firePropertyChange(EPISODE_CHECK_IMAGES, null, this.episodeCheckImages);
    }

    public List<MediaArtwork.MediaArtworkType> getEpisodeCheckImages() {
        return new ArrayList<MediaArtwork.MediaArtworkType>(this.episodeCheckImages);
    }

    public void addSeasonCheckImages(MediaArtwork.MediaArtworkType type) {
        if (!this.seasonCheckImages.contains((Object)type)) {
            this.seasonCheckImages.add(type);
            this.firePropertyChange(SEASON_CHECK_IMAGES, null, this.seasonCheckImages);
        }
    }

    public void clearSeasonCheckImages() {
        this.seasonCheckImages.clear();
        this.firePropertyChange(SEASON_CHECK_IMAGES, null, this.seasonCheckImages);
    }

    public List<MediaArtwork.MediaArtworkType> getSeasonCheckImages() {
        return new ArrayList<MediaArtwork.MediaArtworkType>(this.seasonCheckImages);
    }

    public void addTvShowCheckImages(MediaArtwork.MediaArtworkType type) {
        if (!this.tvShowCheckImages.contains((Object)type)) {
            this.tvShowCheckImages.add(type);
            this.firePropertyChange(TVSHOW_CHECK_IMAGES, null, this.tvShowCheckImages);
        }
    }

    public void clearTvShowCheckImages() {
        this.tvShowCheckImages.clear();
        this.firePropertyChange(TVSHOW_CHECK_IMAGES, null, this.tvShowCheckImages);
    }

    public List<MediaArtwork.MediaArtworkType> getTvShowCheckImages() {
        return new ArrayList<MediaArtwork.MediaArtworkType>(this.tvShowCheckImages);
    }

    public CertificationStyle getCertificationStyle() {
        return this.certificationStyle;
    }

    public void setCertificationStyle(CertificationStyle newValue) {
        CertificationStyle oldValue = this.certificationStyle;
        this.certificationStyle = newValue;
        this.firePropertyChange("certificationStyle", (Object)oldValue, (Object)newValue);
    }

    public TvShowConnectors getTvShowConnector() {
        return this.tvShowConnector;
    }

    public void setTvShowConnector(TvShowConnectors newValue) {
        TvShowConnectors oldValue = this.tvShowConnector;
        this.tvShowConnector = newValue;
        this.firePropertyChange("tvShowConnector", (Object)oldValue, (Object)newValue);
    }

    public boolean isWriteCleanNfo() {
        return this.writeCleanNfo;
    }

    public void setWriteCleanNfo(boolean newValue) {
        boolean oldValue = this.writeCleanNfo;
        this.writeCleanNfo = newValue;
        this.firePropertyChange("writeCleanNfo", oldValue, newValue);
    }

    public DateField getNfoDateAddedField() {
        return this.nfoDateAddedField;
    }

    public void setNfoDateAddedField(DateField newValue) {
        DateField oldValue = this.nfoDateAddedField;
        this.nfoDateAddedField = newValue;
        this.firePropertyChange("nfoDateAddedField", (Object)oldValue, (Object)newValue);
    }

    public MediaLanguages getNfoLanguage() {
        return this.nfoLanguage;
    }

    public void setNfoLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.nfoLanguage;
        this.nfoLanguage = newValue;
        this.firePropertyChange("nfoLanguage", (Object)oldValue, (Object)newValue);
    }

    public boolean getPreferPersonalRating() {
        return this.preferPersonalRating;
    }

    public void setPreferPersonalRating(boolean newValue) {
        boolean oldValue = this.preferPersonalRating;
        this.preferPersonalRating = newValue;
        this.firePropertyChange("preferPersonalRating", oldValue, newValue);
    }

    public String getPreferredRating() {
        return this.preferredRating;
    }

    public void setPreferredRating(String newValue) {
        String oldValue = this.preferredRating;
        this.preferredRating = newValue;
        this.firePropertyChange("preferredRating", oldValue, newValue);
    }

    public boolean isWriteActorImages() {
        return this.writeActorImages;
    }

    public void setWriteActorImages(boolean newValue) {
        boolean oldValue = this.writeActorImages;
        this.writeActorImages = newValue;
        this.firePropertyChange("writeActorImages", oldValue, newValue);
    }

    public void setRenameAfterScrape(boolean newValue) {
        boolean oldValue = this.renameAfterScrape;
        this.renameAfterScrape = newValue;
        this.firePropertyChange("renameAfterScrape", oldValue, newValue);
    }

    public boolean isRenameAfterScrape() {
        return this.renameAfterScrape;
    }

    public int getImageExtraFanartCount() {
        return this.imageExtraFanartCount;
    }

    public void setImageExtraFanartCount(int newValue) {
        int oldValue = this.imageExtraFanartCount;
        this.imageExtraFanartCount = newValue;
        this.firePropertyChange("imageExtraFanartCount", oldValue, newValue);
    }

    public boolean isImageExtraFanart() {
        return this.imageExtraFanart;
    }

    public void setImageExtraFanart(boolean newValue) {
        boolean oldValue = this.imageExtraFanart;
        this.imageExtraFanart = newValue;
        this.firePropertyChange("imageExtraFanart", oldValue, newValue);
    }

    public boolean getCapitalWordsInTitles() {
        return this.capitalWordsinTitles;
    }

    public void setCapitalWordsInTitles(boolean newValue) {
        boolean oldValue = this.capitalWordsinTitles;
        this.capitalWordsinTitles = newValue;
        this.firePropertyChange("capitalWordsInTitles", oldValue, newValue);
    }

    public boolean isShowLogosPanel() {
        return this.showLogosPanel;
    }

    public void setShowLogosPanel(boolean newValue) {
        boolean oldValue = this.showLogosPanel;
        this.showLogosPanel = newValue;
        this.firePropertyChange("showLogosPanel", oldValue, newValue);
    }

    public void setDefaultSettingsForXbmc() {
        this.nfoFilenames.clear();
        this.nfoFilenames.add(TvShowNfoNaming.TV_SHOW);
        this.posterFilenames.clear();
        this.posterFilenames.add(TvShowPosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.fanartFilenames.add(TvShowFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.bannerFilenames.add(TvShowBannerNaming.BANNER);
        this.discartFilenames.clear();
        this.discartFilenames.add(TvShowDiscartNaming.DISCART);
        this.clearartFilenames.clear();
        this.clearartFilenames.add(TvShowClearartNaming.CLEARART);
        this.logoFilenames.clear();
        this.logoFilenames.add(TvShowLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.clearlogoFilenames.add(TvShowClearlogoNaming.CLEARLOGO);
        this.characterartFilenames.clear();
        this.characterartFilenames.add(TvShowCharacterartNaming.CHARACTERART);
        this.thumbFilenames.clear();
        this.thumbFilenames.add(TvShowThumbNaming.THUMB);
        this.keyartFilenames.clear();
        this.keyartFilenames.add(TvShowKeyartNaming.KEYART);
        this.seasonPosterFilenames.clear();
        this.seasonPosterFilenames.add(TvShowSeasonPosterNaming.SEASON_POSTER);
        this.seasonBannerFilenames.clear();
        this.seasonBannerFilenames.add(TvShowSeasonBannerNaming.SEASON_BANNER);
        this.seasonThumbFilenames.clear();
        this.seasonThumbFilenames.add(TvShowSeasonThumbNaming.SEASON_THUMB);
        this.episodeNfoFilenames.clear();
        this.episodeNfoFilenames.add(TvShowEpisodeNfoNaming.FILENAME);
        this.episodeThumbFilenames.clear();
        this.episodeThumbFilenames.add(TvShowEpisodeThumbNaming.FILENAME_THUMB);
        this.setTvShowConnector(TvShowConnectors.XBMC);
        this.setRenamerTvShowFoldername(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerSeasonFoldername(DEFAULT_RENAMER_SEASON_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.LARGE);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForKodi() {
        this.nfoFilenames.clear();
        this.nfoFilenames.add(TvShowNfoNaming.TV_SHOW);
        this.posterFilenames.clear();
        this.posterFilenames.add(TvShowPosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.fanartFilenames.add(TvShowFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.bannerFilenames.add(TvShowBannerNaming.BANNER);
        this.discartFilenames.clear();
        this.discartFilenames.add(TvShowDiscartNaming.DISCART);
        this.clearartFilenames.clear();
        this.clearartFilenames.add(TvShowClearartNaming.CLEARART);
        this.logoFilenames.clear();
        this.logoFilenames.add(TvShowLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.clearlogoFilenames.add(TvShowClearlogoNaming.CLEARLOGO);
        this.characterartFilenames.clear();
        this.characterartFilenames.add(TvShowCharacterartNaming.CHARACTERART);
        this.thumbFilenames.clear();
        this.thumbFilenames.add(TvShowThumbNaming.LANDSCAPE);
        this.keyartFilenames.clear();
        this.keyartFilenames.add(TvShowKeyartNaming.KEYART);
        this.seasonPosterFilenames.clear();
        this.seasonPosterFilenames.add(TvShowSeasonPosterNaming.SEASON_POSTER);
        this.seasonBannerFilenames.clear();
        this.seasonBannerFilenames.add(TvShowSeasonBannerNaming.SEASON_BANNER);
        this.seasonThumbFilenames.clear();
        this.seasonThumbFilenames.add(TvShowSeasonThumbNaming.SEASON_THUMB);
        this.episodeNfoFilenames.clear();
        this.episodeNfoFilenames.add(TvShowEpisodeNfoNaming.FILENAME);
        this.episodeThumbFilenames.clear();
        this.episodeThumbFilenames.add(TvShowEpisodeThumbNaming.FILENAME_THUMB);
        this.setTvShowConnector(TvShowConnectors.KODI);
        this.setRenamerTvShowFoldername(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerSeasonFoldername(DEFAULT_RENAMER_SEASON_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.LARGE);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForMediaPortal() {
        this.nfoFilenames.clear();
        this.nfoFilenames.add(TvShowNfoNaming.TV_SHOW);
        this.posterFilenames.clear();
        this.posterFilenames.add(TvShowPosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.fanartFilenames.add(TvShowFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.bannerFilenames.add(TvShowBannerNaming.BANNER);
        this.discartFilenames.clear();
        this.discartFilenames.add(TvShowDiscartNaming.DISCART);
        this.clearartFilenames.clear();
        this.clearartFilenames.add(TvShowClearartNaming.CLEARART);
        this.logoFilenames.clear();
        this.logoFilenames.add(TvShowLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.clearlogoFilenames.add(TvShowClearlogoNaming.CLEARLOGO);
        this.characterartFilenames.clear();
        this.characterartFilenames.add(TvShowCharacterartNaming.CHARACTERART);
        this.thumbFilenames.clear();
        this.thumbFilenames.add(TvShowThumbNaming.THUMB);
        this.keyartFilenames.clear();
        this.keyartFilenames.add(TvShowKeyartNaming.KEYART);
        this.seasonPosterFilenames.clear();
        this.seasonPosterFilenames.add(TvShowSeasonPosterNaming.SEASON_POSTER);
        this.seasonBannerFilenames.clear();
        this.seasonBannerFilenames.add(TvShowSeasonBannerNaming.SEASON_BANNER);
        this.seasonThumbFilenames.clear();
        this.seasonThumbFilenames.add(TvShowSeasonThumbNaming.SEASON_THUMB);
        this.episodeNfoFilenames.clear();
        this.episodeNfoFilenames.add(TvShowEpisodeNfoNaming.FILENAME);
        this.episodeThumbFilenames.clear();
        this.episodeThumbFilenames.add(TvShowEpisodeThumbNaming.FILENAME);
        this.setTvShowConnector(TvShowConnectors.XBMC);
        this.setRenamerTvShowFoldername(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerSeasonFoldername(DEFAULT_RENAMER_SEASON_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.TECHNICAL);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultSettingsForPlex() {
        this.nfoFilenames.clear();
        this.nfoFilenames.add(TvShowNfoNaming.TV_SHOW);
        this.posterFilenames.clear();
        this.posterFilenames.add(TvShowPosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.fanartFilenames.add(TvShowFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.bannerFilenames.add(TvShowBannerNaming.BANNER);
        this.discartFilenames.clear();
        this.discartFilenames.add(TvShowDiscartNaming.DISCART);
        this.clearartFilenames.clear();
        this.clearartFilenames.add(TvShowClearartNaming.CLEARART);
        this.logoFilenames.clear();
        this.logoFilenames.add(TvShowLogoNaming.LOGO);
        this.clearlogoFilenames.clear();
        this.clearlogoFilenames.add(TvShowClearlogoNaming.CLEARLOGO);
        this.characterartFilenames.clear();
        this.characterartFilenames.add(TvShowCharacterartNaming.CHARACTERART);
        this.thumbFilenames.clear();
        this.thumbFilenames.add(TvShowThumbNaming.THUMB);
        this.keyartFilenames.clear();
        this.keyartFilenames.add(TvShowKeyartNaming.KEYART);
        this.seasonPosterFilenames.clear();
        this.seasonPosterFilenames.add(TvShowSeasonPosterNaming.SEASON_FOLDER);
        this.seasonBannerFilenames.clear();
        this.seasonBannerFilenames.add(TvShowSeasonBannerNaming.SEASON_FOLDER);
        this.seasonThumbFilenames.clear();
        this.seasonThumbFilenames.add(TvShowSeasonThumbNaming.SEASON_FOLDER);
        this.episodeNfoFilenames.clear();
        this.episodeNfoFilenames.add(TvShowEpisodeNfoNaming.FILENAME);
        this.episodeThumbFilenames.clear();
        this.episodeThumbFilenames.add(TvShowEpisodeThumbNaming.FILENAME);
        this.setTvShowConnector(TvShowConnectors.XBMC);
        this.setRenamerTvShowFoldername(DEFAULT_RENAMER_FOLDER_PATTERN);
        this.setRenamerSeasonFoldername(DEFAULT_RENAMER_SEASON_PATTERN);
        this.setRenamerFilename(DEFAULT_RENAMER_FILE_PATTERN);
        this.setCertificationStyle(CertificationStyle.SHORT);
        this.firePropertyChange("preset", false, true);
    }

    public void setDefaultScrapers() {
        this.artworkScrapers.clear();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.TV_SHOW_ARTWORK)) {
            this.addTvShowArtworkScraper(ms.getId());
        }
        this.trailerScrapers.clear();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.TVSHOW_TRAILER)) {
            this.addTvShowTrailerScraper(ms.getId());
        }
        this.subtitleScrapers.clear();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.SUBTITLE)) {
            this.addTvShowSubtitleScraper(ms.getId());
        }
    }
}

