/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToKodiConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToXbmcConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowActorImageFetcherTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowEpisode
extends MediaEntity
implements Comparable<TvShowEpisode>,
IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisode.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    @JsonProperty
    private int episode = -1;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private int season = -1;
    @JsonProperty
    private int dvdSeason = -1;
    @JsonProperty
    private int dvdEpisode = -1;
    @JsonProperty
    private int displaySeason = -1;
    @JsonProperty
    private int displayEpisode = -1;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private boolean disc = false;
    @JsonProperty
    private boolean multiEpisode = false;
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private boolean isDvdOrder = false;
    @JsonProperty
    private UUID tvShowId = null;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private boolean stacked = false;
    @JsonProperty
    private List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<Person> directors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<Person> writers = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    private TvShow tvShow = null;
    private String titleSortable = "";
    private Date lastWatched = null;
    private boolean dummy = false;

    public TvShowEpisode() {
    }

    public void merge(TvShowEpisode other) {
        this.merge(other, false);
    }

    public void forceMerge(TvShowEpisode other) {
        this.merge(other, true);
    }

    void merge(TvShowEpisode other, boolean force) {
        if (other == null) {
            return;
        }
        super.merge(other, force);
        this.setEpisode(this.episode < 0 || force ? other.episode : this.episode);
        this.setSeason(this.season < 0 || force ? other.season : this.season);
        this.setDvdEpisode(this.dvdEpisode < 0 || force ? other.dvdEpisode : this.dvdEpisode);
        this.setDvdSeason(this.dvdSeason < 0 || force ? other.dvdSeason : this.dvdSeason);
        this.setDisplayEpisode(this.displayEpisode < 0 || force ? other.displayEpisode : this.displayEpisode);
        this.setDisplaySeason(this.displaySeason < 0 || force ? other.displaySeason : this.displaySeason);
        this.setFirstAired(this.firstAired == null || force ? other.firstAired : this.firstAired);
        this.setWatched(!this.watched || force ? other.watched : this.watched);
        this.setMediaSource(this.mediaSource == MediaSource.UNKNOWN || force ? other.mediaSource : this.mediaSource);
        if (force) {
            this.tags.clear();
            this.actors.clear();
            this.directors.clear();
            this.writers.clear();
        }
        this.setTags(other.tags);
        this.setActors(other.actors);
        this.setDirectors(other.directors);
        this.setWriters(other.writers);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    public void replacePathForRenamedFolder(Path oldPath, Path newPath) {
        String p = this.getPathNIO().toAbsolutePath().toString();
        p = p.replace(oldPath.toAbsolutePath().toString(), newPath.toAbsolutePath().toString());
        this.setPath(p);
    }

    public TvShowEpisode(TvShowEpisode source) {
        this.tvShow = source.tvShow;
        for (MediaFile mediaFile : source.getMediaFiles()) {
            this.addToMediaFiles(new MediaFile(mediaFile));
        }
        this.path = source.path;
        this.title = source.title;
        this.originalTitle = source.originalTitle;
        this.year = source.year;
        this.plot = source.plot;
        for (Map.Entry entry : source.artworkUrlMap.entrySet()) {
            this.artworkUrlMap.put((MediaFileType)((Object)entry.getKey()), (String)entry.getValue());
        }
        this.dateAdded = new Date(source.dateAdded.getTime());
        this.scraped = source.scraped;
        this.ids.putAll(source.ids);
        this.episode = source.episode;
        this.season = source.season;
        this.dvdEpisode = source.dvdEpisode;
        this.dvdSeason = source.dvdSeason;
        this.isDvdOrder = source.isDvdOrder;
        if (source.firstAired != null) {
            this.firstAired = new Date(source.firstAired.getTime());
        }
        this.disc = source.disc;
        this.watched = source.watched;
        for (Person person : source.getActors()) {
            this.actors.add(new Person(person));
        }
        for (Person person : source.getDirectors()) {
            this.directors.add(new Person(person));
        }
        for (Person person : source.getWriters()) {
            this.writers.add(new Person(person));
        }
        for (MediaRating mediaRating : source.getRatings().values()) {
            this.ratings.put(mediaRating.getId(), new MediaRating(mediaRating));
        }
    }

    public String getTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
        if (this.firstAired != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.firstAired);
            this.setYear(calendar.get(1));
        }
    }

    public TvShowSeason getTvShowSeason() {
        if (this.tvShow == null) {
            return null;
        }
        return this.tvShow.getSeasonForEpisode(this);
    }

    public void setTvShowSeason() {
    }

    public boolean isDisc() {
        return this.disc;
    }

    public void setDisc(boolean disc) {
        this.disc = disc;
    }

    public boolean isMultiEpisode() {
        return this.multiEpisode;
    }

    public void setMultiEpisode(boolean multiEpisode) {
        this.multiEpisode = multiEpisode;
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate(aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public void setTvShow(TvShow newValue) {
        TvShow oldValue = this.tvShow;
        this.tvShow = newValue;
        this.tvShowId = this.tvShow.getDbId();
        this.firePropertyChange("tvShow", oldValue, newValue);
    }

    public UUID getTvShowDbId() {
        return this.tvShowId;
    }

    @Override
    public String getDataSource() {
        return this.tvShow.getDataSource();
    }

    public int getEpisode() {
        if (this.isDvdOrder) {
            return this.dvdEpisode;
        }
        return this.episode;
    }

    public int getSeason() {
        if (this.isDvdOrder) {
            return this.dvdSeason;
        }
        return this.season;
    }

    public void setEpisode(int newValue) {
        if (this.isDvdOrder) {
            this.setDvdEpisode(newValue);
        } else {
            this.setAiredEpisode(newValue);
        }
        this.firePropertyChange("titleForUi", "", newValue);
    }

    public void setAiredEpisode(int newValue) {
        int oldValue = this.episode;
        this.episode = newValue;
        if (!this.isDvdOrder) {
            this.firePropertyChange("episode", oldValue, newValue);
        }
        this.firePropertyChange("airedEpisode", oldValue, newValue);
    }

    public int getAiredEpisode() {
        return this.episode;
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public void setSeason(int newValue) {
        if (this.isDvdOrder) {
            this.setDvdSeason(newValue);
        } else {
            this.setAiredSeason(newValue);
        }
        this.firePropertyChange("titleForUi", "", newValue);
    }

    public void setAiredSeason(int newValue) {
        int oldValue = this.season;
        this.season = newValue;
        if (!this.isDvdOrder) {
            this.firePropertyChange("season", oldValue, newValue);
        }
        this.firePropertyChange("airedSeason", oldValue, newValue);
    }

    public int getAiredSeason() {
        return this.season;
    }

    @Override
    public MediaRating getRating() {
        MediaRating mediaRating = null;
        if (TvShowModuleManager.SETTINGS.getPreferPersonalRating()) {
            mediaRating = (MediaRating)this.ratings.get("user");
        }
        if (mediaRating == null) {
            mediaRating = (MediaRating)this.ratings.get(TvShowModuleManager.SETTINGS.getPreferredRating());
        }
        if (mediaRating == null) {
            mediaRating = (MediaRating)this.ratings.get("NFO");
        }
        if (mediaRating == null) {
            mediaRating = (MediaRating)this.ratings.get("default");
        }
        if (mediaRating == null && !this.ratings.isEmpty()) {
            mediaRating = (MediaRating)this.ratings.values().iterator().next();
        }
        if (mediaRating == null) {
            mediaRating = new MediaRating();
        }
        return mediaRating;
    }

    public String getTitleForUi() {
        StringBuilder titleForUi = new StringBuilder();
        int episode = this.getEpisode();
        int season = this.getSeason();
        if (episode > 0 && season > 0) {
            titleForUi.append(String.format("S%02dE%02d - ", season, episode));
        }
        titleForUi.append(this.title);
        return titleForUi.toString();
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
    }

    public void downloadArtwork(MediaFileType type) {
        switch (type) {
            case THUMB: {
                this.writeThumbImage();
                break;
            }
        }
    }

    private void writeThumbImage() {
        String thumbUrl = this.getArtworkUrl(MediaFileType.THUMB);
        if (StringUtils.isNotBlank((CharSequence)thumbUrl)) {
            boolean firstImage = false;
            MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
            String basename = FilenameUtils.getBaseName((String)mf.getFilename());
            int i = 0;
            for (TvShowEpisodeThumbNaming thumbNaming : TvShowModuleManager.SETTINGS.getEpisodeThumbFilenames()) {
                String filename = thumbNaming.getFilename(basename, Utils.getArtworkExtension(thumbUrl));
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                if (this.isDisc()) {
                    filename = "thumb." + FilenameUtils.getExtension((String)thumbUrl);
                }
                if (++i == 1) {
                    firstImage = true;
                }
                MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(this, thumbUrl, MediaArtwork.MediaArtworkType.THUMB, filename, firstImage);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
        if (thumbUrl.startsWith("file:")) {
            this.removeArtworkUrl(MediaFileType.THUMB);
        }
    }

    public void setMetadata(MediaMetadata metadata, List<TvShowEpisodeScraperMetadataConfig> config) {
        List<MediaArtwork> mas;
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        boolean writeNewThumb = false;
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            this.ids.clear();
        }
        this.setIds(metadata.getIds());
        if (config.contains(TvShowEpisodeScraperMetadataConfig.TITLE)) {
            if (TvShowModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.ORIGINAL_TITLE)) {
            if (TvShowModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setOriginalTitle(WordUtils.capitalize((String)metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.PLOT)) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.AIRED_SEASON_EPISODE)) {
            this.setAiredSeason(metadata.getSeasonNumber());
            this.setAiredEpisode(metadata.getEpisodeNumber());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.DVD_SEASON_EPISODE)) {
            this.setDvdSeason(metadata.getDvdSeasonNumber());
            this.setDvdEpisode(metadata.getDvdEpisodeNumber());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.DISPLAY_SEASON_EPISODE)) {
            this.setDisplaySeason(metadata.getDisplaySeasonNumber());
            this.setDisplayEpisode(metadata.getDisplayEpisodeNumber());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.AIRED)) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            for (MediaRating mediaRating : metadata.getRatings()) {
                newRatings.put(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.TAGS)) {
            this.setTags(metadata.getTags());
        }
        if (ScraperMetadataConfig.containsAnyCast(config)) {
            if (config.contains(TvShowEpisodeScraperMetadataConfig.ACTORS)) {
                this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
                this.writeActorImages();
            }
            if (config.contains(TvShowEpisodeScraperMetadataConfig.DIRECTORS)) {
                this.setDirectors(metadata.getCastMembers(Person.Type.DIRECTOR));
            }
            if (config.contains(TvShowEpisodeScraperMetadataConfig.WRITERS)) {
                this.setWriters(metadata.getCastMembers(Person.Type.WRITER));
            }
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.THUMB) && !(mas = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB)).isEmpty()) {
            this.setArtworkUrl(mas.get(0).getDefaultUrl(), MediaFileType.THUMB);
            writeNewThumb = true;
        }
        this.writeNFO();
        this.saveToDb();
        if (TvShowModuleManager.SETTINGS.isRenameAfterScrape()) {
            TvShowRenamer.renameEpisode(this);
        }
        if (writeNewThumb) {
            this.writeThumbImage();
        }
    }

    public void writeNFO() {
        List<TvShowEpisodeNfoNaming> nfoNamings = TvShowModuleManager.SETTINGS.getEpisodeNfoFilenames();
        if (nfoNamings.isEmpty()) {
            return;
        }
        ArrayList<TvShowEpisode> episodesInNfo = new ArrayList<TvShowEpisode>(1);
        LOGGER.debug("write nfo: " + this.getTvShow().getTitle() + " S" + this.getSeason() + "E" + this.getEpisode());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>(TvShowList.getTvEpisodesByFile(this.tvShow, mf.getFile()));
            for (TvShowEpisode ep : eps) {
                if (episodesInNfo.contains(ep)) continue;
                episodesInNfo.add(ep);
            }
        }
        TvShowEpisodeGenericXmlConnector connector = null;
        switch (TvShowModuleManager.SETTINGS.getTvShowConnector()) {
            case KODI: {
                connector = new TvShowEpisodeToKodiConnector(episodesInNfo);
                break;
            }
            default: {
                connector = new TvShowEpisodeToXbmcConnector(episodesInNfo);
            }
        }
        if (connector != null) {
            connector.write(Collections.singletonList(TvShowEpisodeNfoNaming.FILENAME));
        }
        this.firePropertyChange("hasNfoFile", false, true);
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        return nfos != null && !nfos.isEmpty();
    }

    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : TvShowModuleManager.SETTINGS.getEpisodeCheckImages()) {
            if (!StringUtils.isBlank((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public void addActor(Person newActor) {
        this.actors.add(newActor);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public void removeActor(Person actor) {
        this.actors.remove(actor);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<Person> getActors() {
        ArrayList<Person> allActors = new ArrayList<Person>();
        if (this.tvShow != null) {
            allActors.addAll(this.tvShow.getActors());
        }
        allActors.addAll(this.actors);
        return allActors;
    }

    public List<Person> getGuests() {
        return this.actors;
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        if (this.getTvShow() != null) {
            for (Person actor : this.getTvShow().getActors()) {
                newActors.remove(actor);
            }
        }
        ListUtils.mergeLists(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public void addDirector(Person director) {
        this.directors.add(director);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public void removeDirector(Person director) {
        this.directors.remove(director);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    @JsonSetter
    public void setDirectors(List<Person> newDirectors) {
        ListUtils.mergeLists(this.directors, newDirectors);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public List<Person> getDirectors() {
        return this.directors;
    }

    public String getDirectorsAsString() {
        ArrayList<String> directorNames = new ArrayList<String>();
        for (Person director : this.directors) {
            directorNames.add(director.getName());
        }
        return StringUtils.join(directorNames, (String)", ");
    }

    public void addWriter(Person writer) {
        this.writers.add(writer);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public void removeWriter(Person writer) {
        this.writers.remove(writer);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    @JsonSetter
    public void setWriters(List<Person> newWriters) {
        ListUtils.mergeLists(this.writers, newWriters);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public List<Person> getWriters() {
        return this.writers;
    }

    public String getWritersAsString() {
        ArrayList<String> writerNames = new ArrayList<String>();
        for (Person writer : this.writers) {
            writerNames.add(writer.getName());
        }
        return StringUtils.join(writerNames, (String)", ");
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public String getMediaInfoAudioCodecAndChannels() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videos.isEmpty()) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getAudioCodec() + "_" + mediaFile.getAudioChannels();
        }
        return "";
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        return filesToCache;
    }

    @Override
    public int compareTo(TvShowEpisode otherTvShowEpisode) {
        if (this.getTvShow() != otherTvShowEpisode.getTvShow()) {
            return this.getTvShow().getTitle().compareTo(otherTvShowEpisode.getTvShow().getTitle());
        }
        if (this.getSeason() != otherTvShowEpisode.getSeason()) {
            return this.getSeason() - otherTvShowEpisode.getSeason();
        }
        if (this.getEpisode() != otherTvShowEpisode.getEpisode()) {
            return this.getEpisode() - otherTvShowEpisode.getEpisode();
        }
        String filename1 = "";
        try {
            filename1 = this.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String filename2 = "";
        try {
            filename2 = otherTvShowEpisode.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filename1.compareTo(filename2);
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videoFiles.isEmpty()) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        mediaFilesWithAudioStreams.addAll(this.getMediaFiles(MediaFileType.AUDIO));
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    public boolean getHasSubtitles() {
        if (!this.getMediaFiles(MediaFileType.SUBTITLE).isEmpty()) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public int getRuntimeFromMediaFiles() {
        int runtime = 0;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            runtime += mf.getDuration();
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFiles() / 60;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowList.getInstance().persistEpisode(this);
    }

    @Override
    public void deleteFromDb() {
        TvShowList.getInstance().removeEpisodeFromDb(this);
    }

    void setSeasonArtworkChanged(MediaArtwork.MediaArtworkType type) {
        switch (type) {
            case SEASON_POSTER: {
                this.firePropertyChange("seasonPoster", null, "");
                break;
            }
            case SEASON_BANNER: {
                this.firePropertyChange("seasonBanner", null, "");
                break;
            }
            case SEASON_THUMB: {
                this.firePropertyChange("seasonThumb", null, "");
                break;
            }
        }
    }

    @Override
    public boolean isScraped() {
        if (!this.scraped && !this.plot.isEmpty() && this.firstAired != null && this.getSeason() > -1 && this.getEpisode() > -1) {
            return true;
        }
        return this.scraped;
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        for (String tag : this.tags) {
            if (!tag.equals(newTag)) continue;
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        ListUtils.mergeLists(this.tags, newTags);
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public String getTvdbId() {
        Object obj = this.ids.get("tvdb");
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int getDvdSeason() {
        return this.dvdSeason;
    }

    public void setDvdSeason(int newValue) {
        int oldValue = this.dvdSeason;
        this.dvdSeason = newValue;
        if (this.isDvdOrder) {
            this.firePropertyChange("season", oldValue, newValue);
        }
        this.firePropertyChange("dvdSeason", oldValue, newValue);
    }

    public int getDvdEpisode() {
        return this.dvdEpisode;
    }

    public void setDvdEpisode(int newValue) {
        int oldValue = this.dvdEpisode;
        this.dvdEpisode = newValue;
        if (this.isDvdOrder) {
            this.firePropertyChange("episode", oldValue, newValue);
        }
        this.firePropertyChange("dvdEpisode", oldValue, newValue);
    }

    public void setDisplaySeason(int newValue) {
        int oldValue = this.displaySeason;
        this.displaySeason = newValue;
        this.firePropertyChange("displaySeason", oldValue, newValue);
    }

    public int getDisplaySeason() {
        return this.displaySeason;
    }

    public void setDisplayEpisode(int newValue) {
        int oldValue = this.displayEpisode;
        this.displayEpisode = newValue;
        this.firePropertyChange("displayEpisode", oldValue, newValue);
    }

    public int getDisplayEpisode() {
        return this.displayEpisode;
    }

    public boolean isDvdOrder() {
        return this.isDvdOrder;
    }

    public void setDvdOrder(boolean newValue) {
        boolean oldValue = this.isDvdOrder;
        this.isDvdOrder = newValue;
        this.firePropertyChange("dvdOrder", oldValue, newValue);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", oldValue, newValue);
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public boolean deleteFilesSafely() {
        boolean result = true;
        List<MediaFile> mediaFiles = this.getMediaFiles();
        for (MediaFile mf : mediaFiles) {
            if (mf.deleteSafely(this.tvShow.getDataSource())) continue;
            result = false;
        }
        return result;
    }

    @Override
    public MediaCertification getCertification() {
        return null;
    }

    @Override
    public MediaFile getMainVideoFile() {
        MediaFile vid = null;
        vid = this.stacked ? this.getMediaFiles(MediaFileType.VIDEO).stream().min(Comparator.comparingInt(MediaFile::getStacking)).orElse(new MediaFile()) : this.getBiggestMediaFile(MediaFileType.VIDEO);
        if (vid != null) {
            return vid;
        }
        return new MediaFile();
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return this.getMainVideoFile().getVideoResolution();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return this.getMainVideoFile().getVideoFormat();
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return this.getMainVideoFile().getVideoCodec();
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return this.getMainVideoFile().getAspectRatio();
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return this.getMainVideoFile().getAudioCodec();
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        return this.getMainVideoFile().getAudioCodecList();
    }

    @Override
    public double getMediaInfoFrameRate() {
        return this.getMainVideoFile().getFrameRate();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return this.getMainVideoFile().getAudioChannels();
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        return this.getMainVideoFile().getAudioChannelsList();
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return this.getMainVideoFile().getAudioLanguage();
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return this.getMainVideoFile().getBitDepth();
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        return this.getMainVideoFile().getAudioLanguagesList();
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        return this.getMainVideoFile().getSubtitleLanguagesList();
    }

    @Override
    public String getMediaInfoContainerFormat() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videos.isEmpty()) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getContainerFormat();
        }
        return "";
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return this.getMediaSource();
    }

    @Override
    public String getVideoHDRFormat() {
        return this.getMainVideoFile().getHdrFormat();
    }

    @Override
    public boolean isVideoIn3D() {
        String video3DFormat = "";
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videos.isEmpty()) {
            MediaFile mediaFile = videos.get(0);
            video3DFormat = mediaFile.getVideo3DFormat();
        }
        return StringUtils.isNotBlank((CharSequence)video3DFormat);
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            filesize += mf.getFilesize();
        }
        return filesize;
    }

    public boolean isDummy() {
        return this.dummy || !this.hasMediaFiles();
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public String getNfoFilename(TvShowEpisodeNfoNaming nfoNaming) {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        MediaFile firstMediaFile = mfs.get(0);
        String baseName = "";
        if (this.isDisc()) {
            if (firstMediaFile.isBlurayFile()) {
                baseName = "BDMV.nfo";
            }
            if (firstMediaFile.isDVDFile()) {
                baseName = "VIDEO_TS.nfo";
            }
            if (firstMediaFile.isHdDVDFile()) {
                baseName = "HVDVD_TS.nfo";
            }
        } else {
            baseName = firstMediaFile.getBasename();
        }
        return nfoNaming.getFilename(baseName, "nfo");
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public int getRuntime() {
        return this.tvShow.getRuntime();
    }

    @Override
    public String getProductionCompany() {
        if (StringUtils.isNotBlank((CharSequence)this.productionCompany)) {
            return this.productionCompany;
        }
        if (this.tvShow != null) {
            return this.tvShow.getProductionCompany();
        }
        return "";
    }

    public void writeActorImages() {
        if (!TvShowModuleManager.SETTINGS.isWriteActorImages()) {
            return;
        }
        TvShowActorImageFetcherTask task = new TvShowActorImageFetcherTask(this);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void reEvaluateStacking() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs.size() > 1 && !this.isDisc()) {
            this.setStacked(true);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.detectStackingInformation();
            }
        } else {
            this.setStacked(false);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.removeStackingInformation();
            }
        }
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            this.firePropertyChange("hasSubtitle", false, true);
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            this.firePropertyChange("hasSubtitle", true, false);
        }
    }
}

