/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class TvShowSeason
extends AbstractModelObject
implements Comparable<TvShowSeason> {
    private int season = -1;
    private String title = "";
    private TvShow tvShow;
    private List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private Date lastWatched = null;
    private PropertyChangeListener listener;

    public TvShowSeason(int season, TvShow tvShow) {
        this.season = season;
        this.tvShow = tvShow;
        this.listener = evt -> {
            if (evt.getSource() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)evt.getSource();
                switch (evt.getPropertyName()) {
                    case "mediaFiles": {
                        this.firePropertyChange("mediaFiles", null, evt.getNewValue());
                        break;
                    }
                    case "season": {
                        if (episode.getSeason() == season) break;
                        this.removeEpisode(episode);
                        break;
                    }
                    case "firstAired": {
                        this.firePropertyChange("firstAired", null, evt.getNewValue());
                    }
                }
            }
        };
    }

    public int getSeason() {
        return this.season;
    }

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange("title", oldValue, newValue);
        this.getTvShow().addSeasonTitle(this.season, newValue);
    }

    public String getTitle() {
        return this.title;
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public synchronized void addEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            return;
        }
        for (TvShowEpisode e : this.episodes) {
            if (episode.isDummy() && episode.getEpisode() == e.getEpisode() && episode.getSeason() == e.getSeason()) {
                return;
            }
            if (episode.isDummy() || !e.isDummy() || episode.getEpisode() != e.getEpisode() || episode.getSeason() != e.getSeason()) continue;
            this.tvShow.removeEpisode(e);
        }
        this.episodes.add(episode);
        this.episodes.sort(TvShowEpisode::compareTo);
        episode.addPropertyChangeListener(this.listener);
        this.firePropertyChange("addedEpisode", null, this.episodes);
        this.firePropertyChange("firstAired", null, this.getFirstAired());
    }

    public void removeEpisode(TvShowEpisode episode) {
        this.episodes.remove(episode);
        episode.removePropertyChangeListener(this.listener);
        this.firePropertyChange("removedEpisode", null, this.episodes);
        this.firePropertyChange("firstAired", null, this.getFirstAired());
    }

    public List<TvShowEpisode> getEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy()) continue;
            episodes.add(episode);
        }
        return episodes;
    }

    public Date getFirstAired() {
        if (this.episodes.isEmpty()) {
            return null;
        }
        return this.episodes.get(0).getFirstAired();
    }

    public boolean isWatched() {
        boolean watched = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || episode.isWatched()) continue;
            watched = false;
            break;
        }
        return watched;
    }

    public boolean hasEpisodeSubtitles() {
        boolean subtitles = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || episode.getHasSubtitles()) continue;
            subtitles = false;
            break;
        }
        return subtitles;
    }

    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : TvShowModuleManager.SETTINGS.getSeasonCheckImages()) {
            if (!StringUtils.isBlank((CharSequence)this.getArtworkFilename(type))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeImages() {
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || episode.getHasImages().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeNfoFiles() {
        boolean nfo = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || episode.getHasNfoFile().booleanValue()) continue;
            nfo = false;
            break;
        }
        return nfo;
    }

    public boolean isDummy() {
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy()) continue;
            return false;
        }
        return true;
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        return this.episodes;
    }

    public void setArtwork(MediaFile mediaFile) {
        MediaArtwork.MediaArtworkType artworkType = MediaFileType.getMediaArtworkType(mediaFile.getType());
        String oldValue = this.getArtworkFilename(artworkType);
        String newValue = mediaFile.getFile().toString();
        this.tvShow.setSeasonArtwork(this.season, mediaFile);
        switch (artworkType) {
            case SEASON_POSTER: {
                this.firePropertyChange("poster", oldValue, newValue);
                break;
            }
            case SEASON_BANNER: {
                this.firePropertyChange("banner", oldValue, newValue);
                break;
            }
            case SEASON_THUMB: {
                this.firePropertyChange("thumb", oldValue, newValue);
                break;
            }
            default: {
                return;
            }
        }
        for (TvShowEpisode episode : this.episodes) {
            episode.setSeasonArtworkChanged(artworkType);
        }
    }

    public void clearArtwork(MediaArtwork.MediaArtworkType artworkType) {
        this.tvShow.clearSeasonArtwork(this.season, artworkType);
        switch (artworkType) {
            case SEASON_POSTER: {
                this.firePropertyChange("poster", null, "");
                break;
            }
            case SEASON_BANNER: {
                this.firePropertyChange("banner", null, "");
                break;
            }
            case SEASON_THUMB: {
                this.firePropertyChange("thumb", null, "");
            }
        }
    }

    public String getArtworkFilename(MediaArtwork.MediaArtworkType type) {
        return this.tvShow.getSeasonArtwork(this.season, type);
    }

    public Dimension getArtworkSize(MediaArtwork.MediaArtworkType type) {
        return this.tvShow.getSeasonArtworkSize(this.season, type);
    }

    public void deleteArtworkFiles(MediaArtwork.MediaArtworkType type) {
        this.tvShow.deleteSeasonArtworkFiles(this.season, type);
        switch (type) {
            case SEASON_POSTER: {
                this.firePropertyChange("poster", null, "");
                break;
            }
            case SEASON_BANNER: {
                this.firePropertyChange("banner", null, "");
                break;
            }
            case SEASON_THUMB: {
                this.firePropertyChange("thumb", null, "");
            }
        }
    }

    public void setArtworkUrl(String newValue, MediaArtwork.MediaArtworkType artworkType) {
        String oldValue = this.getArtworkUrl(artworkType);
        this.tvShow.setSeasonArtworkUrl(this.season, newValue, artworkType);
        switch (artworkType) {
            case SEASON_POSTER: {
                this.firePropertyChange("posterUrl", oldValue, newValue);
                break;
            }
            case SEASON_BANNER: {
                this.firePropertyChange("bannerUrl", oldValue, newValue);
                break;
            }
            case SEASON_THUMB: {
                this.firePropertyChange("thumbUrl", oldValue, newValue);
                break;
            }
            default: {
                return;
            }
        }
        for (TvShowEpisode episode : this.episodes) {
            episode.setSeasonArtworkChanged(artworkType);
        }
    }

    public void removeArtworkUrl(MediaArtwork.MediaArtworkType artworkType) {
        this.tvShow.clearSeasonArtworkUrl(this.season, artworkType);
    }

    public String getArtworkUrl(MediaArtwork.MediaArtworkType type) {
        return this.tvShow.getSeasonArtworkUrl(this.season, type);
    }

    public void downloadArtwork(MediaArtwork.MediaArtworkType artworkType) {
        this.tvShow.downloadSeasonArtwork(this.season, artworkType);
    }

    public List<MediaFile> getMediaFiles() {
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(mfs);
        for (TvShowEpisode episode : this.episodes) {
            unique.addAll(episode.getMediaFiles());
        }
        mfs.addAll(unique);
        return mfs;
    }

    public List<MediaFile> getMediaFiles(MediaFileType type) {
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(mfs);
        for (TvShowEpisode episode : this.episodes) {
            unique.addAll(episode.getMediaFiles(type));
        }
        mfs.addAll(unique);
        return mfs;
    }

    public boolean isNewlyAdded() {
        for (TvShowEpisode episode : this.episodes) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    @Override
    public int compareTo(TvShowSeason o) {
        if (this.getTvShow() != o.getTvShow()) {
            return this.getTvShow().getTitle().compareTo(o.getTvShow().getTitle());
        }
        return Integer.compare(this.getSeason(), o.getSeason());
    }
}

