/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;

public class TvShowEpisodeScrapeTask
extends TmmTask {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeScrapeTask.class);
    private final List<TvShowEpisode> episodes;
    private final TvShowEpisodeSearchAndScrapeOptions scrapeOptions;
    private final List<TvShowEpisodeScraperMetadataConfig> config;

    public TvShowEpisodeScrapeTask(List<TvShowEpisode> episodes, TvShowEpisodeSearchAndScrapeOptions options, List<TvShowEpisodeScraperMetadataConfig> config) {
        super(BUNDLE.getString("tvshow.scraping"), episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.episodes = episodes;
        this.scrapeOptions = options;
        this.config = config;
    }

    @Override
    public void doInBackground() {
        for (TvShowEpisode tvShowEpisode : this.episodes) {
            if (tvShowEpisode.getTvShow().getIds().isEmpty()) {
                LOGGER.info("we cannot scrape (no ID): {} - {}", (Object)tvShowEpisode.getTvShow().getTitle(), (Object)tvShowEpisode.getTitle());
                continue;
            }
            TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions(this.scrapeOptions);
            MediaScraper mediaScraper = this.scrapeOptions.getMetadataScraper();
            MediaMetadata md = new MediaMetadata(mediaScraper.getMediaProvider().getProviderInfo().getId());
            md.setReleaseDate(tvShowEpisode.getFirstAired());
            options.setMetadata(md);
            for (Map.Entry<String, Object> entry : tvShowEpisode.getTvShow().getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            if (tvShowEpisode.isDvdOrder()) {
                options.setId("dvdSeasonNr", String.valueOf(tvShowEpisode.getDvdSeason()));
                options.setId("dvdEpisodeNr", String.valueOf(tvShowEpisode.getDvdEpisode()));
            } else {
                options.setId("seasonNr", String.valueOf(tvShowEpisode.getAiredSeason()));
                options.setId("episodeNr", String.valueOf(tvShowEpisode.getAiredEpisode()));
            }
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scrape metadata with scraper: {}", (Object)mediaScraper.getMediaProvider().getProviderInfo().getId());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                MediaMetadata metadata = ((ITvShowMetadataProvider)mediaScraper.getMediaProvider()).getMetadata(options);
                if (!StringUtils.isNotBlank((CharSequence)metadata.getTitle())) continue;
                tvShowEpisode.setMetadata(metadata, this.config);
            }
            catch (ScrapeException e) {
                LOGGER.error("searchMovieFallback", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShowEpisode, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, tvShowEpisode, "scraper.error.missingid"));
            }
            catch (NothingFoundException ignored) {
                LOGGER.debug("nothing found");
            }
        }
        if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
            HashSet<TvShow> tvShows = new HashSet<TvShow>();
            for (TvShowEpisode episode : this.episodes) {
                tvShows.add(episode.getTvShow());
            }
            SyncTraktTvTask syncTraktTvTask = new SyncTraktTvTask(null, new ArrayList<TvShow>(tvShows));
            TmmTaskManager.getInstance().addUnnamedTask(syncTraktTvTask);
        }
    }
}

