/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;

public class TvShowMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMissingArtworkDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final List<TvShow> tvShows;
    private final List<TvShowEpisode> episodes;
    private final TvShowSearchAndScrapeOptions scrapeOptions;
    private final List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig;
    private final List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig;

    public TvShowMissingArtworkDownloadTask(List<TvShow> tvShows, List<TvShowEpisode> episodes, TvShowSearchAndScrapeOptions scrapeOptions, List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig, List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig) {
        super(BUNDLE.getString("task.missingartwork"));
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        this.scrapeOptions = scrapeOptions;
        this.tvShowScraperMetadataConfig = tvShowScraperMetadataConfig;
        this.episodeScraperMetadataConfig = episodeScraperMetadataConfig;
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                if (this.episodes.contains(episode)) continue;
                this.episodes.add(episode);
            }
        }
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing artwork");
        this.initThreadPool(3, "scrapeMissingMovieArtwork");
        this.start();
        for (TvShow show : this.tvShows) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(show, this.tvShowScraperMetadataConfig)) continue;
            this.submitTask(new TvShowWorker(show, this.scrapeOptions));
        }
        for (TvShowEpisode episode : this.episodes) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(episode, this.episodeScraperMetadataConfig)) continue;
            this.submitTask(new TvShowEpisodeWorker(episode, this.scrapeOptions));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private static class TvShowEpisodeWorker
    implements Runnable {
        private TvShowList tvShowList = TvShowList.getInstance();
        private TvShowEpisode episode;
        private MediaSearchAndScrapeOptions scrapeOptions;

        private TvShowEpisodeWorker(TvShowEpisode episode, MediaSearchAndScrapeOptions scrapeOptions) {
            this.episode = episode;
            this.scrapeOptions = scrapeOptions;
        }

        @Override
        public void run() {
            try {
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_EPISODE);
                options.setDataFromOtherOptions(this.scrapeOptions);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage());
                for (Map.Entry<String, Object> entry : this.episode.getTvShow().getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                if (this.episode.isDvdOrder()) {
                    options.setId("dvdSeasonNr", String.valueOf(this.episode.getDvdSeason()));
                    options.setId("dvdEpisodeNr", String.valueOf(this.episode.getDvdEpisode()));
                } else {
                    options.setId("seasonNr", String.valueOf(this.episode.getAiredSeason()));
                    options.setId("episodeNr", String.valueOf(this.episode.getAiredEpisode()));
                }
                options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
                for (MediaScraper artworkScraper : this.scrapeOptions.getArtworkScrapers()) {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(options));
                        if (artwork.isEmpty()) continue;
                        break;
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.episode, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                }
                if (!artwork.isEmpty()) {
                    this.episode.setArtworkUrl(((MediaArtwork)artwork.get(0)).getDefaultUrl(), MediaFileType.THUMB);
                    this.episode.downloadArtwork(MediaFileType.THUMB);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    private static class TvShowWorker
    implements Runnable {
        private TvShowList tvShowList = TvShowList.getInstance();
        private TvShow tvShow;
        private MediaSearchAndScrapeOptions scrapeOptions;

        private TvShowWorker(TvShow tvShow, MediaSearchAndScrapeOptions scrapeOptions) {
            this.tvShow = tvShow;
            this.scrapeOptions = scrapeOptions;
        }

        @Override
        public void run() {
            try {
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
                options.setDataFromOtherOptions(this.scrapeOptions);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage());
                for (Map.Entry<String, Object> entry : this.tvShow.getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                for (MediaScraper artworkScraper : this.scrapeOptions.getArtworkScrapers()) {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(options));
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                }
                if (!artwork.isEmpty()) {
                    TvShowArtworkHelper.downloadMissingArtwork(this.tvShow, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

