/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowReloadMediaInformationTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowReloadMediaInformationTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<TvShow> tvShows;
    private List<TvShowEpisode> episodes;

    public TvShowReloadMediaInformationTask(List<TvShow> tvShows, List<TvShowEpisode> episodes) {
        super(BUNDLE.getString("tvshow.updatemediainfo"));
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                if (this.episodes.contains(episode)) continue;
                this.episodes.add(episode);
            }
        }
    }

    @Override
    protected void doInBackground() {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            LOGGER.info("get MediaInfo...");
            this.start();
            this.initThreadPool(1, "reloadMI");
            for (TvShow show : this.tvShows) {
                if (this.cancel) break;
                for (MediaFile mf : show.getMediaFiles()) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, show, true));
                }
            }
            for (TvShowEpisode episode : this.episodes) {
                if (this.cancel) break;
                for (MediaFile mf : episode.getMediaFiles()) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, episode, true));
                }
            }
            this.waitForCompletionOrCancel();
            stopWatch.stop();
            LOGGER.info("Done getting MediaInfo - took " + stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MediaInfo", "message.mediainfo.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }
}

