/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YTDownloadTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;

public class TvShowTrailerDownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowTrailerDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private final TvShow tvShow;
    private final List<TvShowTrailerNaming> trailernames = new ArrayList<TvShowTrailerNaming>();
    private final TrailerQuality desiredQuality;
    private final TrailerSources desiredSource;

    public TvShowTrailerDownloadTask(TvShow tvShow) {
        super(BUNDLE.getString("trailer.download") + " - " + tvShow.getTitle(), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.tvShow = tvShow;
        this.trailernames.addAll(TvShowModuleManager.SETTINGS.getTrailerFilenames());
        this.desiredSource = TvShowModuleManager.SETTINGS.getTrailerSource();
        this.desiredQuality = TvShowModuleManager.SETTINGS.getTrailerQuality();
    }

    @Override
    protected void doInBackground() {
        LinkedHashSet<MediaTrailer> trailers = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : this.tvShow.getTrailer()) {
            if (!this.desiredQuality.containsQuality(trailer.getQuality()) || !this.desiredSource.containsSource(trailer.getProvider())) continue;
            trailers.add(trailer);
        }
        for (MediaTrailer trailer : this.tvShow.getTrailer()) {
            if (!this.desiredQuality.containsQuality(trailer.getQuality())) continue;
            trailers.add(trailer);
        }
        trailers.addAll(this.tvShow.getTrailer());
        if (trailers.isEmpty()) {
            LOGGER.warn("no trailers for '{}' available", (Object)this.tvShow.getTitle());
            return;
        }
        LOGGER.info("downloading trailer for '{}'", (Object)this.tvShow.getTitle());
        for (MediaTrailer trailer : trailers) {
            String url = trailer.getUrl();
            if (!url.startsWith("http")) continue;
            try {
                LOGGER.debug("try to download trailer '{}'", (Object)url);
                Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(url);
                TmmTask task = matcher.matches() ? new YTDownloadTask(trailer, this.desiredQuality){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return TvShowTrailerDownloadTask.this.getDestination();
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return TvShowTrailerDownloadTask.this.tvShow;
                    }
                } : new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return TvShowTrailerDownloadTask.this.getDestination();
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return TvShowTrailerDownloadTask.this.tvShow;
                    }
                };
                task.addListener(taskEvent -> {
                    this.setProgressDone(taskEvent.getProgressDone());
                    this.setTaskDescription(taskEvent.getTaskDescription());
                    this.setWorkUnits(taskEvent.getWorkUnits());
                    this.informListeners();
                });
                task.run();
                if (task.getState() != TmmTaskHandle.TaskState.FINISHED && task.getState() != TmmTaskHandle.TaskState.CANCELLED) continue;
                break;
            }
            catch (Exception e) {
                LOGGER.debug("could download trailer - {}", (Object)e.getMessage());
            }
        }
    }

    protected Path getDestination() {
        String filename = !this.trailernames.isEmpty() ? this.tvShow.getTrailerFilename(this.trailernames.get(0)) : this.tvShow.getTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        return this.tvShow.getPathNIO().resolve(filename);
    }
}

