/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.config;

import java.util.ArrayList;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaProviderConfigObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviderConfigObject.class);
    String key = "";
    String keyDescription = "";
    String value = "";
    String defaultValue = "";
    boolean returnListAsInt = false;
    boolean encrypt = false;
    boolean visible = true;
    ConfigType type = ConfigType.TEXT;
    ArrayList<String> possibleValues = new ArrayList();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyDescription() {
        return this.keyDescription.isEmpty() ? this.key : this.keyDescription;
    }

    public void setKeyDescription(String keyDescription) {
        this.keyDescription = keyDescription;
    }

    public boolean isEmpty() {
        return this.key.isEmpty();
    }

    public String getValue() {
        String ret = "";
        switch (this.type) {
            case SELECT: {
                ret = this.getValueAsString();
                break;
            }
            case SELECT_INDEX: {
                Integer i = this.getValueIndex();
                ret = i == null || i < 0 ? "" : String.valueOf(i);
                break;
            }
            case BOOL: {
                return String.valueOf(this.getValueAsBool());
            }
            case INTEGER: {
                return String.valueOf(this.getValueAsInteger());
            }
            default: {
                return this.value;
            }
        }
        return ret;
    }

    public String getValueAsString() {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(this.value)) {
            LOGGER.warn("Could not get value for key '{}' - not in range; returning default {}", (Object)this.key, (Object)this.defaultValue);
            return this.defaultValue;
        }
        return this.value;
    }

    public Boolean getValueAsBool() {
        Boolean bool = null;
        if (this.type != ConfigType.BOOL) {
            LOGGER.warn("This is not a boolean '{}={}' - returning NULL ", (Object)this.key, (Object)this.value);
            return null;
        }
        if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false")) {
            bool = Boolean.valueOf(this.value);
        } else {
            LOGGER.warn("This is not a Boolean '{}={}' - returning default {}", new Object[]{this.key, this.value, this.defaultValue});
            bool = Boolean.valueOf(this.defaultValue);
        }
        return bool;
    }

    public Integer getValueAsInteger() {
        Integer integer = null;
        if (this.type != ConfigType.INTEGER) {
            LOGGER.warn("This is not an Integer '{}={}' - returning NULL ", (Object)this.key, (Object)this.value);
            return null;
        }
        try {
            integer = Integer.parseInt(this.value);
        }
        catch (Exception e) {
            LOGGER.warn("This is not an Integer '{}={}' - returning default {}", new Object[]{this.key, this.value, this.defaultValue});
            try {
                integer = Integer.parseInt(this.defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return integer;
    }

    public Integer getValueIndex() {
        Integer ret = null;
        if (this.type != ConfigType.SELECT && this.type != ConfigType.SELECT_INDEX) {
            LOGGER.warn("This is not a selectbox '{}={} - returning NULL ", (Object)this.key, (Object)this.value);
            return null;
        }
        ret = this.possibleValues.indexOf(this.value);
        if (ret == -1) {
            ret = this.possibleValues.indexOf(this.defaultValue);
            if (ret == -1) {
                ret = null;
            }
            LOGGER.warn("Could not get index for '{}={}' - not in defined range! returning default {}", new Object[]{this.key, this.value, ret});
        }
        return ret;
    }

    public void setValue(String value) {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(value)) {
            LOGGER.warn("Could not set '{}={}' - not in defined range!", (Object)this.key, (Object)value);
            return;
        }
        this.value = value;
    }

    public void setValue(boolean value) {
        if (this.type != ConfigType.BOOL) {
            LOGGER.warn("This is not a boolean configuration object - setting keep current value");
        } else {
            this.value = String.valueOf(value);
        }
    }

    public void setValue(Integer value) {
        if (this.type != ConfigType.INTEGER) {
            LOGGER.warn("This is not an Integer configuration object - setting keep current value");
        } else {
            this.value = String.valueOf(value);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(defaultValue)) {
            LOGGER.warn("Will not set defaultValue '{}={}' - since it is not in the list of possible values!", (Object)this.key, (Object)defaultValue);
        } else {
            this.defaultValue = defaultValue;
        }
    }

    public boolean isReturnListAsInt() {
        return this.returnListAsInt;
    }

    public void setReturnListAsInt(boolean returnListAsInt) {
        this.returnListAsInt = returnListAsInt;
    }

    public ArrayList<String> getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(ArrayList<String> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public void addPossibleValues(String possibleValue) {
        this.possibleValues.add(possibleValue);
    }

    public ConfigType getType() {
        return this.type;
    }

    public void setType(ConfigType type) {
        this.type = type;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static enum ConfigType {
        TEXT,
        BOOL,
        SELECT,
        SELECT_INDEX,
        INTEGER;

    }
}

