/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbTvShowParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbTvShowParser.class);
    private static final Pattern UNWANTED_SEARCH_RESULTS = Pattern.compile(".*\\((TV Movies|TV Episode|Short|Video Game)\\).*");

    ImdbTvShowParser() {
        super(MediaType.TV_SHOW);
    }

    @Override
    protected Pattern getUnwantedSearchResultPattern() {
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("filterUnwantedCategories").booleanValue()) {
            return UNWANTED_SEARCH_RESULTS;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected CountryCode getCountry() {
        return TvShowModuleManager.SETTINGS.getCertificationCountry();
    }

    @Override
    protected MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        switch (options.getMediaType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata((TvShowSearchAndScrapeOptions)options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata((TvShowEpisodeSearchAndScrapeOptions)options);
            }
        }
        return new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
    }

    @Override
    protected String getSearchCategory() {
        return "&s=tt&ttype=ft,tv";
    }

    MediaMetadata getTvShowMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForTvShows()) {
            ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
            TmdbTvShowWorker worker2 = new TmdbTvShowWorker(options);
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        ExecutorCompletionService<Document> compSvcImdb = new ExecutorCompletionService<Document>(ImdbMetadataProvider.executor);
        String url = "http://www.imdb.com/title/" + imdbId + "/reference";
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
        Future<Document> futureReference = compSvcImdb.submit(worker);
        url = "http://www.imdb.com/title/" + imdbId + "/plotsummary";
        worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
        Future<Document> futurePlotsummary = compSvcImdb.submit(worker);
        url = "http://www.imdb.com/title/" + imdbId + "/releaseinfo";
        worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
        Future<Document> futureKeywords = null;
        if (this.isScrapeKeywordsPage()) {
            url = "http://www.imdb.com/title/" + imdbId + "/keywords";
            worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
            futureKeywords = compSvcImdb.submit(worker);
        }
        try {
            Document doc = futureReference.get();
            this.parseReferencePage(doc, options, md);
            doc = futurePlotsummary.get();
            this.parsePlotsummaryPage(doc, options, md);
            if (md.getReleaseDate() == null || ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("localReleaseDate").booleanValue()) {
                this.parseReleaseinfoPage(compSvcImdb.submit(worker).get(), options, md);
            }
            if (futureKeywords != null) {
                doc = futureKeywords.get();
                this.parseKeywordsPage(doc, options, md);
            }
            md.setId(ImdbMetadataProvider.providerInfo.getId(), imdbId);
        }
        catch (Exception e) {
            LOGGER.error("problem while scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (md.getIds().isEmpty()) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), imdbId);
        if (futureTmdb != null) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry<String, Object> entry : tmdbMd.getIds().entrySet()) {
                        md.setId(entry.getKey(), entry.getValue());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                        md.setTitle(tmdbMd.getTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                        md.setOriginalTitle(tmdbMd.getOriginalTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                        md.setTagline(tmdbMd.getTagline());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                        md.setPlot(tmdbMd.getPlot());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not fetch data from TMDB: {}", (Object)e.getMessage());
            }
        }
        return md;
    }

    MediaMetadata getEpisodeMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        String episodeId;
        LOGGER.debug("getEpisodeMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            throw new MissingIdException("episodeNr", "seasonNr");
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options);
        MediaMetadata wantedEpisode = null;
        for (MediaMetadata episode : episodes) {
            if (episode.getSeasonNumber() != seasonNr || episode.getEpisodeNumber() != episodeNr) continue;
            wantedEpisode = episode;
            break;
        }
        if (wantedEpisode == null) {
            LOGGER.warn("episode not found");
            throw new NothingFoundException();
        }
        ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForTvShows()) {
            TmdbTvShowEpisodeWorker worker2 = new TmdbTvShowEpisodeWorker(options);
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId()));
        md.setEpisodeNumber(wantedEpisode.getEpisodeNumber());
        md.setSeasonNumber(wantedEpisode.getSeasonNumber());
        md.setTitle(wantedEpisode.getTitle());
        md.setPlot(wantedEpisode.getPlot());
        md.setRatings(wantedEpisode.getRatings());
        md.setReleaseDate(wantedEpisode.getReleaseDate());
        if (wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId()) instanceof String && MetadataUtil.isValidImdbId(episodeId = (String)wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId()))) {
            ExecutorCompletionService compSvcImdb = new ExecutorCompletionService(ImdbMetadataProvider.executor);
            String string = "http://www.imdb.com/title/" + episodeId + "/reference";
            ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this, string, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
            Future<Document> futureReference = compSvcImdb.submit(worker);
            Future<Document> futureKeywords = null;
            if (this.isScrapeKeywordsPage()) {
                String string2 = "http://www.imdb.com/title/" + episodeId + "/keywords";
                worker = new ImdbParser.ImdbWorker(this, string2, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
                futureKeywords = compSvcImdb.submit(worker);
            }
            try {
                Element writersElement;
                Element castTableElement;
                Element directorsElement;
                Document doc = futureReference.get();
                for (directorsElement = doc.getElementById("directors"); directorsElement != null && !"header".equals(directorsElement.tag().getName()); directorsElement = directorsElement.parent()) {
                }
                if (directorsElement != null) {
                    directorsElement = directorsElement.nextElementSibling();
                }
                if (directorsElement != null) {
                    for (Element directorElement : directorsElement.getElementsByClass("name")) {
                        Matcher matcher;
                        String director = directorElement.text().trim();
                        Person cm = new Person(Person.Type.DIRECTOR, director);
                        Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                        if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                            if (matcher.group(0) != null) {
                                cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                            }
                            if (matcher.group(1) != null) {
                                cm.setId(ImdbMetadataProvider.providerInfo.getId(), matcher.group(1));
                            }
                        }
                        md.addCastMember(cm);
                    }
                }
                if ((castTableElement = doc.getElementsByClass("cast_list").first()) != null) {
                    Elements tr = castTableElement.getElementsByTag("tr");
                    for (Element row : tr) {
                        Person cm = this.parseCastMember(row);
                        if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName()) || !StringUtils.isNotEmpty((CharSequence)cm.getRole())) continue;
                        cm.setType(Person.Type.ACTOR);
                        md.addCastMember(cm);
                    }
                }
                for (writersElement = doc.getElementById("writers"); writersElement != null && !"header".equals(writersElement.tag().getName()); writersElement = writersElement.parent()) {
                }
                if (writersElement != null) {
                    writersElement = writersElement.nextElementSibling();
                }
                if (writersElement != null) {
                    Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
                    for (Element writerElement : writersElements) {
                        Matcher matcher;
                        String writer = ImdbMetadataProvider.cleanString(writerElement.ownText());
                        Person cm = new Person(Person.Type.WRITER, writer);
                        Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                        if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                            if (matcher.group(0) != null) {
                                cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                            }
                            if (matcher.group(1) != null) {
                                cm.setId(ImdbMetadataProvider.providerInfo.getId(), matcher.group(1));
                            }
                        }
                        md.addCastMember(cm);
                    }
                }
                if (futureKeywords != null) {
                    this.parseKeywordsPage(futureKeywords.get(), options, md);
                }
            }
            catch (Exception e) {
                LOGGER.trace("problem parsing: {}", (Object)e.getMessage());
            }
        }
        if (futureTmdb != null) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry entry : tmdbMd.getIds().entrySet()) {
                        md.setId((String)entry.getKey(), entry.getValue());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                        md.setTitle(tmdbMd.getTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                        md.setOriginalTitle(tmdbMd.getOriginalTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                        md.setTagline(tmdbMd.getTagline());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                        md.setPlot(tmdbMd.getPlot());
                    }
                    if (md.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).isEmpty() && !tmdbMd.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).isEmpty()) {
                        MediaArtwork thumb = tmdbMd.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).get(0);
                        md.addMediaArt(thumb);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("could not get cast page: {}", (Object)e.getMessage());
            }
        }
        return md;
    }

    List<MediaMetadata> getEpisodeList(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        Document doc;
        InMemoryCachedUrl url;
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String imdbId = options.getImdbId();
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            throw new MissingIdException(new String[]{"imdb"});
        }
        try {
            url = new InMemoryCachedUrl("http://www.imdb.com//title/" + imdbId + "/episodes?season=1");
            url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), this.getCountry().getAlpha2()));
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        ArrayList<String> availableSeasons = new ArrayList<String>();
        try (InputStream is = ((Url)url).getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            this.parseEpisodeList(1, episodes, doc);
            Element select = doc.getElementById("bySeason");
            if (select != null) {
                for (Element option : select.getElementsByTag("option")) {
                    String value = option.attr("value");
                    if (!StringUtils.isNotBlank((CharSequence)value) || "1".equals(value)) continue;
                    availableSeasons.add(value);
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (String seasonAsString : availableSeasons) {
            InMemoryCachedUrl seasonUrl;
            int season;
            try {
                season = Integer.parseInt(seasonAsString);
            }
            catch (Exception e) {
                LOGGER.debug("could not parse season number - {}", (Object)e.getMessage());
                continue;
            }
            try {
                seasonUrl = new InMemoryCachedUrl("http://www.imdb.com//title/" + imdbId + "/epdate?season=" + season);
                seasonUrl.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), this.getCountry().getAlpha2()));
            }
            catch (Exception e) {
                LOGGER.error("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            try {
                InputStream is = ((Url)seasonUrl).getInputStream();
                try {
                    doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                    if (this.parseEpisodeList(season, episodes, doc)) continue;
                    break;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("problem parsing ep list: {}", (Object)e.getMessage());
            }
        }
        return episodes;
    }

    private boolean parseEpisodeList(int season, List<MediaMetadata> episodes, Document doc) {
        Pattern unknownPattern = Pattern.compile("Unknown");
        Pattern seasonEpisodePattern = Pattern.compile("S([0-9]*), Ep([0-9]*)");
        int episodeCounter = 0;
        Elements tables = doc.getElementsByClass("eplist");
        if (tables.isEmpty()) {
            return false;
        }
        for (Element table : tables) {
            Elements rows = table.getElementsByClass("list_item");
            for (Element row : rows) {
                Matcher matcher = season == 0 ? unknownPattern.matcher(row.text()) : seasonEpisodePattern.matcher(row.text());
                if (!matcher.find() || season != 0 && matcher.groupCount() < 2) continue;
                try {
                    Element image;
                    Element releaseDate;
                    Element ratingElement;
                    Element plot;
                    MediaMetadata ep = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
                    if (season == 0) {
                        ep.setSeasonNumber(season);
                        ep.setEpisodeNumber(++episodeCounter);
                    } else {
                        ep.setSeasonNumber(Integer.parseInt(matcher.group(1)));
                        ep.setEpisodeNumber(Integer.parseInt(matcher.group(2)));
                    }
                    if (season > 0 && season != ep.getSeasonNumber()) {
                        return false;
                    }
                    Elements anchors = row.getElementsByAttributeValueStarting("href", "/title/tt");
                    for (Element anchor : anchors) {
                        if (!"name".equals(anchor.attr("itemprop"))) continue;
                        ep.setTitle(anchor.text());
                        break;
                    }
                    String id = "";
                    Matcher idMatcher = IMDB_ID_PATTERN.matcher(((Element)anchors.get(0)).attr("href"));
                    while (idMatcher.find()) {
                        if (idMatcher.group(1) == null) continue;
                        id = idMatcher.group(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        ep.setId(ImdbMetadataProvider.providerInfo.getId(), id);
                    }
                    if ((plot = row.getElementsByClass("item_description").first()) != null) {
                        ep.setPlot(plot.ownText());
                    }
                    if ((ratingElement = row.getElementsByClass("ipl-rating-star__rating").first()) != null) {
                        String ratingAsString = ratingElement.ownText().replace(",", ".");
                        Element votesElement = row.getElementsByClass("ipl-rating-star__total-votes").first();
                        if (votesElement != null) {
                            String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                            try {
                                MediaRating rating = new MediaRating(ImdbMetadataProvider.providerInfo.getId());
                                rating.setRating(Float.parseFloat(ratingAsString));
                                rating.setVotes(MetadataUtil.parseInt(countAsString));
                                ep.addRating(rating);
                            }
                            catch (Exception e) {
                                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                            }
                        }
                    }
                    if ((releaseDate = row.getElementsByClass("airdate").first()) != null) {
                        ep.setReleaseDate(this.parseDate(releaseDate.ownText()));
                    }
                    if ((image = row.getElementsByTag("img").first()) != null) {
                        String posterUrl = image.attr("src");
                        posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                        posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                        if (StringUtils.isNotBlank((CharSequence)(posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "")))) {
                            MediaArtwork ma = new MediaArtwork(ImdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
                            ma.setPreviewUrl(posterUrl);
                            ma.setDefaultUrl(posterUrl);
                            ep.addMediaArt(ma);
                        }
                    }
                    episodes.add(ep);
                }
                catch (Exception e) {
                    LOGGER.warn("failed parsing: {} for ep data - {}", (Object)row.text(), (Object)e.getMessage());
                }
            }
        }
        return true;
    }

    private static class TmdbTvShowEpisodeWorker
    implements Callable<MediaMetadata> {
        private TvShowEpisodeSearchAndScrapeOptions options;

        TmdbTvShowEpisodeWorker(TvShowEpisodeSearchAndScrapeOptions options) {
            this.options = options;
        }

        @Override
        public MediaMetadata call() {
            try {
                IMediaProvider tmdb = MediaProviders.getProviderById("tmdb");
                if (tmdb == null) {
                    return null;
                }
                TvShowEpisodeSearchAndScrapeOptions scrapeOptions = new TvShowEpisodeSearchAndScrapeOptions(this.options);
                scrapeOptions.setMetadataScraper(new MediaScraper(ScraperType.TV_SHOW, tmdb));
                return ((ITvShowMetadataProvider)tmdb).getMetadata(scrapeOptions);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class TmdbTvShowWorker
    implements Callable<MediaMetadata> {
        private TvShowSearchAndScrapeOptions options;

        TmdbTvShowWorker(TvShowSearchAndScrapeOptions options) {
            this.options = options;
        }

        @Override
        public MediaMetadata call() {
            try {
                IMediaProvider tmdb = MediaProviders.getProviderById("tmdb");
                if (tmdb == null) {
                    return null;
                }
                TvShowSearchAndScrapeOptions scrapeOptions = new TvShowSearchAndScrapeOptions(this.options);
                scrapeOptions.setMetadataScraper(new MediaScraper(ScraperType.TV_SHOW, tmdb));
                return ((ITvShowMetadataProvider)tmdb).getMetadata(scrapeOptions);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

