/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.entities.Actor;
import org.tinymediamanager.scraper.mpdbtv.entities.Director;
import org.tinymediamanager.scraper.mpdbtv.entities.DiscArt;
import org.tinymediamanager.scraper.mpdbtv.entities.Fanart;
import org.tinymediamanager.scraper.mpdbtv.entities.Genre;
import org.tinymediamanager.scraper.mpdbtv.entities.HDClearArt;
import org.tinymediamanager.scraper.mpdbtv.entities.HDLogo;
import org.tinymediamanager.scraper.mpdbtv.entities.MovieEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Poster;
import org.tinymediamanager.scraper.mpdbtv.entities.Producer;
import org.tinymediamanager.scraper.mpdbtv.entities.Release;
import org.tinymediamanager.scraper.mpdbtv.entities.SearchEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Studio;
import org.tinymediamanager.scraper.mpdbtv.entities.Trailer;
import org.tinymediamanager.scraper.mpdbtv.services.Controller;
import org.tinymediamanager.scraper.util.ApiKey;

public class MpdbMetadataProvider
implements IMovieMetadataProvider {
    public static final String ID = "mpdbtv";
    private static final Logger LOGGER = LoggerFactory.getLogger(MpdbMetadataProvider.class);
    private static final MediaProviderInfo providerInfo = MpdbMetadataProvider.createMediaProviderInfo();
    private static final String API_KEY = ApiKey.decryptApikey("DdSGUTZn24ml7rZRBihKb9ea3svKUDnU3GZdhgf+XMrfE8IdLinpy6eAPLrmkZWu");
    private static final String FORMAT = "json";
    private Controller controller = new Controller(false);

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo(ID, "mpdb.tv", "<html><h3>MPDb.TV</h3><br />MPDb.TV is a private meta data provider for French speaking users - you may need to become a member there to use this service (more infos at http://www.mpdb.tv/)<br /><br />Available languages: FR</html>", MpdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/mpdbtv.png"));
        providerInfo.getConfig().addText("aboKey", "", false);
        providerInfo.getConfig().addText("username", "", false);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        List<SearchEntity> searchResult;
        LOGGER.debug("search(): {}", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            LOGGER.warn("no username/ABO Key found");
            throw new ScrapeException(new HttpException(401, "Unauthorized"));
        }
        if (!options.getLanguage().getLanguage().toUpperCase().equals("FR")) {
            LOGGER.info("Scraper only supports Language FR");
            return results;
        }
        LOGGER.info("========= BEGIN MPDB.tv Scraper Search for Movie: {} ", (Object)options.getSearchQuery());
        try {
            searchResult = this.controller.getSearchInformation(API_KEY, this.getEncodedUserName(), this.getSubscriptionKey(), options.getSearchQuery(), options.getLanguage().toLocale(), true, FORMAT);
        }
        catch (IOException e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResult == null) {
            LOGGER.warn("no result from MPDB.tv");
            return results;
        }
        for (SearchEntity entity : searchResult) {
            MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.MOVIE);
            result.setId(providerInfo.getId(), entity.id);
            result.setOriginalTitle(StringEscapeUtils.unescapeHtml4((String)entity.original_title));
            if (StringUtils.isEmpty((CharSequence)entity.title)) {
                result.setTitle(StringEscapeUtils.unescapeHtml4((String)entity.original_title));
            } else {
                result.setTitle(StringEscapeUtils.unescapeHtml4((String)entity.title));
            }
            result.setYear(entity.year);
            result.setId("imdb_id", entity.id_imdb);
            result.setId("allocine_id", entity.id_allocine);
            result.setUrl(entity.url);
            result.setPosterUrl(entity.posterUrl);
            result.calculateScore(options);
            results.add(result);
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions mediaScrapeOptions) throws ScrapeException {
        MediaArtwork mediaArtwork;
        Person mediaCastMember;
        MovieEntity scrapeResult;
        LOGGER.debug("getMetadata(): {}", (Object)mediaScrapeOptions);
        MediaMetadata metadata = new MediaMetadata(providerInfo.getId());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            LOGGER.warn("no username/ABO Key found");
            throw new ScrapeException(new HttpException(401, "Unauthorized"));
        }
        LOGGER.info("========= BEGIN MPDB.tv scraping");
        try {
            scrapeResult = this.controller.getScrapeInformation(API_KEY, this.getEncodedUserName(), this.getSubscriptionKey(), Integer.parseInt(mediaScrapeOptions.getIdAsString(providerInfo.getId())), mediaScrapeOptions.getLanguage().toLocale(), null, FORMAT);
        }
        catch (IOException e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (scrapeResult == null) {
            LOGGER.warn("no result from MPDB.tv");
            return metadata;
        }
        if (scrapeResult.rating != null) {
            MediaRating rating = new MediaRating("mpdb.tv");
            rating.setRating(scrapeResult.rating.floatValue());
            rating.setVotes(scrapeResult.ratingVotes);
            rating.setMaxValue(10);
            metadata.addRating(rating);
        }
        ArrayList<MediaGenres> mediaGenres = new ArrayList<MediaGenres>();
        for (Genre genre : scrapeResult.genres) {
            mediaGenres.add(MediaGenres.getGenre(genre.name));
        }
        metadata.setGenres(mediaGenres);
        ArrayList<MediaTrailer> mediaTrailers = new ArrayList<MediaTrailer>();
        for (Trailer trailer : scrapeResult.trailers) {
            MediaTrailer mt = new MediaTrailer();
            mt.setName(scrapeResult.title);
            mt.setUrl(trailer.url);
            mt.setQuality(trailer.quality);
            mediaTrailers.add(mt);
        }
        metadata.setTrailers(mediaTrailers);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Studio studio : scrapeResult.studios) {
            arrayList.add(studio.name);
        }
        metadata.setProductionCompanies(arrayList);
        ArrayList<Person> arrayList2 = new ArrayList<Person>();
        for (Director director : scrapeResult.directors) {
            mediaCastMember = new Person(Person.Type.DIRECTOR);
            mediaCastMember.setId(providerInfo.getId(), director.id);
            mediaCastMember.setName(director.name);
            mediaCastMember.setRole(director.departement);
            mediaCastMember.setThumbUrl(director.thumb);
            mediaCastMember.setId(providerInfo.getId(), director.id);
            arrayList2.add(mediaCastMember);
        }
        for (Actor actor : scrapeResult.actors) {
            mediaCastMember = new Person(Person.Type.ACTOR);
            mediaCastMember.setId(providerInfo.getId(), actor.id);
            mediaCastMember.setName(actor.name);
            mediaCastMember.setRole(actor.role);
            mediaCastMember.setThumbUrl(actor.thumb);
            arrayList2.add(mediaCastMember);
        }
        for (Producer producer : scrapeResult.producers) {
            mediaCastMember = new Person(Person.Type.PRODUCER);
            mediaCastMember.setId(providerInfo.getId(), producer.id);
            mediaCastMember.setName(producer.name);
            mediaCastMember.setRole(producer.departement);
            mediaCastMember.setThumbUrl(producer.thumb);
            arrayList2.add(mediaCastMember);
        }
        metadata.setCastMembers(arrayList2);
        for (Poster poster : scrapeResult.posters) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            mediaArtwork.setPreviewUrl(poster.preview);
            mediaArtwork.setDefaultUrl(poster.original);
            mediaArtwork.setLikes(poster.votes);
            metadata.addMediaArt(mediaArtwork);
        }
        for (Fanart fanart : scrapeResult.fanarts) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            mediaArtwork.setPreviewUrl(fanart.preview);
            mediaArtwork.setDefaultUrl(fanart.original);
            mediaArtwork.setLikes(fanart.votes);
            metadata.addMediaArt(mediaArtwork);
        }
        for (DiscArt discArt : scrapeResult.discarts) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.DISC);
            mediaArtwork.setPreviewUrl(discArt.preview);
            mediaArtwork.setDefaultUrl(discArt.original);
            mediaArtwork.setLikes(discArt.votes);
            metadata.addMediaArt(mediaArtwork);
        }
        for (HDClearArt hdClearArt : scrapeResult.hdcleararts) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARART);
            mediaArtwork.setPreviewUrl(hdClearArt.preview);
            mediaArtwork.setDefaultUrl(hdClearArt.original);
            mediaArtwork.setLikes(hdClearArt.votes);
            metadata.addMediaArt(mediaArtwork);
        }
        for (HDLogo hdLogo : scrapeResult.hdlogos) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARLOGO);
            mediaArtwork.setPreviewUrl(hdLogo.preview);
            mediaArtwork.setDefaultUrl(hdLogo.original);
            mediaArtwork.setLikes(hdLogo.votes);
        }
        for (Release release : scrapeResult.releases) {
            if (!release.countryId.equals(mediaScrapeOptions.getLanguage().getLanguage().toUpperCase())) continue;
            metadata.setYear(release.year);
        }
        metadata.setId("allocine", scrapeResult.idAllocine);
        metadata.setId("imdb", scrapeResult.idImdb);
        metadata.setId("tmdb", scrapeResult.idTmdb);
        metadata.setTagline(scrapeResult.tagline);
        metadata.setReleaseDate(new Date(scrapeResult.firstRelease.intValue()));
        metadata.setTitle(scrapeResult.title);
        metadata.setOriginalTitle(scrapeResult.originalTitle);
        metadata.setRuntime(scrapeResult.runtime);
        metadata.setPlot(scrapeResult.plot);
        return metadata;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    private String getAboKey() {
        return providerInfo.getConfig().getValue("aboKey");
    }

    private String getUserName() {
        return providerInfo.getConfig().getValue("username");
    }

    private String getEncodedUserName() {
        return Base64.getUrlEncoder().encodeToString(this.getUserName().getBytes());
    }

    private String getSubscriptionKey() {
        return DigestUtils.sha1Hex((String)(this.getUserName() + API_KEY + this.getAboKey()));
    }
}

