/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ofdb;

import java.io.InterruptedIOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class OfdbMetadataProvider
implements IMovieMetadataProvider,
IMovieTrailerProvider {
    public static final String ID = "ofdb";
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdbMetadataProvider.class);
    private static final String BASE_URL = "http://www.ofdb.de";
    private static MediaProviderInfo providerInfo = OfdbMetadataProvider.createMediaProviderInfo();

    private static MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, "Online Filmdatenbank (OFDb.de)", "<html><h3>Online Filmdatenbank (OFDb)</h3><br />A german movie database driven by the community.<br /><br />Available languages: DE</html>", OfdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/ofdb_de.png"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        String originalTitle;
        LOGGER.debug("getMetadata() {}", (Object)options);
        String detailUrl = "";
        String id = options.getIdAsString(this.getProviderInfo().getId());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            detailUrl = "http://www.ofdb.de/view.php?page=film&fid=" + id;
        }
        if (options.getSearchResult() == null && StringUtils.isNotBlank((CharSequence)options.getIdAsString("imdb"))) {
            try {
                SortedSet<MediaSearchResult> results = this.search(options);
                if (!results.isEmpty()) {
                    options.setSearchResult(results.first());
                    detailUrl = options.getSearchResult().getUrl();
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed IMDB search: {}", (Object)e.getMessage());
            }
        }
        if (options.getSearchResult() != null) {
            detailUrl = options.getSearchResult().getUrl();
        }
        if (StringUtils.isBlank((CharSequence)detailUrl)) {
            LOGGER.warn("We did not get any useful movie url");
            throw new MissingIdException("imdb", providerInfo.getId());
        }
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        Elements el = null;
        String ofdbId = StrgUtils.substr(detailUrl, "film\\/(\\d+),");
        if (StringUtils.isBlank((CharSequence)ofdbId)) {
            ofdbId = StrgUtils.substr(detailUrl, "fid=(\\d+)");
        }
        Document doc = null;
        LOGGER.trace("get details page: {}", (Object)detailUrl);
        try {
            doc = UrlUtil.parseDocumentFromUrl(detailUrl);
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("could not fetch detail url: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc.getAllElements().size() < 10) {
            throw new ScrapeException(new Exception("we did not receive a valid web page"));
        }
        el = doc.getElementsByAttributeValueContaining("href", "imdb.com");
        if (!el.isEmpty()) {
            md.setId("imdb", "tt" + StrgUtils.substr(el.first().attr("href"), "\\?(\\d+)"));
        }
        if (!(el = doc.getElementsByAttributeValue("property", "og:title")).isEmpty()) {
            String[] ty = this.parseTitle(el.first().attr("content"));
            md.setTitle(StrgUtils.removeCommonSortableName(ty[0]));
            try {
                md.setYear(Integer.parseInt(ty[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (md.getYear() == 0) {
            el = doc.getElementsByAttributeValueContaining("href", "Kat=Jahr");
            try {
                md.setYear(Integer.parseInt(el.first().text()));
            }
            catch (Exception ty) {
                // empty catch block
            }
        }
        if (!(originalTitle = StrgUtils.substr(doc.body().html(), "(?s)Originaltitel.*?<b>(.*?)</b>")).isEmpty()) {
            md.setOriginalTitle(StrgUtils.removeCommonSortableName(originalTitle));
        }
        el = doc.getElementsByAttributeValueContaining("href", "page=genre");
        for (Element g : el) {
            md.addGenre(this.getTmmGenre(g.text()));
        }
        try {
            String r;
            MediaRating rating = new MediaRating("odfb");
            el = doc.getElementsByAttributeValue("itemprop", "ratingValue");
            if (!el.isEmpty() && !(r = el.text()).isEmpty()) {
                rating.setRating(Float.parseFloat(r));
                rating.setMaxValue(10);
            }
            if (!(el = doc.getElementsByAttributeValue("itemprop", "ratingCount")).isEmpty() && !(r = el.text()).isEmpty()) {
                rating.setVotes(Integer.parseInt(r));
            }
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating: {}", (Object)e.getMessage());
        }
        LOGGER.trace("parse plot");
        el = doc.getElementsByAttributeValueMatching("href", "plot\\/\\d+,");
        if (!el.isEmpty()) {
            String plotUrl = "http://www.ofdb.de/" + el.first().attr("href");
            try {
                Document plot = UrlUtil.parseDocumentFromUrl(plotUrl);
                Elements block = plot.getElementsByClass("Blocksatz");
                String p = block.first().text();
                p = p.substring(p.indexOf("Mal gelesen") + 12);
                md.setPlot(p);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("failed to get plot page: {}", (Object)e.getMessage());
            }
        }
        String movieDetail = "http://www.ofdb.de/view.php?page=film_detail&fid=" + ofdbId;
        LOGGER.trace("parse movie detail: {}", (Object)movieDetail);
        doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl(movieDetail);
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("failed to get detail page: {}", (Object)e.getMessage());
        }
        if (doc != null) {
            this.parseCast(doc.getElementsContainingOwnText("Regie"), Person.Type.DIRECTOR, md);
            this.parseCast(doc.getElementsContainingOwnText("Darsteller"), Person.Type.ACTOR, md);
            this.parseCast(doc.getElementsContainingOwnText("Stimme/Sprecher"), Person.Type.ACTOR, md);
            this.parseCast(doc.getElementsContainingOwnText("Synchronstimme (deutsch)"), Person.Type.ACTOR, md);
            this.parseCast(doc.getElementsContainingOwnText("Drehbuchautor(in)"), Person.Type.WRITER, md);
            this.parseCast(doc.getElementsContainingOwnText("Produzent(in)"), Person.Type.PRODUCER, md);
        }
        return md;
    }

    private void parseCast(Elements el, Person.Type type, MediaMetadata md) {
        if (el != null && !el.isEmpty()) {
            Element castEl = null;
            for (Element element : el) {
                if (element.tagName().equals("option")) continue;
                castEl = element;
            }
            if (castEl == null) {
                LOGGER.debug("meh, no {} found", (Object)type.name());
                return;
            }
            while (castEl != null && !castEl.tagName().equalsIgnoreCase("tr")) {
                castEl = castEl.parent();
            }
            Element tr = castEl.nextElementSibling();
            if (tr != null) {
                for (Element a : tr.getElementsByAttributeValue("valign", "middle")) {
                    String act = a.toString();
                    String aname = StrgUtils.substr(act, "alt=\"(.*?)\"");
                    if (aname.isEmpty()) continue;
                    Person cm = new Person(type);
                    cm.setName(aname);
                    String id = StrgUtils.substr(act, "id=(.*?)[^\"]\">");
                    if (!id.isEmpty()) {
                        cm.setId(providerInfo.getId(), id);
                        try {
                            String imgurl = URLDecoder.decode(StrgUtils.substr(act, "images%2Fperson%2F(.*?)&amp;size"), "UTF-8");
                            if (!imgurl.isEmpty()) {
                                imgurl = "http://www.ofdb.de/images/person/" + imgurl;
                            }
                            cm.setThumbUrl(imgurl);
                        }
                        catch (Exception e) {
                            LOGGER.trace("could not parse thumb url: {}", (Object)e.getMessage());
                        }
                        Element profileAnchor = a.getElementsByAttributeValueStarting("href", "view.php?page=person").first();
                        if (profileAnchor != null) {
                            cm.setProfileUrl("http://www.ofdb.de/" + profileAnchor.attr("href"));
                        }
                    }
                    String arole = StrgUtils.substr(act, "\\.\\.\\. (.*?)</font>").replaceAll("<[^>]*>", "");
                    cm.setRole(arole);
                    md.addCastMember(cm);
                }
            }
        }
    }

    private MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (genre.isEmpty()) {
            return g;
        }
        if (genre.equals("Abenteuer")) {
            g = MediaGenres.ADVENTURE;
        } else if (genre.equals("Action")) {
            g = MediaGenres.ACTION;
        } else if (genre.equals("Amateur")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Animation")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Anime")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Biographie")) {
            g = MediaGenres.BIOGRAPHY;
        } else if (genre.equals("Dokumentation")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Drama")) {
            g = MediaGenres.DRAMA;
        } else if (genre.equals("Eastern")) {
            g = MediaGenres.EASTERN;
        } else if (genre.equals("Erotik")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Essayfilm")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Experimentalfilm")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Fantasy")) {
            g = MediaGenres.FANTASY;
        } else if (genre.equals("Grusel")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Hardcore")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Heimatfilm")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("Historienfilm")) {
            g = MediaGenres.HISTORY;
        } else if (genre.equals("Horror")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Kampfsport")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Katastrophen")) {
            g = MediaGenres.DISASTER;
        } else if (genre.equals("Kinder-/Familienfilm")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Kom\u00f6die")) {
            g = MediaGenres.COMEDY;
        } else if (genre.equals("Krieg")) {
            g = MediaGenres.WAR;
        } else if (genre.equals("Krimi")) {
            g = MediaGenres.CRIME;
        } else if (genre.equals("Kurzfilm")) {
            g = MediaGenres.SHORT;
        } else if (genre.equals("Liebe/Romantik")) {
            g = MediaGenres.ROMANCE;
        } else if (genre.equals("Mondo")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Musikfilm")) {
            g = MediaGenres.MUSIC;
        } else if (genre.equals("Mystery")) {
            g = MediaGenres.MYSTERY;
        } else if (genre.equals("Science-Fiction")) {
            g = MediaGenres.SCIENCE_FICTION;
        } else if (genre.equals("Serial")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Sex")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Splatter")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Sportfilm")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Stummfilm")) {
            g = MediaGenres.SILENT_MOVIE;
        } else if (genre.equals("TV-Film")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("TV-Mini-Serie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("TV-Pilotfilm")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("TV-Serie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Thriller")) {
            g = MediaGenres.THRILLER;
        } else if (genre.equals("Tierfilm")) {
            g = MediaGenres.ANIMAL;
        } else if (genre.equals("Webserie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Western")) {
            g = MediaGenres.WESTERN;
        }
        if (g == null) {
            g = MediaGenres.getGenre(genre);
        }
        return g;
    }

    private String cleanSearch(String q) {
        q = " " + MetadataUtil.removeNonSearchCharacters(q) + " ";
        q = q.replaceAll("(?i)( a | the | der | die | das |\\(\\d+\\))", " ");
        q = q.replaceAll("[^A-Za-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc ]", " ");
        q = q.replace("  ", "");
        return q.trim();
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchQuery = options.getSearchQuery();
        String imdb = "";
        Elements filme = null;
        Exception savedException = null;
        if (StringUtils.isNotEmpty((CharSequence)options.getImdbId())) {
            try {
                imdb = options.getImdbId();
                LOGGER.debug("search with imdbId: {}", (Object)imdb);
                Document doc = UrlUtil.parseDocumentFromUrl("http://www.ofdb.de/view.php?page=suchergebnis&Kat=IMDb&SText=" + imdb);
                filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
                LOGGER.debug("found {} search results", (Object)filme.size());
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("failed to search for imdb Id {}: {}", (Object)imdb, (Object)e.getMessage());
                savedException = e;
            }
        }
        if ((filme == null || filme.isEmpty()) && StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
            try {
                String searchString = "http://www.ofdb.de/view.php?page=suchergebnis&Kat=All&SText=" + URLEncoder.encode(this.cleanSearch(searchQuery), "UTF-8");
                LOGGER.debug("search for everything: {}", (Object)searchQuery);
                Document doc = UrlUtil.parseDocumentFromUrl(searchString);
                filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
                LOGGER.debug("found {} search results", (Object)filme.size());
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("failed to search for: {} - {}", (Object)searchQuery, (Object)e.getMessage());
                savedException = e;
            }
        }
        if ((filme == null || filme.isEmpty()) && savedException != null) {
            throw new ScrapeException(savedException);
        }
        if (filme == null || filme.isEmpty()) {
            LOGGER.debug("nothing found :(");
            return results;
        }
        HashSet<String> foundResultUrls = new HashSet<String>();
        for (Element a : filme) {
            try {
                MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), MediaType.MOVIE);
                if (StringUtils.isNotEmpty((CharSequence)imdb)) {
                    sr.setIMDBId(imdb);
                }
                sr.setId(StrgUtils.substr(a.toString(), "film\\/(\\d+),"));
                sr.setTitle(StringEscapeUtils.unescapeHtml4((String)StrgUtils.removeCommonSortableName(StrgUtils.substr(a.toString(), ".*>(.*?)(\\[.*?\\])?<font"))));
                LOGGER.debug("found movie {}", (Object)sr.getTitle());
                sr.setOriginalTitle(StringEscapeUtils.unescapeHtml4((String)StrgUtils.removeCommonSortableName(StrgUtils.substr(a.toString(), ".*> / (.*?)</font"))));
                try {
                    sr.setYear(Integer.parseInt(StrgUtils.substr(a.toString(), "font> \\((.*?)\\)<\\/a")));
                }
                catch (Exception e) {
                    LOGGER.trace("could not parse year: {}", (Object)e.getMessage());
                }
                sr.setUrl("http://www.ofdb.de/" + StrgUtils.substr(a.toString(), "href=\\\"(.*?)\\\""));
                sr.setPosterUrl("http://www.ofdb.de/images" + StrgUtils.substr(a.toString(), "images(.*?)\\&quot"));
                if (StringUtils.isBlank((CharSequence)sr.getTitle()) || StringUtils.isBlank((CharSequence)sr.getUrl()) || foundResultUrls.contains(sr.getUrl())) continue;
                foundResultUrls.add(sr.getUrl());
                if (StringUtils.isNotBlank((CharSequence)sr.getIMDBId()) && imdb.equals(sr.getIMDBId())) {
                    sr.setScore(1.0f);
                } else {
                    sr.calculateScore(options);
                }
                results.add(sr);
            }
            catch (Exception e) {
                LOGGER.warn("error parsing movie result: {}", (Object)e.getMessage());
            }
        }
        return results;
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getTrailers(): {}", (Object)options);
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        if (!MetadataUtil.isValidImdbId(options.getImdbId())) {
            LOGGER.debug("IMDB id not found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        String searchString = "http://www.ofdb.de/view.php?page=suchergebnis&Kat=IMDb&SText=" + options.getImdbId();
        String url = "";
        try {
            url = searchString;
            Document doc = UrlUtil.parseDocumentFromUrl(searchString);
            Elements filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
            if (filme == null || filme.isEmpty()) {
                LOGGER.debug("found no search results");
                return trailers;
            }
            LOGGER.debug("found {} search results", (Object)filme.size());
            LOGGER.debug("get (trailer) details page");
            url = "http://www.ofdb.de/" + StrgUtils.substr(filme.first().toString(), "href=\\\"(.*?)\\\"");
            doc = UrlUtil.parseDocumentFromUrl(url);
            Pattern regex = Pattern.compile("return '(.*?)';");
            Matcher m = regex.matcher(doc.toString());
            while (m.find()) {
                String s = m.group(1);
                String tname = StrgUtils.substr(s, "<b>(.*?)</b>");
                String tpix = StrgUtils.substr(s, "raquo; (.*?)x<br>");
                Pattern lr = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
                Matcher lm = lr.matcher(s);
                while (lm.find()) {
                    String turl = lm.group(1);
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(tname);
                    trailer.setQuality(tpix);
                    trailer.setProvider("filmtrailer");
                    trailer.setUrl(turl);
                    LOGGER.debug(trailer.toString());
                    trailers.add(trailer);
                }
            }
            regex = Pattern.compile("<i>(.*?)</i>(.*?)<br>", 32);
            m = regex.matcher(doc.getElementsByClass("clips").html());
            while (m.find()) {
                String tname = m.group(1).trim();
                tname = tname.replaceFirst(":$", "");
                String urls = m.group(2);
                Pattern lr = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
                Matcher lm = lr.matcher(urls);
                while (lm.find()) {
                    String tformat;
                    String turl = lm.group(1);
                    String tpix = "";
                    switch (tformat = lm.group(2).replaceAll("&nbsp;", "").trim()) {
                        case "small": {
                            tpix = "90p";
                            break;
                        }
                        case "medium": {
                            tpix = "136p";
                            break;
                        }
                        case "large": {
                            tpix = "180p";
                            break;
                        }
                        case "xlarge": {
                            tpix = "226p";
                            break;
                        }
                        case "xxlarge": {
                            tpix = "360p";
                            break;
                        }
                    }
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(tname);
                    trailer.setQuality(tpix);
                    trailer.setProvider("filmtrailer");
                    trailer.setUrl(turl);
                    LOGGER.debug(trailer.toString());
                    trailers.add(trailer);
                }
            }
        }
        catch (Exception e) {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                LOGGER.error("Error parsing {} - {}", (Object)url, (Object)e.getMessage());
            } else {
                LOGGER.error("Error parsing {} - {}", (Object)searchString, (Object)e.getMessage());
            }
            throw new ScrapeException(e);
        }
        return trailers;
    }

    private String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }
}

