/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.omdb.OmdbConnectionCounter;
import org.tinymediamanager.scraper.omdb.entities.MovieEntity;
import org.tinymediamanager.scraper.omdb.entities.MovieRating;
import org.tinymediamanager.scraper.omdb.entities.MovieSearch;
import org.tinymediamanager.scraper.omdb.service.Controller;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class OmdbMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider {
    public static final String ID = "omdbapi";
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdbMetadataProvider.class);
    private static final MediaProviderInfo providerInfo = OmdbMetadataProvider.createMediaProviderInfo();
    private static final String API_KEY = ApiKey.decryptApikey("Isuaab2ym89iI1hOtF94nQ==");
    private Controller controller = new Controller(false);

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo(ID, "omdbapi.com", "<html><h3>Omdbapi.com</h3><br />The OMDb API is a RESTful web service to obtain movie information. All content and images on the site are contributed and maintained by our users. <br /><br />TinyMediaManager offers a limited access to OMDb (10 calls per 15 seconds). If you want to use OMDb with more than this restricted access, you should become a patron of OMDb (https://www.patreon.com/join/omdb)<br /><br />Available languages: EN</html>", OmdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/omdbapi.png"));
        providerInfo.getConfig().addText("apiKey", "", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    private String getApiKey() {
        String apiKey = providerInfo.getConfig().getValue("apiKey");
        if (StringUtils.isNotBlank((CharSequence)apiKey)) {
            return apiKey;
        }
        return API_KEY;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions query) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaRating rating;
        String[] actors;
        String[] writers;
        String[] directors;
        String[] genres;
        LOGGER.debug("getMetadata(): {}", (Object)query);
        MediaMetadata metadata = new MediaMetadata(providerInfo.getId());
        String apiKey = this.getApiKey();
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            LOGGER.warn("no API key found");
            return metadata;
        }
        String imdbId = query.getImdbId();
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = query.getIdAsString(this.getProviderInfo().getId());
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && query.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getImdbIdViaTmdbId(query.getTmdbId());
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("no imdb id found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        SimpleDateFormat format = new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH);
        LOGGER.info("========= BEGIN OMDB Scraping");
        MovieEntity result = null;
        try {
            if (API_KEY.equals(apiKey)) {
                OmdbConnectionCounter.trackConnections();
            }
            result = this.controller.getScrapeDataById(apiKey, imdbId, "movie", true);
        }
        catch (Exception e) {
            LOGGER.error("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (result == null) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        if (MetadataUtil.isValidImdbId(result.imdbID)) {
            metadata.setId("imdb", result.imdbID);
        }
        metadata.setTitle(result.title);
        try {
            metadata.setYear(Integer.parseInt(result.year));
        }
        catch (NumberFormatException e) {
            LOGGER.trace("could not parse year: {}", (Object)e.getMessage());
        }
        metadata.addCertification(MediaCertification.findCertification(result.rated));
        try {
            metadata.setReleaseDate(format.parse(result.released));
        }
        catch (Exception e) {
            // empty catch block
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(result.runtime);
        while (m.find()) {
            try {
                metadata.setRuntime(Integer.parseInt(m.group()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (String genre : genres = result.genre.split(",")) {
            genre = genre.trim();
            MediaGenres mediaGenres = MediaGenres.getGenre(genre);
            metadata.addGenre(mediaGenres);
        }
        metadata.setPlot(result.plot);
        for (String d : directors = result.director.split(",")) {
            Person director = new Person(Person.Type.DIRECTOR);
            director.setName(d.trim());
            metadata.addCastMember(director);
        }
        for (String w : writers = result.writer.split(",")) {
            Person writer = new Person(Person.Type.WRITER);
            writer.setName(w.trim());
            metadata.addCastMember(writer);
        }
        for (String a : actors = result.actors.split(",")) {
            Person actor = new Person(Person.Type.ACTOR);
            actor.setName(a.trim());
            metadata.addCastMember(actor);
        }
        metadata.setSpokenLanguages(this.getResult(result.language, ","));
        metadata.setCountries(this.getResult(result.country, ","));
        try {
            rating = new MediaRating("imdb");
            rating.setRating(Float.parseFloat(result.imdbRating));
            rating.setVotes(MetadataUtil.parseInt(result.imdbVotes));
            rating.setMaxValue(10);
            metadata.addRating(rating);
        }
        catch (NumberFormatException e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            rating = new MediaRating("metascore");
            rating.setRating(Float.parseFloat(result.metascore));
            rating.setMaxValue(100);
            metadata.addRating(rating);
        }
        catch (NumberFormatException e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        for (MovieRating movieRating : ListUtils.nullSafe(result.ratings)) {
            switch (movieRating.source) {
                case "Rotten Tomatoes": {
                    try {
                        MediaRating rating2 = new MediaRating("rottenTomatoes");
                        rating2.setRating(Integer.parseInt(movieRating.value.replace("%", "")));
                        rating2.setMaxValue(100);
                        metadata.addRating(rating2);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)result.poster)) {
            MediaArtwork artwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            artwork.setDefaultUrl(result.poster);
            metadata.addMediaArt(artwork);
        }
        return metadata;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions query) throws ScrapeException {
        MovieSearch resultList;
        LOGGER.debug("search(): {}", (Object)query);
        TreeSet<MediaSearchResult> mediaResult = new TreeSet<MediaSearchResult>();
        String apiKey = this.getApiKey();
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            LOGGER.warn("no API key found");
            return mediaResult;
        }
        try {
            LOGGER.info("========= BEGIN OMDB Scraper Search for Movie: {}", (Object)query.getSearchQuery());
            if (API_KEY.equals(apiKey)) {
                OmdbConnectionCounter.trackConnections();
            }
            resultList = this.controller.getMovieSearchInfo(apiKey, query.getSearchQuery(), "movie", null);
        }
        catch (Exception e) {
            LOGGER.error("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (resultList == null) {
            LOGGER.warn("no result from omdbapi");
            return mediaResult;
        }
        for (MovieEntity entity : ListUtils.nullSafe(resultList.search)) {
            MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.MOVIE);
            result.setTitle(entity.title);
            result.setIMDBId(entity.imdbID);
            try {
                result.setYear(Integer.parseInt(entity.year));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("could not parse year: {}", (Object)e.getMessage());
            }
            result.setPosterUrl(entity.poster);
            result.calculateScore(query);
            mediaResult.add(result);
        }
        return mediaResult;
    }

    private List<String> getResult(String input, String delimiter) {
        String[] result = input.split(delimiter);
        ArrayList<String> output = new ArrayList<String>();
        for (String r : result) {
            output.add(r.trim());
        }
        return output;
    }

    void setVerbose(boolean verbose) {
        this.controller = new Controller(verbose);
    }
}

