/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.AppendToResponse;
import com.uwetrottmann.tmdb2.entities.BaseCompany;
import com.uwetrottmann.tmdb2.entities.BaseKeyword;
import com.uwetrottmann.tmdb2.entities.BaseMovie;
import com.uwetrottmann.tmdb2.entities.CastMember;
import com.uwetrottmann.tmdb2.entities.Country;
import com.uwetrottmann.tmdb2.entities.CrewMember;
import com.uwetrottmann.tmdb2.entities.FindResults;
import com.uwetrottmann.tmdb2.entities.Genre;
import com.uwetrottmann.tmdb2.entities.Movie;
import com.uwetrottmann.tmdb2.entities.MovieResultsPage;
import com.uwetrottmann.tmdb2.entities.ReleaseDate;
import com.uwetrottmann.tmdb2.entities.ReleaseDatesResult;
import com.uwetrottmann.tmdb2.entities.SpokenLanguage;
import com.uwetrottmann.tmdb2.enumerations.AppendToResponseItem;
import com.uwetrottmann.tmdb2.enumerations.ExternalSource;
import com.uwetrottmann.tmdb2.exceptions.TmdbNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

class TmdbMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieMetadataProvider.class);
    private final Tmdb api;

    TmdbMovieMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        Exception savedException = null;
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = Utils.removeSortableName(options.getSearchQuery());
        }
        searchString = MetadataUtil.removeNonSearchCharacters(searchString);
        String imdbId = options.getImdbId();
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = "";
        }
        if (MetadataUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        boolean adult = TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("includeAdult");
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.info("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            Response httpResponse;
            if (tmdbId != 0) {
                LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
                try {
                    httpResponse = this.api.moviesService().summary(tmdbId, language, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.TRANSLATIONS})).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    Movie movie = (Movie)httpResponse.body();
                    this.verifyMovieTitleLanguage(Locale.forLanguageTag(language), movie);
                    MediaSearchResult result = this.morphMovieToSearchResult((BaseMovie)movie, options);
                    results.add(result);
                    LOGGER.debug("found {} results with TMDB id", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (results.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
                LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
                try {
                    httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    for (BaseMovie movie : ((FindResults)httpResponse.body()).movie_results) {
                        this.verifyMovieTitleLanguage(Locale.forLanguageTag(language), movie);
                        results.add(this.morphMovieToSearchResult(movie, options));
                    }
                    LOGGER.debug("found {} results with IMDB id", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (results.isEmpty()) {
                try {
                    Response httpResponse2;
                    int page = 1;
                    int maxPage = 1;
                    do {
                        if (!(httpResponse2 = this.api.searchService().movie(searchString, Integer.valueOf(page), language, null, Boolean.valueOf(adult), null, null).execute()).isSuccessful() || httpResponse2.body() == null) {
                            throw new HttpException(httpResponse2.code(), httpResponse2.message());
                        }
                        for (BaseMovie movie : ListUtils.nullSafe(((MovieResultsPage)httpResponse2.body()).results)) {
                            this.verifyMovieTitleLanguage(Locale.forLanguageTag(language), movie);
                            results.add(this.morphMovieToSearchResult(movie, options));
                        }
                    } while (++page <= (maxPage = ((MovieResultsPage)httpResponse2.body()).total_pages.intValue()));
                    LOGGER.debug("found {} results with search string", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (results.isEmpty()) {
                searchString = searchString.replaceFirst("\\s\\d{4}$", "");
                try {
                    MovieResultsPage resultsPage = (MovieResultsPage)this.api.searchService().movie(searchString, Integer.valueOf(1), language, null, Boolean.valueOf(adult), null, null).execute().body();
                    if (resultsPage != null && resultsPage.results != null) {
                        for (BaseMovie movie : resultsPage.results) {
                            this.verifyMovieTitleLanguage(Locale.forLanguageTag(language), movie);
                            results.add(this.morphMovieToSearchResult(movie, options));
                        }
                    }
                    LOGGER.debug("found {} results with search string without year", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
        }
        if (results.isEmpty() && savedException != null) {
            throw new ScrapeException(savedException);
        }
        return results;
    }

    private void verifyMovieTitleLanguage(Locale language, Movie movie) throws IOException {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue() || StringUtils.isEmpty((CharSequence)movie.overview)) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (movie.title.equals(movie.original_title) && !movie.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {} for movie {}", (Object)fallbackLanguage, (Object)movie.title);
                String[] val = new String[]{"", ""};
                if (StringUtils.isNotBlank((CharSequence)movie.title)) {
                    val[0] = movie.title;
                }
                if (StringUtils.isNotBlank((CharSequence)movie.overview)) {
                    val[1] = movie.overview;
                }
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(movie.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                movie.title = val[0];
                movie.overview = val[1];
            }
        }
    }

    private void verifyMovieTitleLanguage(Locale language, BaseMovie movie) throws IOException {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue()) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (movie.title.equals(movie.original_title) && !movie.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {} for movie {}", (Object)fallbackLanguage, (Object)movie.title);
                String lang = TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.moviesService().summary(movie.id.intValue(), lang, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.TRANSLATIONS})).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Movie m = (Movie)httpResponse.body();
                String[] val = new String[]{"", ""};
                if (StringUtils.isNotBlank((CharSequence)movie.title)) {
                    val[0] = movie.title;
                }
                if (StringUtils.isNotBlank((CharSequence)movie.overview)) {
                    val[1] = movie.overview;
                }
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(m.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                movie.title = val[0];
                movie.overview = val[1];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        Exception savedException = null;
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && !MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        Movie movie = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            if (tmdbId == 0 && MetadataUtil.isValidImdbId(imdbId)) {
                try {
                    tmdbId = new TmdbMetadataProvider().getTmdbIdFromImdbId(imdbId, options.getMediaType());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (movie == null && tmdbId > 0) {
                try {
                    Response httpResponse = this.api.moviesService().summary(tmdbId, language, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.CREDITS, AppendToResponseItem.KEYWORDS, AppendToResponseItem.RELEASE_DATES, AppendToResponseItem.TRANSLATIONS})).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    movie = (Movie)httpResponse.body();
                    this.verifyMovieTitleLanguage(Locale.forLanguageTag(language), movie);
                }
                catch (TmdbNotFoundException e) {
                    LOGGER.info("nothing found");
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
        }
        if (movie == null && savedException != null) {
            throw new ScrapeException(savedException);
        }
        if (movie == null) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        md = this.morphMovieToMediaMetadata(movie, options);
        if (movie.keywords != null && movie.keywords.keywords != null) {
            for (BaseKeyword kw : movie.keywords.keywords) {
                md.addTag(kw.name);
            }
        }
        return md;
    }

    private MediaSearchResult morphMovieToSearchResult(BaseMovie movie, MovieSearchAndScrapeOptions query) {
        MediaSearchResult searchResult = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.MOVIE);
        searchResult.setId(Integer.toString(movie.id));
        searchResult.setTitle(movie.title);
        searchResult.setOverview(movie.overview);
        searchResult.setOriginalTitle(movie.original_title);
        searchResult.setOriginalLanguage(movie.original_language);
        if (movie.poster_path != null && !movie.poster_path.isEmpty()) {
            searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + movie.poster_path);
        }
        if (movie.release_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(movie.release_date);
            searchResult.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(searchResult.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(searchResult.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            searchResult.setScore(1.0f);
        } else {
            searchResult.calculateScore(query);
        }
        return searchResult;
    }

    private MediaMetadata morphMovieToMediaMetadata(Movie movie, MovieSearchAndScrapeOptions options) {
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        md.setId(TmdbMetadataProvider.providerInfo.getId(), movie.id);
        md.setTitle(movie.title);
        md.setOriginalTitle(movie.original_title);
        md.setPlot(movie.overview);
        md.setTagline(movie.tagline);
        md.setRuntime(movie.runtime);
        MediaRating rating = new MediaRating("tmdb");
        rating.setRating(movie.vote_average.floatValue());
        rating.setVotes(movie.vote_count);
        rating.setMaxValue(10);
        md.addRating(rating);
        if (StringUtils.isNotBlank((CharSequence)movie.poster_path)) {
            Iterator<Country> ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ((MediaArtwork)((Object)ma)).setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + movie.poster_path);
            ((MediaArtwork)((Object)ma)).setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + movie.poster_path);
            ((MediaArtwork)((Object)ma)).setLanguage(options.getLanguage().getLanguage());
            ((MediaArtwork)((Object)ma)).setTmdbId(movie.id);
            md.addMediaArt((MediaArtwork)((Object)ma));
        }
        for (SpokenLanguage lang : ListUtils.nullSafe(movie.spoken_languages)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), lang.name, lang.iso_639_1));
                continue;
            }
            md.addSpokenLanguage(lang.iso_639_1);
        }
        for (Country country : ListUtils.nullSafe(movie.production_countries)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), country.name, country.iso_3166_1));
                continue;
            }
            md.addCountry(country.iso_3166_1);
        }
        if (MetadataUtil.isValidImdbId(movie.imdb_id)) {
            md.setId("imdb", movie.imdb_id);
        }
        for (BaseCompany company : ListUtils.nullSafe(movie.production_companies)) {
            md.addProductionCompany(company.name.trim());
        }
        Date releaseDate = movie.release_date;
        if (releaseDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(releaseDate);
            md.setYear(calendar.get(1));
        }
        md.setReleaseDate(releaseDate);
        if (movie.release_dates != null) {
            CountryCode countryCode = MovieModuleManager.SETTINGS.getCertificationCountry();
            for (ReleaseDatesResult countries : ListUtils.nullSafe(movie.release_dates.results)) {
                if (countryCode != null && countryCode.getAlpha2().compareToIgnoreCase(countries.iso_3166_1) != 0) continue;
                for (ReleaseDate countryReleaseDate : ListUtils.nullSafe(countries.release_dates)) {
                    if (StringUtils.isEmpty((CharSequence)countryReleaseDate.certification)) continue;
                    md.addCertification(MediaCertification.getCertification(countries.iso_3166_1, countryReleaseDate.certification));
                }
            }
        }
        if (movie.credits != null) {
            Person cm;
            for (CastMember castMember : ListUtils.nullSafe(movie.credits.cast)) {
                cm = new Person(Person.Type.ACTOR);
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + castMember.profile_path);
                }
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                md.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(movie.credits.crew)) {
                cm = new Person();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(Person.Type.DIRECTOR);
                    cm.setRole(crewMember.department);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(Person.Type.WRITER);
                    cm.setRole(crewMember.department);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(Person.Type.PRODUCER);
                    cm.setRole(crewMember.job);
                }
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), crewMember.id);
                cm.setName(crewMember.name);
                if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                    cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                md.addCastMember(cm);
            }
        }
        for (Genre genre : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        if (movie.adult.booleanValue()) {
            md.addGenre(MediaGenres.EROTIC);
        }
        if (movie.belongs_to_collection != null) {
            md.setId("tmdbSet", movie.belongs_to_collection.id);
            md.setCollectionName(movie.belongs_to_collection.name);
        }
        return md;
    }
}

