/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.BaseCollection;
import com.uwetrottmann.tmdb2.entities.BaseMovie;
import com.uwetrottmann.tmdb2.entities.Collection;
import com.uwetrottmann.tmdb2.entities.CollectionResultsPage;
import com.uwetrottmann.tmdb2.exceptions.TmdbNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

class TmdbMovieSetMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieSetMetadataProvider.class);
    private final Tmdb api;

    TmdbMovieSetMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MovieSetSearchAndScrapeOptions query) throws ScrapeException {
        LOGGER.debug("search() - {}", (Object)query.toString());
        ArrayList<MediaSearchResult> movieSetsFound = new ArrayList<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)query.getSearchQuery())) {
            searchString = Utils.removeSortableName(query.getSearchQuery());
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            LOGGER.debug("TMDB Scraper: empty searchString");
            return movieSetsFound;
        }
        String language = TmdbMetadataProvider.getRequestLanguage(query.getLanguage());
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            block9: {
                try {
                    CollectionResultsPage resultsPage = (CollectionResultsPage)this.api.searchService().collection(searchString, Integer.valueOf(1), language).execute().body();
                    if (resultsPage == null) break block9;
                    for (BaseCollection collection : ListUtils.nullSafe(resultsPage.results)) {
                        MediaSearchResult searchResult = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.MOVIE_SET);
                        searchResult.setId(Integer.toString(collection.id));
                        searchResult.setTitle(collection.name);
                        searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + collection.poster_path);
                        searchResult.setScore(MetadataUtil.calculateScore(searchString, collection.name));
                        if (!((double)searchResult.getScore() < 0.5 && TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue() && this.verifyMovieSetTitleLanguage(movieSetsFound, resultsPage, query))) {
                            movieSetsFound.add(searchResult);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("failed to search: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
            }
        }
        LOGGER.info("found {} results ", (Object)movieSetsFound.size());
        return movieSetsFound;
    }

    private boolean verifyMovieSetTitleLanguage(List<MediaSearchResult> movieSetsFound, CollectionResultsPage original, MovieSetSearchAndScrapeOptions query) throws Exception {
        String lang = MediaLanguages.get(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage")).name().replace("_", "-");
        CollectionResultsPage fallBackResultsPage = (CollectionResultsPage)this.api.searchService().collection(query.getSearchQuery(), Integer.valueOf(1), lang).execute().body();
        if (fallBackResultsPage != null && original.results != null && fallBackResultsPage.results != null) {
            movieSetsFound.clear();
            for (int i = 0; i < original.results.size(); ++i) {
                BaseCollection originalCollection = (BaseCollection)original.results.get(i);
                BaseCollection fallbackCollection = (BaseCollection)fallBackResultsPage.results.get(i);
                MediaSearchResult searchResult = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.MOVIE_SET);
                searchResult.setId(Integer.toString(originalCollection.id));
                if (MetadataUtil.calculateScore(query.getSearchQuery(), originalCollection.name) >= MetadataUtil.calculateScore(query.getSearchQuery(), fallbackCollection.name)) {
                    searchResult.setTitle(originalCollection.name);
                    searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + originalCollection.poster_path);
                    searchResult.setScore(MetadataUtil.calculateScore(query.getSearchQuery(), originalCollection.name));
                } else {
                    searchResult.setTitle(fallbackCollection.name);
                    searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + fallbackCollection.poster_path);
                    searchResult.setScore(MetadataUtil.calculateScore(query.getSearchQuery(), fallbackCollection.name));
                }
                movieSetsFound.add(searchResult);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getMetadata(MovieSetSearchAndScrapeOptions options) throws MissingIdException, ScrapeException, NothingFoundException {
        MediaArtwork ma;
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException(new String[]{"tmdbSet"});
        }
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        Collection collection = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                collection = (Collection)this.api.collectionService().summary(tmdbId, language).execute().body();
                if (collection != null && (StringUtils.isBlank((CharSequence)collection.overview) || StringUtils.isBlank((CharSequence)collection.name)) && TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue()) {
                    String fallbackLang = MediaLanguages.get(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage")).name().replace("_", "-");
                    Collection collectionInFallbackLanguage = (Collection)this.api.collectionService().summary(tmdbId, fallbackLang).execute().body();
                    if (collectionInFallbackLanguage != null) {
                        Collection collectionInDefaultLanguage = null;
                        if (StringUtils.isBlank((CharSequence)collectionInFallbackLanguage.name) || StringUtils.isBlank((CharSequence)collectionInFallbackLanguage.overview)) {
                            collectionInDefaultLanguage = (Collection)this.api.collectionService().summary(tmdbId, null).execute().body();
                        }
                        if (StringUtils.isBlank((CharSequence)collection.name) && StringUtils.isNotBlank((CharSequence)collectionInFallbackLanguage.name)) {
                            collection.name = collectionInFallbackLanguage.name;
                        } else if (StringUtils.isBlank((CharSequence)collection.name) && collectionInDefaultLanguage != null && StringUtils.isNotBlank((CharSequence)collectionInDefaultLanguage.name)) {
                            collection.name = collectionInDefaultLanguage.name;
                        }
                        if (StringUtils.isBlank((CharSequence)collection.overview) && StringUtils.isNotBlank((CharSequence)collectionInFallbackLanguage.overview)) {
                            collection.overview = collectionInFallbackLanguage.overview;
                        } else if (StringUtils.isBlank((CharSequence)collection.overview) && collectionInDefaultLanguage != null && StringUtils.isNotBlank((CharSequence)collectionInDefaultLanguage.overview)) {
                            collection.overview = collectionInDefaultLanguage.overview;
                        }
                        block6: for (BaseMovie movie : collection.parts) {
                            for (BaseMovie fallbackMovie : collectionInFallbackLanguage.parts) {
                                if (!movie.id.equals(fallbackMovie.id)) continue;
                                if (StringUtils.isBlank((CharSequence)movie.overview) && !StringUtils.isBlank((CharSequence)fallbackMovie.overview)) {
                                    movie.overview = fallbackMovie.overview;
                                }
                                if (!movie.title.equals(movie.original_title) || movie.original_language.equals(options.getLanguage().getLanguage()) || StringUtils.isBlank((CharSequence)fallbackMovie.title)) continue block6;
                                movie.title = fallbackMovie.title;
                                continue block6;
                            }
                        }
                    }
                }
            }
            catch (TmdbNotFoundException e) {
                LOGGER.info("nothing found");
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (collection == null) {
            throw new NothingFoundException();
        }
        md.setId("tmdbSet", collection.id);
        md.setTitle(collection.name);
        md.setPlot(collection.overview);
        if (StringUtils.isNotBlank((CharSequence)collection.poster_path)) {
            ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + collection.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + collection.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(tmdbId);
            md.addMediaArt(ma);
        }
        if (StringUtils.isNotBlank((CharSequence)collection.backdrop_path)) {
            ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w300" + collection.backdrop_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + collection.backdrop_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(tmdbId);
            md.addMediaArt(ma);
        }
        for (BaseMovie part : ListUtils.nullSafe(collection.parts)) {
            MediaMetadata mdSubItem = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
            mdSubItem.setId(TmdbMetadataProvider.providerInfo.getId(), part.id);
            mdSubItem.setTitle(part.title);
            if (StringUtils.isNotBlank((CharSequence)part.poster_path)) {
                MediaArtwork ma2 = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma2.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + part.poster_path);
                ma2.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + part.poster_path);
                ma2.setLanguage(options.getLanguage().getLanguage());
                ma2.setTmdbId(part.id);
                mdSubItem.addMediaArt(ma2);
            }
            if (StringUtils.isNotBlank((CharSequence)part.backdrop_path)) {
                MediaArtwork ma2 = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                ma2.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w300" + part.backdrop_path);
                ma2.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + part.backdrop_path);
                ma2.setLanguage(options.getLanguage().getLanguage());
                ma2.setTmdbId(part.id);
                mdSubItem.addMediaArt(ma2);
            }
            mdSubItem.setReleaseDate(part.release_date);
            md.addSubItem(mdSubItem);
        }
        return md;
    }
}

