/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieTranslation;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import retrofit2.Response;

class TraktMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktMovieMetadataProvider.class);
    private final TraktV2 api;

    TraktMovieMetadataProvider(TraktV2 api) {
        this.api = api;
    }

    SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        String searchString = "";
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        List searchResults = null;
        try {
            Response response = this.api.search().textQueryMovie(searchString, null, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
            if (!response.isSuccessful()) {
                LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                throw new HttpException(response.code(), response.message());
            }
            searchResults = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("Problem scraping for {} - {}", (Object)searchString, (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            results.add(m);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata scrape(MovieSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MovieTranslation trans;
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", TraktMetadataProvider.providerInfo.getId());
        }
        LOGGER.debug("Trakt.tv: getMetadata: id = {}", (Object)id);
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Movie movie = null;
        Credits credits = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.movies().summary(id, Extended.FULL).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                movie = (Movie)response.body();
                if (!"en".equals(lang)) {
                    translations = (List)this.api.movies().translation(id, lang).execute().body();
                }
                credits = (Credits)this.api.movies().people(id).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (movie == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        MovieTranslation movieTranslation = trans = translations == null || translations.isEmpty() ? null : (MovieTranslation)translations.get(0);
        if (trans != null) {
            md.setTitle(StringUtils.isBlank((CharSequence)trans.title) ? movie.title : trans.title);
            md.setTagline(StringUtils.isBlank((CharSequence)trans.tagline) ? movie.tagline : trans.tagline);
            md.setPlot(StringUtils.isBlank((CharSequence)trans.overview) ? movie.overview : trans.overview);
        } else {
            md.setTitle(movie.title);
            md.setTagline(movie.tagline);
            md.setPlot(movie.overview);
        }
        md.setYear(movie.year);
        md.setRuntime(movie.runtime);
        md.addCertification(MediaCertification.findCertification(movie.certification));
        md.setReleaseDate(TraktUtils.toDate(movie.released));
        try {
            MediaRating rating = new MediaRating("trakt");
            rating.setRating((double)Math.round(movie.rating * 10.0) / 10.0);
            rating.setVotes(movie.votes);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        if (movie.ids != null) {
            md.setId(TraktMetadataProvider.providerInfo.getId(), movie.ids.trakt);
            if (movie.ids.tmdb != null && movie.ids.tmdb > 0) {
                md.setId("tmdb", movie.ids.tmdb);
            }
            if (StringUtils.isNotBlank((CharSequence)movie.ids.imdb)) {
                md.setId("imdb", movie.ids.imdb);
            }
        }
        for (String genreAsString : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe(credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, Person.Type.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.WRITER));
                }
            }
        }
        return md;
    }
}

