/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.SearchResult;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;

public class TraktUtils {
    public static Date toDate(LocalDate date) {
        try {
            LocalTime time = LocalTime.of((int)0, (int)0);
            Instant instant = date.atTime(time).atZone(ZoneId.systemDefault()).toInstant();
            Date d = DateTimeUtils.toDate((Instant)instant);
            return d;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date toDate(OffsetDateTime date) {
        try {
            Date d = DateTimeUtils.toDate((Instant)date.toInstant());
            return d;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static MediaSearchResult morphTraktResultToTmmResult(MediaSearchAndScrapeOptions options, SearchResult traktResult) {
        MediaSearchResult msr = new MediaSearchResult(TraktMetadataProvider.providerInfo.getId(), options.getMediaType());
        if (traktResult.movie != null) {
            msr.setTitle(traktResult.movie.title);
            msr.setOverview(traktResult.movie.overview);
            msr.setYear(traktResult.movie.year);
            msr.setId(TraktMetadataProvider.providerInfo.getId(), String.valueOf(traktResult.movie.ids.trakt));
            if (traktResult.movie.ids.tmdb != null && traktResult.movie.ids.tmdb > 0) {
                msr.setId("tmdb", String.valueOf(traktResult.movie.ids.tmdb));
            }
            if (StringUtils.isNotBlank((CharSequence)traktResult.movie.ids.imdb)) {
                msr.setId("imdb", traktResult.movie.ids.imdb);
            }
        }
        if (traktResult.show != null) {
            msr.setTitle(traktResult.show.title);
            msr.setOverview(traktResult.show.overview);
            msr.setYear(traktResult.show.year);
            msr.setId(TraktMetadataProvider.providerInfo.getId(), String.valueOf(traktResult.show.ids.trakt));
            if (traktResult.show.ids.tmdb != null && traktResult.show.ids.tmdb > 0) {
                msr.setId("tmdb", String.valueOf(traktResult.show.ids.tmdb));
            }
            if (StringUtils.isNotBlank((CharSequence)traktResult.show.ids.imdb)) {
                msr.setId("imdb", traktResult.show.ids.imdb);
            }
        }
        if (traktResult.episode != null) {
            msr.setTitle(traktResult.episode.title);
            msr.setOverview(traktResult.episode.overview);
            msr.setYear(traktResult.episode.first_aired.getYear());
            msr.setId(TraktMetadataProvider.providerInfo.getId(), String.valueOf(traktResult.episode.ids.trakt));
            if (traktResult.episode.ids.tmdb != null && traktResult.episode.ids.tmdb > 0) {
                msr.setId("tmdb", String.valueOf(traktResult.episode.ids.tmdb));
            }
            if (StringUtils.isNotBlank((CharSequence)traktResult.episode.ids.imdb)) {
                msr.setId("imdb", traktResult.episode.ids.imdb);
            }
        }
        msr.calculateScore(options);
        return msr;
    }

    public static Person toTmmCast(CrewMember crew, Person.Type type) {
        Person cm = new Person(type);
        cm.setName(crew.person.name);
        cm.setRole(crew.job);
        if (crew.person.ids != null) {
            cm.setId(TraktMetadataProvider.providerInfo.getId(), crew.person.ids.trakt);
            cm.setId("imdb", crew.person.ids.imdb);
            cm.setId("tmdb", crew.person.ids.tmdb);
            if (StringUtils.isNotBlank((CharSequence)crew.person.ids.slug)) {
                cm.setProfileUrl("https://trakt.tv/people/" + crew.person.ids.slug);
            }
        }
        return cm;
    }

    public static Person toTmmCast(CastMember crew, Person.Type type) {
        Person cm = new Person(type);
        cm.setName(crew.person.name);
        cm.setRole(crew.character);
        if (crew.person.ids != null) {
            cm.setId(TraktMetadataProvider.providerInfo.getId(), crew.person.ids.trakt);
            cm.setId("imdb", crew.person.ids.imdb);
            cm.setId("tmdb", crew.person.ids.tmdb);
            if (StringUtils.isNotBlank((CharSequence)crew.person.ids.slug)) {
                cm.setProfileUrl("https://trakt.tv/people/" + crew.person.ids.slug);
            }
        }
        return cm;
    }
}

