/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.Similarity;

public class MetadataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataUtil.class);

    private MetadataUtil() {
    }

    public static float calculateScore(String searchTitle, String matchTitle) {
        float score1 = Similarity.compareStrings(searchTitle, matchTitle);
        float score2 = Similarity.compareStrings(searchTitle, MetadataUtil.removeNonSearchCharacters(matchTitle));
        float score3 = 0.0f;
        if (searchTitle != null && searchTitle.matches(".* \\d{4}$")) {
            score3 = Similarity.compareStrings(searchTitle.replaceFirst(" \\d{4}$", ""), matchTitle);
        }
        float score = Math.max(score1, Math.max(score3, score2));
        LOGGER.debug(String.format("Similarity Score: [%s][%s]=[%s]", searchTitle, matchTitle, Float.valueOf(score)));
        return score;
    }

    public static float calculateYearPenalty(int searchYear, int resultYear) {
        if (searchYear == 0) {
            return 0.0f;
        }
        if (resultYear == 0) {
            return 0.11f;
        }
        int diff = Math.abs(searchYear - resultYear);
        if (diff == 0) {
            return 0.0f;
        }
        if (diff > 100) {
            return 0.11f;
        }
        return 0.01f + (float)diff / 1000.0f;
    }

    public static String parseRunningTime(String in, String regex) {
        if (in == null || regex == null) {
            return null;
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(in);
        if (m.find()) {
            return m.group(1);
        }
        LOGGER.warn("Could not find Running Time in {}; using Regex: {}", (Object)in, (Object)regex);
        return null;
    }

    public static String removeNonSearchCharacters(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("[\\\\[\\\\]_.:|]", " ");
    }

    public static boolean isValidImdbId(String imdbId) {
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return false;
        }
        return imdbId.matches("tt\\d{6,}");
    }

    public static int parseInt(String intAsString) throws NumberFormatException {
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(intAsString.replaceAll("[,\\.\\s]*", ""));
        }
    }

    public static int parseInt(String intAsString, int defaultValue) {
        try {
            return MetadataUtil.parseInt(intAsString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int unboxInteger(Integer original) {
        return MetadataUtil.unboxInteger(original, 0);
    }

    public static int unboxInteger(Integer original, int defaulValue) {
        return Optional.ofNullable(original).orElse(defaulValue);
    }
}

