/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.MediaInfoException;
import org.tinymediamanager.thirdparty.MediaInfoLibrary;

public class MediaInfo
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfo.class);
    private Pointer handle;

    public Boolean isLoaded() {
        return this.handle != null;
    }

    public boolean open(Path file) throws MediaInfoException {
        try {
            if (this.handle == null) {
                this.handle = MediaInfoLibrary.INSTANCE.New();
            }
        }
        catch (LinkageError e) {
            return false;
        }
        if (file != null && this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Open(this.handle, new WString(file.toAbsolutePath().toString())) > 0;
        }
        return false;
    }

    public boolean openBufferInit(long length, long offset) {
        try {
            if (this.handle == null) {
                this.handle = MediaInfoLibrary.INSTANCE.New();
            }
        }
        catch (LinkageError e) {
            return false;
        }
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Open_Buffer_Init(this.handle, length, offset) > 0;
        }
        return false;
    }

    public int openBufferContinue(byte[] buffer, int size) {
        return MediaInfoLibrary.INSTANCE.Open_Buffer_Continue(this.handle, buffer, size);
    }

    public long openBufferContinueGoToGet() {
        return MediaInfoLibrary.INSTANCE.Open_Buffer_Continue_GoTo_Get(this.handle);
    }

    public int openBufferFinalize() {
        return MediaInfoLibrary.INSTANCE.Open_Buffer_Finalize(this.handle);
    }

    public String inform() {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Inform(this.handle, 0).toString();
        }
        return "";
    }

    public String option(String option) {
        return this.option(option, "");
    }

    public String Get(StreamKind StreamKind2, int StreamNumber, String parameter) {
        return this.Get(StreamKind2, StreamNumber, parameter, InfoKind.Text, InfoKind.Name);
    }

    public String Get(StreamKind StreamKind2, int StreamNumber, String parameter, InfoKind infoKind) {
        return this.Get(StreamKind2, StreamNumber, parameter, infoKind, InfoKind.Name);
    }

    public String Get(StreamKind StreamKind2, int StreamNumber, String parameter, InfoKind infoKind, InfoKind searchKind) {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Get(this.handle, StreamKind2.ordinal(), StreamNumber, new WString(parameter), infoKind.ordinal(), searchKind.ordinal()).toString();
        }
        return "";
    }

    public String get(StreamKind StreamKind2, int StreamNumber, int parameterIndex) {
        return this.Get(StreamKind2, StreamNumber, parameterIndex, InfoKind.Text);
    }

    public String Get(StreamKind StreamKind2, int StreamNumber, int parameterIndex, InfoKind infoKind) {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.GetI(this.handle, StreamKind2.ordinal(), StreamNumber, parameterIndex, infoKind.ordinal()).toString();
        }
        return "";
    }

    public String option(String option, String value) {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Option(this.handle, new WString(option), new WString(value)).toString();
        }
        return "";
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter) {
        return this.get(streamKind, streamNumber, parameter, InfoKind.Text, InfoKind.Name);
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter, InfoKind infoKind) {
        return this.get(streamKind, streamNumber, parameter, infoKind, InfoKind.Name);
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter, InfoKind infoKind, InfoKind searchKind) {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Get(this.handle, streamKind.ordinal(), streamNumber, new WString(parameter), infoKind.ordinal(), searchKind.ordinal()).toString();
        }
        return "";
    }

    public String get(StreamKind streamKind, int streamNumber, int parameterIndex, InfoKind infoKind) {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.GetI(this.handle, streamKind.ordinal(), streamNumber, parameterIndex, infoKind.ordinal()).toString();
        }
        return "";
    }

    public int streamCount(StreamKind streamKind) {
        if (this.isLoaded().booleanValue()) {
            try {
                String StreamCount = this.get(streamKind, 0, "StreamCount");
                if (StreamCount == null || StreamCount.length() == 0) {
                    return 0;
                }
                return Integer.parseInt(StreamCount);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public int parameterCount(StreamKind streamKind, int streamNumber) {
        if (this.isLoaded().booleanValue()) {
            return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamKind.ordinal(), streamNumber);
        }
        return 0;
    }

    public Map<StreamKind, List<Map<String, String>>> snapshot() {
        EnumMap<StreamKind, List<Map<String, String>>> mediaInfo = new EnumMap<StreamKind, List<Map<String, String>>>(StreamKind.class);
        for (StreamKind streamKind : StreamKind.values()) {
            int streamCount = this.streamCount(streamKind);
            if (streamCount <= 0) continue;
            ArrayList<Map<String, String>> streamInfoList = new ArrayList<Map<String, String>>(streamCount);
            for (int i = 0; i < streamCount; ++i) {
                streamInfoList.add(this.snapshot(streamKind, i));
            }
            mediaInfo.put(streamKind, streamInfoList);
        }
        return mediaInfo;
    }

    public Map<String, String> snapshot(StreamKind streamKind, int streamNumber) {
        LinkedHashMap<String, String> streamInfo = new LinkedHashMap<String, String>();
        int count = this.parameterCount(streamKind, streamNumber);
        for (int i = 0; i < count; ++i) {
            String value = this.get(streamKind, streamNumber, i, InfoKind.Text);
            if (value.length() <= 0) continue;
            streamInfo.put(this.get(streamKind, streamNumber, i, InfoKind.Name), value);
        }
        return streamInfo;
    }

    @Override
    public void close() {
        if (this.isLoaded().booleanValue()) {
            MediaInfoLibrary.INSTANCE.Close(this.handle);
        }
    }

    public void dispose() {
        if (!this.isLoaded().booleanValue()) {
            throw new IllegalStateException();
        }
        MediaInfoLibrary.INSTANCE.Delete(this.handle);
        this.handle = null;
    }

    protected void finalize() {
        if (this.isLoaded().booleanValue()) {
            this.dispose();
        }
    }

    public static String version() {
        return MediaInfo.staticOption("Info_Version");
    }

    public static String parameters() {
        return MediaInfo.staticOption("Info_Parameters");
    }

    public static String codecs() {
        return MediaInfo.staticOption("Info_Codecs");
    }

    public static String capacities() {
        return MediaInfo.staticOption("Info_Capacities");
    }

    public static String staticOption(String option) {
        return MediaInfo.staticOption(option, "");
    }

    public static String staticOption(String option, String value) {
        try {
            return MediaInfoLibrary.INSTANCE.Option(null, new WString(option), new WString(value)).toString();
        }
        catch (Error e) {
            LOGGER.error("Failed to load mediainfo", (Throwable)e);
            return "";
        }
    }

    public static Map<StreamKind, List<Map<String, String>>> snapshot(Path file) throws IOException {
        try (MediaInfo mi = new MediaInfo();){
            if (mi.open(file)) {
                Map<StreamKind, List<Map<String, String>>> map = mi.snapshot();
                return map;
            }
            throw new IOException("Failed to open file: " + file);
        }
    }

    public static enum Status {
        None(0),
        Accepted(1),
        Filled(2),
        Updated(4),
        Finalized(8);

        private int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue(int value) {
            return value;
        }
    }

    public static enum InfoKind {
        Name,
        Text,
        Measure,
        Options,
        Name_Text,
        Measure_Text,
        Info,
        HowTo,
        Domain;

    }

    public static enum StreamKind {
        General,
        Video,
        Audio,
        Text,
        Other,
        Image,
        Menu,
        Chapters;

    }
}

