/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaInfoUtils {
    public static final boolean USE_LIBMEDIAINFO = MediaInfoUtils.useMediaInfo();
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoUtils.class);

    private MediaInfoUtils() {
    }

    private static boolean useMediaInfo() {
        return Boolean.parseBoolean(System.getProperty("tmm.uselibmediainfo", "true"));
    }

    public static void loadMediaInfo() {
        if (!USE_LIBMEDIAINFO) {
            return;
        }
        try {
            String miv = "";
            String nativepath = "native/";
            if (Platform.isWindows()) {
                nativepath = nativepath + "windows";
            } else if (Platform.isLinux()) {
                nativepath = nativepath + "linux";
            } else if (Platform.isMac()) {
                nativepath = nativepath + "mac";
            }
            if (!Platform.isMac()) {
                nativepath = Platform.is64Bit() ? nativepath + "-x64" : nativepath + "-x86";
            }
            if (System.getProperty("user.dir", "").startsWith("\\\\") || System.getProperty("user.dir", "").startsWith("//")) {
                LOGGER.debug("We're on a network UNC path!");
                Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), "tmm");
                Path nativeDir = tmpDir.resolve(nativepath).toAbsolutePath();
                Utils.copyDirectoryRecursive(Paths.get(nativepath, new String[0]), nativeDir);
                System.setProperty("jna.library.path", nativeDir.toString());
                System.setProperty("org.lwjgl.librarypath", nativeDir.toString());
                LOGGER.debug("Loading native libs from: {}", (Object)nativeDir.toString());
            } else {
                System.setProperty("jna.library.path", nativepath);
                System.setProperty("org.lwjgl.librarypath", nativepath);
                LOGGER.debug("Loading native libs from: {}", (Object)nativepath);
            }
            miv = MediaInfo.version();
            if (!StringUtils.isEmpty((CharSequence)miv)) {
                LOGGER.info("Using {}", (Object)miv);
            } else {
                LOGGER.error("could not load MediaInfo!");
                if (Platform.isLinux()) {
                    LOGGER.error("Please try do install the library from your distribution");
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not load mediainfo", (Throwable)e);
        }
    }
}

