/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.BaseMovie;
import com.uwetrottmann.trakt5.entities.Metadata;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieIds;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncMovie;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;
import retrofit2.Response;

class TraktTvMovie {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTvMovie.class);
    private final TraktTv traktTv;
    private final TraktV2 api;

    TraktTvMovie(TraktTv traktTv) {
        this.traktTv = traktTv;
        this.api = traktTv.getApi();
    }

    void syncTraktMovieCollection(List<org.tinymediamanager.core.movie.entities.Movie> moviesInTmm) {
        List traktMovies;
        LOGGER.debug("got up to {} movies for Trakt.tv collection sync", (Object)moviesInTmm.size());
        try {
            Response response = this.api.sync().collectionMovies(Extended.METADATA).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                this.traktTv.refreshAccessToken();
                response = this.api.sync().collectionMovies(Extended.METADATA).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)response.code(), (Object)response.message());
                return;
            }
            traktMovies = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} movies in your Trakt.tv collection", (Object)traktMovies.size());
        ArrayList<org.tinymediamanager.core.movie.entities.Movie> tmmMovies = new ArrayList<org.tinymediamanager.core.movie.entities.Movie>(moviesInTmm);
        for (BaseMovie traktMovie : traktMovies) {
            List<org.tinymediamanager.core.movie.entities.Movie> matchingTmmMovies = this.getTmmMoviesForTraktMovie(tmmMovies, traktMovie.movie);
            boolean metadataFound = false;
            Iterator<org.tinymediamanager.core.movie.entities.Movie> iterator = matchingTmmMovies.iterator();
            while (iterator.hasNext()) {
                org.tinymediamanager.core.movie.entities.Movie tmmMovie = iterator.next();
                boolean dirty = this.updateIDs(tmmMovie, traktMovie.movie);
                if (traktMovie.collected_at != null) {
                    Date collectedAt = DateTimeUtils.toDate((Instant)traktMovie.collected_at.toInstant());
                    if (!collectedAt.equals(tmmMovie.getDateAdded())) {
                        LOGGER.trace("Marking movie '{}' as collected on {} (was {})", new Object[]{tmmMovie.getTitle(), collectedAt, tmmMovie.getDateAddedAsString()});
                    }
                    tmmMovie.setDateAdded(collectedAt);
                    dirty = true;
                }
                if (dirty) {
                    tmmMovie.writeNFO();
                    tmmMovie.saveToDb();
                }
                if (TraktTvMovie.matchesMetadata(traktMovie.metadata, tmmMovie)) {
                    metadataFound = true;
                }
                tmmMovies.remove(tmmMovie);
            }
            if (metadataFound || matchingTmmMovies.isEmpty()) continue;
            tmmMovies.add((org.tinymediamanager.core.movie.entities.Movie)matchingTmmMovies.get(0));
        }
        if (tmmMovies.isEmpty()) {
            LOGGER.debug("Already up-to-date - no need to add anything :)");
            return;
        }
        LOGGER.debug("prepare {} movies for Trakt.tv collection sync", (Object)tmmMovies.size());
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmMovies) {
            if (tmmMovie.getIdAsInt("trakt") > 0 || MetadataUtil.isValidImdbId(tmmMovie.getImdbId()) || tmmMovie.getTmdbId() > 0) {
                movies.add(this.toSyncMovie(tmmMovie, TraktTv.SyncType.COLLECTION));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping {} movies, because they have not been scraped yet!", (Object)nosync);
        }
        if (movies.isEmpty()) {
            LOGGER.info("no new movies for Trakt.tv collection sync found.");
            return;
        }
        try {
            LOGGER.info("Adding {} movies to Trakt.tv collection", (Object)movies.size());
            SyncItems items = new SyncItems().movies(movies);
            Response response = this.api.sync().addItemsToCollection(items).execute();
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)response.code(), (Object)response.message());
                return;
            }
            LOGGER.debug("Trakt add-to-library status:");
            TraktTv.printStatus((SyncResponse)response.body());
        }
        catch (Exception e) {
            LOGGER.error("failed syncing Trakt.tv: {}", (Object)e.getMessage());
        }
    }

    void syncTraktMovieWatched(List<org.tinymediamanager.core.movie.entities.Movie> moviesInTmm) {
        List traktMovies;
        ArrayList<org.tinymediamanager.core.movie.entities.Movie> tmmMovies = new ArrayList<org.tinymediamanager.core.movie.entities.Movie>(moviesInTmm);
        try {
            Response traktWatchedResponse = this.api.sync().watchedMovies(null).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                this.traktTv.refreshAccessToken();
                traktWatchedResponse = this.api.sync().watchedMovies(null).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)traktWatchedResponse.code(), (Object)traktWatchedResponse.message());
                return;
            }
            traktMovies = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt.tv: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} movies marked as 'watched' in your Trakt.tv collection", (Object)traktMovies.size());
        for (Object traktWatched : traktMovies) {
            List<org.tinymediamanager.core.movie.entities.Movie> matchingTmmMovies = this.getTmmMoviesForTraktMovie(tmmMovies, ((BaseMovie)traktWatched).movie);
            for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : matchingTmmMovies) {
                Date lastWatchedAt;
                boolean dirty = this.updateIDs(tmmMovie, ((BaseMovie)traktWatched).movie);
                if (!tmmMovie.isWatched()) {
                    LOGGER.trace("Marking movie '{}' as watched", (Object)tmmMovie.getTitle());
                    tmmMovie.setWatched(true);
                    dirty = true;
                }
                if (dirty) {
                    tmmMovie.writeNFO();
                    tmmMovie.saveToDb();
                }
                if (((BaseMovie)traktWatched).last_watched_at == null || (lastWatchedAt = DateTimeUtils.toDate((Instant)((BaseMovie)traktWatched).last_watched_at.toInstant())).equals(tmmMovie.getLastWatched())) continue;
                LOGGER.trace("Marking movie '{}' as watched on {} (was {})", new Object[]{tmmMovie.getTitle(), lastWatchedAt, tmmMovie.getLastWatched()});
                tmmMovie.setLastWatched(lastWatchedAt);
            }
        }
        List tmmWatchedMovies = moviesInTmm.stream().filter(org.tinymediamanager.core.movie.entities.Movie::isWatched).collect(Collectors.toList());
        LOGGER.info("You have now {} movies marked as 'watched' in your TMM database", (Object)tmmWatchedMovies.size());
        for (BaseMovie traktWatched : traktMovies) {
            tmmWatchedMovies.removeAll(this.getTmmMoviesForTraktMovie(tmmMovies, traktWatched.movie));
        }
        if (tmmWatchedMovies.isEmpty()) {
            LOGGER.debug("no new watched movies for Trakt.tv sync found.");
            return;
        }
        LOGGER.debug("prepare {} movies for Trakt.tv sync", (Object)tmmWatchedMovies.size());
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmWatchedMovies) {
            if (tmmMovie.getIdAsInt("trakt") > 0 || MetadataUtil.isValidImdbId(tmmMovie.getImdbId()) || tmmMovie.getTmdbId() > 0) {
                movies.add(this.toSyncMovie(tmmMovie, TraktTv.SyncType.WATCHED));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping {} movies, because they have not been scraped yet!", (Object)nosync);
        }
        if (movies.isEmpty()) {
            LOGGER.debug("no new watched movies for Trakt.tv sync found.");
            return;
        }
        try {
            LOGGER.info("Marking {} movies as 'watched' to Trakt.tv collection", (Object)movies.size());
            SyncItems items = new SyncItems().movies(movies);
            Response response = this.api.sync().addItemsToWatchedHistory(items).execute();
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)response.code(), (Object)response.message());
                return;
            }
            LOGGER.debug("Trakt mark-as-watched status:");
            TraktTv.printStatus((SyncResponse)response.body());
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
        }
    }

    void clearTraktMovies() {
        Response response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            Response traktCollectionResponse = this.api.sync().collectionMovies(null).execute();
            if (!traktCollectionResponse.isSuccessful() && traktCollectionResponse.code() == 401) {
                this.traktTv.refreshAccessToken();
                traktCollectionResponse = this.api.sync().collectionMovies(null).execute();
            }
            if (!traktCollectionResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)traktCollectionResponse.code(), (Object)traktCollectionResponse.message());
                return;
            }
            traktCollection = (List)traktCollectionResponse.body();
            Object traktWatchedResponse = this.api.sync().watchedMovies(null).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                this.traktTv.refreshAccessToken();
                traktWatchedResponse = this.api.sync().watchedMovies(null).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)traktWatchedResponse.code(), (Object)traktWatchedResponse.message());
                return;
            }
            traktWatched = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} movies in your Trakt.tv collection", (Object)traktCollection.size());
        LOGGER.info("You have {} movies watched", (Object)traktWatched.size());
        ArrayList<SyncMovie> moviesToRemove = new ArrayList<SyncMovie>();
        for (BaseMovie traktMovie : traktCollection) {
            moviesToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!moviesToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(moviesToRemove);
                response = this.api.sync().deleteItemsFromCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)response.code(), (Object)response.message());
                    return;
                }
                LOGGER.info("removed {} movies from your trakt.tv collection", (Object)moviesToRemove.size());
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
                return;
            }
        }
        moviesToRemove.clear();
        for (BaseMovie traktMovie : traktWatched) {
            moviesToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!moviesToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(moviesToRemove);
                response = this.api.sync().deleteItemsFromWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt.tv: HTTP {} - '{}'", (Object)response.code(), (Object)response.message());
                    return;
                }
                LOGGER.info("removed {} movies from your trakt.tv watched", (Object)moviesToRemove.size());
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            }
        }
    }

    private List<org.tinymediamanager.core.movie.entities.Movie> getTmmMoviesForTraktMovie(List<org.tinymediamanager.core.movie.entities.Movie> tmmMovies, Movie traktMovie) {
        return tmmMovies.stream().filter(movie -> this.matches((org.tinymediamanager.core.movie.entities.Movie)movie, traktMovie)).collect(Collectors.toList());
    }

    private boolean matches(org.tinymediamanager.core.movie.entities.Movie tmmMovie, Movie traktMovie) {
        if (traktMovie == null || traktMovie.ids == null) {
            return false;
        }
        MovieIds ids = traktMovie.ids;
        int traktId = MetadataUtil.unboxInteger(ids.trakt);
        if (traktId > 0 && traktId == tmmMovie.getIdAsInt("trakt")) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)ids.imdb) && ids.imdb.equals(tmmMovie.getImdbId())) {
            return true;
        }
        int tmdbId = MetadataUtil.unboxInteger(ids.tmdb);
        return tmdbId > 0 && tmdbId == tmmMovie.getTmdbId();
    }

    private static boolean matchesMetadata(Metadata metadata, org.tinymediamanager.core.movie.entities.Movie movie) {
        if (metadata == null) {
            return false;
        }
        if (metadata.is3d == null || metadata.is3d.booleanValue() != movie.isVideoIn3D()) {
            return false;
        }
        if (metadata.audio != TraktTv.getAudio(movie.getMediaInfoAudioCodec())) {
            return false;
        }
        if (metadata.media_type != TraktTv.getMediaType(movie.getMediaInfoSource())) {
            return false;
        }
        if (metadata.resolution != TraktTv.getResolution(movie.getMainVideoFile())) {
            return false;
        }
        if (metadata.audio_channels == TraktTv.getAudioChannels(movie.getMainVideoFile().getAudioChannelCount())) {
            return false;
        }
        return metadata.hdr == TraktTv.getHdr(movie.getVideoHDRFormat());
    }

    private boolean updateIDs(org.tinymediamanager.core.movie.entities.Movie tmmMovie, Movie traktMovie) {
        boolean dirty = false;
        if (traktMovie == null || traktMovie.ids == null) {
            return dirty;
        }
        MovieIds ids = traktMovie.ids;
        if (tmmMovie.getIdAsString("imdb").isEmpty() && !StringUtils.isEmpty((CharSequence)ids.imdb)) {
            tmmMovie.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt("tmdb") == 0 && MetadataUtil.unboxInteger(ids.tmdb) > 0) {
            tmmMovie.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt("trakt") == 0 && MetadataUtil.unboxInteger(ids.trakt) > 0) {
            tmmMovie.setId("trakt", ids.trakt);
            dirty = true;
        }
        return dirty;
    }

    private SyncMovie toSyncMovie(org.tinymediamanager.core.movie.entities.Movie tmmMovie, TraktTv.SyncType syncType) {
        boolean hasId = false;
        SyncMovie movie = null;
        MovieIds ids = new MovieIds();
        if (MetadataUtil.isValidImdbId(tmmMovie.getImdbId())) {
            ids.imdb = tmmMovie.getImdbId();
            hasId = true;
        }
        if (tmmMovie.getTmdbId() > 0) {
            ids.tmdb = tmmMovie.getTmdbId();
            hasId = true;
        }
        if (tmmMovie.getIdAsInt("trakt") > 0) {
            ids.trakt = tmmMovie.getIdAsInt("trakt");
            hasId = true;
        }
        if (!hasId) {
            return movie;
        }
        movie = new SyncMovie();
        movie.id(ids);
        switch (syncType) {
            case COLLECTION: {
                movie.collectedAt(OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)tmmMovie.getDateAdded()), (ZoneId)ZoneId.systemDefault()));
                break;
            }
            case WATCHED: {
                if (!tmmMovie.isWatched()) break;
                movie.watchedAt(OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneId.systemDefault()));
            }
        }
        movie.mediaType(TraktTv.getMediaType(tmmMovie.getMediaInfoSource()));
        movie.resolution(TraktTv.getResolution(tmmMovie.getMainVideoFile()));
        movie.hdr(TraktTv.getHdr(tmmMovie.getVideoHDRFormat()));
        movie.audio(TraktTv.getAudio(tmmMovie.getMediaInfoAudioCodec()));
        movie.audioChannels(TraktTv.getAudioChannels(tmmMovie.getMainVideoFile().getAudioChannelCount()));
        movie.is3d(Boolean.valueOf(tmmMovie.isVideoIn3D()));
        return movie;
    }

    private SyncMovie toSyncMovie(BaseMovie baseMovie) {
        return new SyncMovie().id(baseMovie.movie.ids).collectedAt(baseMovie.collected_at).watchedAt(baseMovie.last_watched_at);
    }
}

