/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.thirdparty.upnp.MimeTypes;

public class WebServer
extends NanoHTTPD {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServer.class);

    public WebServer(int port) throws IOException {
        super(port);
        this.start(5000, false);
        LOGGER.info("Webserver running on port {}", (Object)port);
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String[] path;
        String uri = session.getUri();
        LOGGER.info("Incoming: {} {} {}", new Object[]{session.getRemoteIpAddress(), session.getMethod(), uri});
        if (uri.startsWith("/upnp") && (path = StringUtils.split((String)uri, (char)'/')).length > 3) {
            try {
                UUID uuid = UUID.fromString(path[2]);
                MediaEntity m = null;
                if ("movies".equals(path[1])) {
                    m = MovieList.getInstance().lookupMovie(uuid);
                } else if ("tvshows".equals(path[1])) {
                    m = TvShowList.getInstance().lookupTvShow(uuid);
                }
                if (m != null) {
                    MediaFile mf = new MediaFile();
                    mf.setPath(m.getPathNIO().toString());
                    String fname = uri.substring(uri.indexOf(path[2]) + path[2].length() + 1);
                    String sanitized = FilenameUtils.normalize((String)fname);
                    if (sanitized != null) {
                        mf.setFilename(sanitized);
                        return this.serveFile(session, mf);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Seems not to be a valid MediaEntity", (Throwable)e);
            }
        }
        return WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"BAD REQUEST");
    }

    private NanoHTTPD.Response serveFile(NanoHTTPD.IHTTPSession session, MediaFile file) {
        NanoHTTPD.Response res;
        block22: {
            LOGGER.debug("Serving: {}", (Object)file.getFileAsPath());
            Map header = session.getHeaders();
            LOGGER.debug("Headers: {}", (Object)header);
            try {
                boolean headerIfNoneMatchPresentAndMatching;
                String ifRange;
                String mime = MimeTypes.getMimeTypeAsString(file.getExtension());
                long fileLen = Files.size(file.getFileAsPath());
                String etag = Integer.toHexString((file.getFileAsPath().toString() + Files.getLastModifiedTime(file.getFileAsPath(), new LinkOption[0]) + "" + fileLen).hashCode());
                long startFrom = 0L;
                long endAt = -1L;
                String range = (String)header.get("range");
                if (range != null && range.startsWith("bytes=")) {
                    range = range.substring("bytes=".length());
                    int minus = range.indexOf(45);
                    try {
                        if (minus > 0) {
                            startFrom = Long.parseLong(range.substring(0, minus));
                            endAt = Long.parseLong(range.substring(minus + 1));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                boolean headerIfRangeMissingOrMatching = (ifRange = (String)header.get("if-range")) == null || etag.equals(ifRange);
                String ifNoneMatch = (String)header.get("if-none-match");
                boolean bl = headerIfNoneMatchPresentAndMatching = ifNoneMatch != null && ("*".equals(ifNoneMatch) || ifNoneMatch.equals(etag));
                if (headerIfRangeMissingOrMatching && range != null && startFrom >= 0L && startFrom < fileLen) {
                    long newLen;
                    if (headerIfNoneMatchPresentAndMatching) {
                        res = WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, (String)mime, (String)"");
                        res.addHeader("ETag", etag);
                        break block22;
                    }
                    if (endAt < 0L) {
                        endAt = fileLen - 1L;
                    }
                    if ((newLen = endAt - startFrom + 1L) < 0L) {
                        newLen = 0L;
                    }
                    try (InputStream fis = Files.newInputStream(file.getFileAsPath(), new OpenOption[0]);){
                        fis.skip(startFrom);
                        res = WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.PARTIAL_CONTENT, (String)mime, (InputStream)fis, (long)newLen);
                        res.addHeader("Accept-Ranges", "bytes");
                        res.addHeader("Content-Length", "" + newLen);
                        res.addHeader("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                        res.addHeader("ETag", etag);
                        break block22;
                    }
                }
                if (headerIfRangeMissingOrMatching && range != null && startFrom >= fileLen) {
                    res = WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE, (String)"text/plain", (String)"");
                    res.addHeader("Content-Range", "bytes */" + fileLen);
                    res.addHeader("ETag", etag);
                } else if (range == null && headerIfNoneMatchPresentAndMatching) {
                    res = WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, (String)mime, (String)"");
                    res.addHeader("ETag", etag);
                } else if (!headerIfRangeMissingOrMatching && headerIfNoneMatchPresentAndMatching) {
                    res = WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, (String)mime, (String)"");
                    res.addHeader("ETag", etag);
                } else {
                    res = session.getMethod() == NanoHTTPD.Method.HEAD ? WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mime, null, (long)fileLen) : WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mime, (InputStream)Files.newInputStream(file.getFileAsPath(), new OpenOption[0]), (long)fileLen);
                    res.addHeader("Accept-Ranges", "bytes");
                    res.addHeader("Content-Length", "" + fileLen);
                    res.addHeader("ETag", etag);
                }
            }
            catch (IOException ioe) {
                LOGGER.error("Error reading file", (Throwable)ioe);
                res = WebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN, (String)"text/plain", (String)"FORBIDDEN: Reading file failed.");
            }
        }
        return res;
    }
}

