/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.sun.jna.Platform;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.tasks.UpdaterTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.tinymediamanager.ui.ITmmTabItem;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.LightBox;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TextFieldPopupMenu;
import org.tinymediamanager.ui.components.TmmSplitPane;
import org.tinymediamanager.ui.components.toolbar.ToolbarPanel;
import org.tinymediamanager.ui.dialogs.UpdateDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.panels.StatusBarPanel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class MainWindow
extends JFrame {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWindow.class);
    private static final long serialVersionUID = 1L;
    public static final List<Image> LOGOS = MainWindow.createLogos();
    private static MainWindow instance;
    private ToolbarPanel toolbarPanel;
    private JTabbedPane tabbedPane;
    private JPanel detailPanel;
    private JSplitPane splitPane;
    private JPanel panelStatusBar;

    public MainWindow(String name) {
        super(name);
        this.setName("mainWindow");
        this.setMinimumSize(new Dimension(1050, 700));
        instance = this;
        this.initialize();
        if (!Boolean.parseBoolean(System.getProperty("tmm.noupdate"))) {
            this.checkForUpdate(true);
        }
    }

    private static List<Image> createLogos() {
        ArrayList<Image> logos = new ArrayList<Image>();
        logos.add(new LogoCircle(48).getImage());
        logos.add(new LogoCircle(64).getImage());
        logos.add(new LogoCircle(96).getImage());
        logos.add(new LogoCircle(128).getImage());
        logos.add(new LogoCircle(256).getImage());
        return logos;
    }

    public void checkForUpdate(boolean useCache) {
        try {
            UpdaterTask updateWorker = new UpdaterTask(useCache);
            updateWorker.addPropertyChangeListener(evt -> {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    try {
                        boolean update = (Boolean)updateWorker.get();
                        LOGGER.debug("update result was: " + update);
                        if (update) {
                            if (updateWorker.isForcedUpdate()) {
                                LOGGER.info("Updating (forced)...");
                                this.closeTmmAndStart(Utils.getPBforTMMupdate());
                                return;
                            }
                            if (StringUtils.isNotBlank((CharSequence)updateWorker.getChangelog())) {
                                UpdateDialog dialog = new UpdateDialog(updateWorker.getChangelog());
                                dialog.setVisible(true);
                            } else {
                                Object[] options = new Object[]{BUNDLE.getString("Button.yes"), BUNDLE.getString("Button.no")};
                                int answer = JOptionPane.showOptionDialog(null, BUNDLE.getString("tmm.update.message"), BUNDLE.getString("tmm.update.title"), 0, 3, null, options, null);
                                if (answer == 0) {
                                    LOGGER.info("Updating...");
                                    this.closeTmmAndStart(Utils.getPBforTMMupdate());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Update task failed!" + e.getMessage());
                    }
                }
            });
            Timer timer = new Timer(5000, e -> updateWorker.execute());
            timer.setRepeats(false);
            timer.start();
        }
        catch (Exception e2) {
            LOGGER.error("Update task failed!" + e2.getMessage());
        }
    }

    private void initialize() {
        this.setIconImages(LOGOS);
        this.setBounds(5, 5, 1100, 727);
        this.setDefaultCloseOperation(0);
        this.toolbarPanel = new ToolbarPanel();
        this.getContentPane().add((Component)this.toolbarPanel, "North");
        JPanel rootPanel = new JPanel();
        rootPanel.putClientProperty("class", "rootPanel");
        rootPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[900lp:n,grow]", "[300lp:400lp,grow,shrink 0]0[shrink 0]"));
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(rootPanel, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        this.splitPane = new TmmSplitPane();
        rootPanel.add((Component)this.splitPane, "cell 0 0, grow");
        this.tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 9041548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        this.splitPane.setLeftComponent(this.tabbedPane);
        this.detailPanel = new JPanel();
        this.detailPanel.setOpaque(false);
        this.detailPanel.setLayout(new CardLayout(0, 0));
        this.splitPane.setRightComponent(this.detailPanel);
        this.panelStatusBar = new StatusBarPanel();
        rootPanel.add((Component)this.panelStatusBar, "cell 0 1,grow");
        this.addModule(MovieUIModule.getInstance());
        this.toolbarPanel.setUIModule(MovieUIModule.getInstance());
        this.addModule(MovieSetUIModule.getInstance());
        this.addModule(TvShowUIModule.getInstance());
        ChangeListener changeListener = changeEvent -> {
            JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (sourceTabbedPane.getSelectedComponent() instanceof ITmmTabItem) {
                ITmmTabItem activeTab = (ITmmTabItem)((Object)sourceTabbedPane.getSelectedComponent());
                this.toolbarPanel.setUIModule(activeTab.getUIModule());
                CardLayout cl = (CardLayout)this.detailPanel.getLayout();
                cl.show(this.detailPanel, activeTab.getUIModule().getModuleId());
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeTmm();
            }
        });
        MessageManager.instance.addListener(TmmUIMessageCollector.instance);
        Toolkit.getDefaultToolkit().addAWTEventListener(arg0 -> {
            if (arg0 instanceof MouseEvent && ((MouseEvent)arg0).isPopupTrigger() && arg0.getSource() instanceof JTextComponent) {
                MouseEvent me = (MouseEvent)arg0;
                JTextComponent tc = (JTextComponent)arg0.getSource();
                if (me.isPopupTrigger() && tc.getComponentPopupMenu() == null) {
                    TextFieldPopupMenu.buildCutCopyPaste().show(tc, me.getX(), me.getY());
                }
            }
        }, 16L);
        if (Platform.isLinux() && StringUtils.isBlank((CharSequence)MediaInfo.version())) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, BUNDLE.getString("mediainfo.failed.linux")));
        }
        for (ITmmModule module : TmmModuleManager.getInstance().getModules()) {
            if (module.getStartupMessages().isEmpty()) continue;
            for (String message : module.getStartupMessages()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, message));
            }
        }
    }

    private void addModule(ITmmUIModule module) {
        this.tabbedPane.addTab(module.getTabTitle(), module.getTabPanel());
        this.detailPanel.add((Component)module.getDetailPanel(), module.getModuleId());
    }

    public void closeTmm() {
        this.closeTmmAndStart(null);
    }

    public void closeTmmAndStart(ProcessBuilder pb) {
        int confirm = 0;
        if (TmmTaskManager.getInstance().poolRunning()) {
            Object[] options = new Object[]{BUNDLE.getString("Button.yes"), BUNDLE.getString("Button.no")};
            confirm = JOptionPane.showOptionDialog(null, BUNDLE.getString("tmm.exit.runningtasks"), BUNDLE.getString("tmm.exit.confirmation"), 0, 3, null, options, null);
        }
        if (confirm == 0) {
            LOGGER.info("bye bye");
            try {
                TmmTaskManager.getInstance().shutdown();
                TmmModuleManager.getInstance().saveSettings();
                TmmTaskManager.getInstance().shutdownNow();
                TmmModuleManager.getInstance().shutDown();
            }
            catch (Exception ex) {
                LOGGER.warn("", (Throwable)ex);
            }
            this.dispose();
            if (pb != null) {
                try {
                    LOGGER.info("Going to execute: " + pb.command());
                    pb.start();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot spawn process:", (Throwable)e);
                }
            }
            TinyMediaManager.shutdownLogger();
            System.exit(0);
        }
    }

    JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public static MainWindow getActiveInstance() {
        return instance;
    }

    public static JFrame getFrame() {
        return instance;
    }

    public void createLightbox(String pathToFile, String urlToFile) {
        LightBox.showLightBox(instance, pathToFile, urlToFile);
    }
}

