/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;

public class ScraperInTable
extends AbstractModelObject {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    protected MediaScraper scraper;
    protected Icon scraperLogo;
    protected boolean active;

    public ScraperInTable(MediaScraper scraper) {
        this.scraper = scraper;
        this.scraperLogo = scraper.getMediaProvider() == null || scraper.getMediaProvider().getProviderInfo() == null || scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
    }

    protected ImageIcon getScaledIcon(ImageIcon original) {
        try {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(new JPanel().getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = !this.scraper.isEnabled() ? Scalr.resize((BufferedImage)ImageUtils.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_GRAYSCALE}) : Scalr.resize((BufferedImage)ImageUtils.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getScraperId() {
        return this.scraper.getId();
    }

    public String getScraperName() {
        if (StringUtils.isNotBlank((CharSequence)this.scraper.getVersion())) {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }
        return this.scraper.getName();
    }

    public String getScraperDescription() {
        String description = null;
        try {
            description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(description)) {
            description = this.scraper.getDescription();
        }
        return description;
    }

    public Icon getScraperLogo() {
        return this.scraperLogo;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean newValue) {
        Boolean oldValue = this.active;
        this.active = newValue;
        this.firePropertyChange("active", oldValue, newValue);
    }

    public IMediaProvider getMediaProvider() {
        return this.scraper.getMediaProvider();
    }
}

