/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;

public class CreateDesktopFileAction
extends TmmAction {
    private static final long serialVersionUID = 1668251251156765161L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDesktopFileAction.class);

    public CreateDesktopFileAction() {
        this.putValue("Name", BUNDLE.getString("tmm.createdesktopentry"));
        this.putValue("ShortDescription", BUNDLE.getString("tmm.createdesktopentry.hint"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path desktopFile;
        String currentUsersHomeDir = System.getProperty("user.home");
        if (StringUtils.isNotBlank((CharSequence)currentUsersHomeDir) && Files.isWritable((desktopFile = Paths.get(currentUsersHomeDir, ".local", "share", "applications", "tinyMediaManager2.desktop")).getParent())) {
            TmmOsUtils.createDesktopFileForLinux(desktopFile.toFile());
        }
    }
}

