/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class DocsAction
extends TmmAction {
    private static final long serialVersionUID = 1668251251156765161L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(DocsAction.class);

    public DocsAction() {
        this.putValue("Name", BUNDLE.getString("tmm.docs"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs");
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception e1) {
            LOGGER.error("FAQ", (Throwable)e1);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
        }
    }
}

