/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.actions.TmmAction;

public class RebuildImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = -9178351750617647813L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public RebuildImageCacheAction() {
        this.putValue("Name", BUNDLE.getString("tmm.rebuildimagecache"));
        this.putValue("ShortDescription", BUNDLE.getString("tmm.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Globals.settings.isImageCache()) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("tmm.imagecache.notactivated"));
            return;
        }
        ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
        ArrayList<Movie> movies = new ArrayList<Movie>(MovieList.getInstance().getMovies());
        for (Movie movie : movies) {
            imageFiles.addAll(movie.getImagesToCache());
        }
        ArrayList<MovieSet> movieSets = new ArrayList<MovieSet>(MovieList.getInstance().getMovieSetList());
        for (MovieSet movieSet : movieSets) {
            imageFiles.addAll(movieSet.getImagesToCache());
        }
        ArrayList<TvShow> arrayList = new ArrayList<TvShow>(TvShowList.getInstance().getTvShows());
        for (TvShow tvShow : arrayList) {
            imageFiles.addAll(tvShow.getImagesToCache());
        }
        ImageCacheTask imageCacheTask = new ImageCacheTask(imageFiles);
        TmmTaskManager.getInstance().addUnnamedTask(imageCacheTask);
    }
}

