/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.tinymediamanager.ui.IconManager;

public class PopupMenuScroller {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;
    private int keepVisibleIndex = -1;

    public static PopupMenuScroller setScrollerFor(JPopupMenu menu) {
        return new PopupMenuScroller(menu);
    }

    public static PopupMenuScroller setScrollerFor(JPopupMenu menu, int scrollCount) {
        return new PopupMenuScroller(menu, scrollCount);
    }

    public static PopupMenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval) {
        return new PopupMenuScroller(menu, scrollCount, interval);
    }

    public static PopupMenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new PopupMenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public PopupMenuScroller(JPopupMenu menu) {
        this(menu, 15);
    }

    public PopupMenuScroller(JPopupMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public PopupMenuScroller(JPopupMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public PopupMenuScroller(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        if (scrollCount <= 0 || interval <= 0) {
            throw new IllegalArgumentException("scrollCount and interval must be greater than 0");
        }
        if (topFixedCount < 0 || bottomFixedCount < 0) {
            throw new IllegalArgumentException("topFixedCount and bottomFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(IconManager.CARET_UP, -1);
        this.downItem = new MenuScrollItem(IconManager.CARET_DOWN, 1);
        this.setScrollCount(scrollCount);
        this.setInterval(interval);
        this.setTopFixedCount(topFixedCount);
        this.setBottomFixedCount(bottomFixedCount);
        this.menu = menu;
        menu.addPopupMenuListener(this.menuListener);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(interval);
        this.downItem.setInterval(interval);
        this.interval = interval;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public void setScrollCount(int scrollCount) {
        if (scrollCount <= 0) {
            throw new IllegalArgumentException("scrollCount must be greater than 0");
        }
        this.scrollCount = scrollCount;
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int topFixedCount) {
        this.firstIndex = this.firstIndex <= topFixedCount ? topFixedCount : (this.firstIndex += topFixedCount - this.topFixedCount);
        this.topFixedCount = topFixedCount;
    }

    public int getBottomFixedCount() {
        return this.bottomFixedCount;
    }

    public void setBottomFixedCount(int bottomFixedCount) {
        this.bottomFixedCount = bottomFixedCount;
    }

    public void keepVisible(JMenuItem item) {
        int index;
        this.keepVisibleIndex = item == null ? -1 : (index = this.menu.getComponentIndex(item));
    }

    public void keepVisible(int index) {
        this.keepVisibleIndex = index;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.menuListener);
            this.menu = null;
        }
    }

    public void finalize() {
        this.dispose();
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int i;
            this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
            this.firstIndex = Math.min(this.menuItems.length - this.bottomFixedCount - this.scrollCount, this.firstIndex);
            this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
            this.downItem.setEnabled(this.firstIndex + this.scrollCount < this.menuItems.length - this.bottomFixedCount);
            this.menu.removeAll();
            for (i = 0; i < this.topFixedCount; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            if (this.topFixedCount > 0) {
                this.menu.addSeparator();
            }
            this.menu.add(this.upItem);
            for (i = this.firstIndex; i < this.scrollCount + this.firstIndex; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            this.menu.add(this.downItem);
            if (this.bottomFixedCount > 0) {
                this.menu.addSeparator();
            }
            for (i = this.menuItems.length - this.bottomFixedCount; i < this.menuItems.length; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            JComponent parent = (JComponent)this.upItem.getParent();
            parent.revalidate();
            parent.repaint();
        }
    }

    static /* synthetic */ Component[] access$102(PopupMenuScroller x0, Component[] x1) {
        x0.menuItems = x1;
        return x1;
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        MenuScrollItem(ImageIcon icon, int increment) {
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            this.setHorizontalAlignment(0);
            this.timer = new MenuScrollTimer(increment, PopupMenuScroller.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int interval) {
            this.timer.setDelay(interval);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollTimer
    extends Timer {
        MenuScrollTimer(final int increment, int interval) {
            super(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenuScroller.this.firstIndex += increment;
                    PopupMenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            PopupMenuScroller.access$102(PopupMenuScroller.this, PopupMenuScroller.this.menu.getComponents());
            if (PopupMenuScroller.this.keepVisibleIndex >= PopupMenuScroller.this.topFixedCount && PopupMenuScroller.this.keepVisibleIndex <= PopupMenuScroller.this.menuItems.length - PopupMenuScroller.this.bottomFixedCount && (PopupMenuScroller.this.keepVisibleIndex > PopupMenuScroller.this.firstIndex + PopupMenuScroller.this.scrollCount || PopupMenuScroller.this.keepVisibleIndex < PopupMenuScroller.this.firstIndex)) {
                PopupMenuScroller.this.firstIndex = Math.min(PopupMenuScroller.this.firstIndex, PopupMenuScroller.this.keepVisibleIndex);
                PopupMenuScroller.this.firstIndex = Math.max(PopupMenuScroller.this.firstIndex, PopupMenuScroller.this.keepVisibleIndex - PopupMenuScroller.this.scrollCount + 1);
            }
            if (PopupMenuScroller.this.menuItems.length > PopupMenuScroller.this.topFixedCount + PopupMenuScroller.this.scrollCount + PopupMenuScroller.this.bottomFixedCount) {
                PopupMenuScroller.this.refreshMenu();
            }
        }

        private void restoreMenuItems() {
            PopupMenuScroller.this.menu.removeAll();
            for (Component component : PopupMenuScroller.this.menuItems) {
                PopupMenuScroller.this.menu.add(component);
            }
        }
    }
}

