/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.ui.IconManager;

public class StarRater
extends JPanel {
    private static final long serialVersionUID = -5601531605019166004L;
    private static final Image STAR_BACKGROUND_IMAGE = ImageUtils.createImage(IconManager.STAR_EMPTY.getImage());
    private static final Image STAR_FOREGROUND_IMAGE = ImageUtils.createImage(IconManager.STAR_FILLED.getImage());
    private List<StarListener> listeners = new ArrayList<StarListener>();
    private int stars;
    private int factor;
    private float rating;
    private float paintRating;
    private int selection;
    private int rollover;
    private boolean done;

    public StarRater() {
        this(5, 1);
    }

    public StarRater(int stars, int factor) {
        this(stars, factor, 0.0f);
    }

    public StarRater(int stars, int factor, float rating) {
        this(stars, factor, rating, 0);
    }

    public StarRater(int stars, int factor, float rating, int selection) {
        this.stars = stars;
        this.rating = rating;
        this.selection = selection;
        this.factor = factor > 0 ? factor : 1;
        this.paintRating = this.rating / (float)this.factor;
        this.rollover = 0;
        this.done = false;
        this.setOpaque(false);
        this.setLayout(null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                if (StarRater.this.isEnabled() && !StarRater.this.done) {
                    StarRater.this.rollover = 1 + event.getX() / STAR_BACKGROUND_IMAGE.getWidth(null);
                    StarRater.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent event) {
                if (StarRater.this.isEnabled()) {
                    StarRater.this.rollover = 0;
                    StarRater.this.done = false;
                    StarRater.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (StarRater.this.isEnabled()) {
                    StarRater.this.rollover = 0;
                    StarRater.this.done = true;
                    StarRater.this.selection = 1 + event.getX() / STAR_FOREGROUND_IMAGE.getWidth(null);
                    for (StarListener listener : StarRater.this.listeners) {
                        listener.handleSelection(StarRater.this.selection);
                    }
                    StarRater.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (StarRater.this.isEnabled() && !StarRater.this.done) {
                    StarRater.this.rollover = 1 + event.getX() / STAR_BACKGROUND_IMAGE.getWidth(null);
                    StarRater.this.repaint();
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.rollover = 0;
            this.repaint();
        }
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
        this.paintRating = this.rating / (float)this.factor;
        this.repaint();
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.stars * STAR_BACKGROUND_IMAGE.getWidth(null), STAR_BACKGROUND_IMAGE.getHeight(null));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.rating >= 0.0f) {
            int w = STAR_BACKGROUND_IMAGE.getWidth(null);
            int h = STAR_BACKGROUND_IMAGE.getHeight(null);
            int x = 0;
            for (int i = 0; i < this.stars; ++i) {
                g.drawImage(STAR_BACKGROUND_IMAGE, x, 0, null);
                if (this.paintRating > (float)i) {
                    int dw = this.paintRating >= (float)(i + 1) ? w : Math.round((this.paintRating - (float)i) * (float)w);
                    g.drawImage(STAR_FOREGROUND_IMAGE, x, 0, x + dw, h, 0, 0, dw, h, null);
                }
                x += w;
            }
        }
    }

    public void addStarListener(StarListener listener) {
        this.listeners.add(listener);
    }

    public void removeStarListener(StarListener listener) {
        this.listeners.remove(listener);
    }

    public static interface StarListener {
        public void handleSelection(int var1);
    }
}

