/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;

public class MediaScraperCheckComboBox
extends TmmCheckComboBox<MediaScraper> {
    private static final long serialVersionUID = 8153649858409237947L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaScraperCheckComboBox.class);

    public MediaScraperCheckComboBox(List<MediaScraper> scrapers) {
        super(scrapers);
    }

    @Override
    protected void setRenderer() {
        this.setRenderer(new MediaScraperCheckBoxRenderer(this.checkBoxes));
    }

    private class MediaScraperCheckBoxRenderer
    extends TmmCheckComboBox.CheckBoxRenderer {
        private JPanel panel;
        private JCheckBox checkBox;
        private JLabel label;
        private Map<URI, ImageIcon> imageCache;
        private int maxIconWidth;

        private MediaScraperCheckBoxRenderer(List<TmmCheckComboBoxItem<MediaScraper>> items) {
            super(items);
            this.panel = new JPanel();
            this.checkBox = new JCheckBox();
            this.label = new JLabel();
            this.maxIconWidth = 0;
            this.panel.setLayout(new FlowLayout(0));
            this.panel.add(this.checkBox);
            this.panel.add(this.label);
            this.label.setOpaque(false);
            this.checkBox.setOpaque(false);
            this.imageCache = new HashMap<URI, ImageIcon>();
            for (TmmCheckComboBoxItem item : items) {
                ImageIcon logo;
                if (item.getUserObject() == null || (logo = this.getIcon(((MediaScraper)item.getUserObject()).getLogoURL())) == null) continue;
                this.maxIconWidth = Math.max(this.maxIconWidth, logo.getIconWidth());
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TmmCheckComboBoxItem<MediaScraper>> list, TmmCheckComboBoxItem<MediaScraper> value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            if (index > 0 && index <= this.checkBoxes.size()) {
                TmmCheckComboBoxItem cb = (TmmCheckComboBoxItem)this.checkBoxes.get(index - 1);
                if (isSelected) {
                    this.panel.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.panel.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.panel.setBackground(UIManager.getColor("ComboBox.background"));
                    this.panel.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                this.label.setText(cb.getText());
                this.checkBox.setSelected(cb.isSelected());
                MediaScraper scraper = (MediaScraper)cb.getUserObject();
                if (scraper != null) {
                    int currentWidth = 0;
                    ImageIcon logo = this.getIcon(scraper.getLogoURL());
                    if (logo != null) {
                        currentWidth = logo.getIconWidth();
                    }
                    this.label.setIcon(logo);
                    this.label.setIconTextGap(this.maxIconWidth + 4 - currentWidth);
                } else {
                    this.label.setIcon(null);
                    this.label.setIconTextGap(4);
                }
                return this.panel;
            }
            List objs = MediaScraperCheckComboBox.this.getSelectedItems();
            Vector<String> strs = new Vector<String>();
            if (objs.isEmpty()) {
                str = TmmCheckComboBox.BUNDLE.getString("ComboBox.select.mediascraper");
            } else {
                for (Object obj : objs) {
                    strs.add(obj.toString());
                }
                str = strs.toString();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, str, index, isSelected, cellHasFocus);
        }

        private ImageIcon getIcon(URL url) {
            try {
                URI uri = url.toURI();
                ImageIcon logo = this.imageCache.get(uri);
                if (logo == null) {
                    logo = this.getScaledIcon(IconManager.loadImageFromURL(url));
                    this.imageCache.put(uri, logo);
                }
                return logo;
            }
            catch (Exception e) {
                LOGGER.debug("could not load scraper icon: {}", (Object)e.getMessage());
                return null;
            }
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(MediaScraperCheckComboBox.this.getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageUtils.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }
    }
}

