/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.AboutAction;
import org.tinymediamanager.ui.actions.BugReportAction;
import org.tinymediamanager.ui.actions.ClearHttpCacheAction;
import org.tinymediamanager.ui.actions.ClearImageCacheAction;
import org.tinymediamanager.ui.actions.CreateDesktopFileAction;
import org.tinymediamanager.ui.actions.DocsAction;
import org.tinymediamanager.ui.actions.ExportLogAction;
import org.tinymediamanager.ui.actions.FaqAction;
import org.tinymediamanager.ui.actions.FeedbackAction;
import org.tinymediamanager.ui.actions.ForumAction;
import org.tinymediamanager.ui.actions.HomepageAction;
import org.tinymediamanager.ui.actions.LaunchUpdaterAction;
import org.tinymediamanager.ui.actions.RebuildImageCacheAction;
import org.tinymediamanager.ui.actions.SettingsAction;
import org.tinymediamanager.ui.actions.ShowChangelogAction;
import org.tinymediamanager.ui.actions.UpgradeAction;
import org.tinymediamanager.ui.components.toolbar.ToolbarButton;
import org.tinymediamanager.ui.components.toolbar.ToolbarLabel;
import org.tinymediamanager.ui.components.toolbar.ToolbarMenu;
import org.tinymediamanager.ui.dialogs.FullLogDialog;
import org.tinymediamanager.ui.dialogs.LogDialog;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;

public class ToolbarPanel
extends JPanel {
    private static final long serialVersionUID = 7969400170662870244L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolbarPanel.class);
    private ToolbarButton btnSearch;
    private ToolbarButton btnEdit;
    private ToolbarButton btnUpdate;
    private ToolbarButton btnRename;
    private ToolbarMenu menuUpdate;
    private ToolbarMenu menuSearch;
    private ToolbarMenu menuEdit;
    private ToolbarMenu menuRename;

    public ToolbarPanel() {
        this.putClientProperty("class", "toolbarPanel");
        this.setLayout(new BorderLayout());
        JPanel panelCenter = new JPanel();
        this.add((Component)panelCenter, "Center");
        panelCenter.setOpaque(false);
        panelCenter.setLayout((LayoutManager)new MigLayout("insets 0", "[5lp:n][]20lp[]20lp[]20lp[]20lp[][grow][]15lp[]15lp[]15lp[]15lp[][5lp:n]", "[]1lp[]5lp"));
        panelCenter.add((Component)new JLabel(IconManager.TOOLBAR_LOGO), "cell 1 0 1 2,alignx center");
        this.btnUpdate = new ToolbarButton(IconManager.TOOLBAR_REFRESH, (Icon)IconManager.TOOLBAR_REFRESH_HOVER);
        panelCenter.add((Component)this.btnUpdate, "cell 2 0,alignx center");
        this.btnSearch = new ToolbarButton(IconManager.TOOLBAR_SEARCH, (Icon)IconManager.TOOLBAR_SEARCH_HOVER);
        panelCenter.add((Component)this.btnSearch, "cell 3 0,alignx center");
        this.btnEdit = new ToolbarButton(IconManager.TOOLBAR_EDIT, (Icon)IconManager.TOOLBAR_EDIT_HOVER);
        panelCenter.add((Component)this.btnEdit, "cell 4 0,alignx center");
        this.btnRename = new ToolbarButton(IconManager.TOOLBAR_RENAME, (Icon)IconManager.TOOLBAR_RENAME_HOVER);
        panelCenter.add((Component)this.btnRename, "cell 5 0,alignx center");
        ToolbarButton btnSettings = new ToolbarButton(IconManager.TOOLBAR_SETTINGS, (Icon)IconManager.TOOLBAR_SETTINGS_HOVER);
        SettingsAction settingsAction = new SettingsAction();
        ((AbstractButton)btnSettings).setAction(settingsAction);
        panelCenter.add((Component)btnSettings, "cell 8 0,alignx center,aligny bottom");
        JPopupMenu toolsPopupMenu = this.buildToolsMenu();
        ToolbarButton btnTools = new ToolbarButton(IconManager.TOOLBAR_TOOLS, IconManager.TOOLBAR_TOOLS_HOVER, toolsPopupMenu);
        panelCenter.add((Component)btnTools, "cell 9 0,alignx center,aligny bottom");
        JPopupMenu infoPopupMenu = this.buildInfoMenu();
        ToolbarButton btnInfo = new ToolbarButton(IconManager.TOOLBAR_ABOUT, IconManager.TOOLBAR_ABOUT_HOVER, infoPopupMenu);
        panelCenter.add((Component)btnInfo, "cell 10 0,alignx center,aligny bottom");
        ToolbarButton btnUpgrade = new ToolbarButton(IconManager.TOOLBAR_UPGRADE, (Icon)IconManager.TOOLBAR_UPGRADE);
        UpgradeAction upgradeAction = new UpgradeAction();
        ((AbstractButton)btnUpgrade).setAction(upgradeAction);
        panelCenter.add((Component)btnUpgrade, "cell 11 0,alignx center,aligny bottom");
        this.menuUpdate = new ToolbarMenu(BUNDLE.getString("Toolbar.update"));
        panelCenter.add((Component)this.menuUpdate, "cell 2 1,alignx center, wmin 0");
        this.menuSearch = new ToolbarMenu(BUNDLE.getString("Toolbar.search"));
        panelCenter.add((Component)this.menuSearch, "cell 3 1,alignx center, wmin 0");
        this.menuEdit = new ToolbarMenu(BUNDLE.getString("Toolbar.edit"));
        panelCenter.add((Component)this.menuEdit, "cell 4 1,alignx center, wmin 0");
        this.menuRename = new ToolbarMenu(BUNDLE.getString("Toolbar.rename"));
        panelCenter.add((Component)this.menuRename, "cell 5 1,alignx center, wmin 0");
        ToolbarLabel lblSettings = new ToolbarLabel(BUNDLE.getString("Toolbar.settings"), settingsAction);
        panelCenter.add((Component)lblSettings, "cell 8 1,alignx center, wmin 0");
        ToolbarMenu lblTools = new ToolbarMenu(BUNDLE.getString("Toolbar.tools"), toolsPopupMenu);
        panelCenter.add((Component)lblTools, "cell 9 1,alignx center, wmin 0");
        ToolbarMenu menuHelp = new ToolbarMenu(BUNDLE.getString("Toolbar.help"), infoPopupMenu);
        panelCenter.add((Component)menuHelp, "cell 10 1,alignx center, wmin 0");
        ToolbarLabel lblUpgrade = new ToolbarLabel(BUNDLE.getString("tmm.upgradev4"), upgradeAction);
        panelCenter.add((Component)lblUpgrade, "cell 11 1,alignx center, wmin 0");
        JPanel panelEast = new JPanel();
        this.add((Component)panelEast, "East");
        panelEast.setOpaque(false);
        panelEast.setLayout((LayoutManager)new MigLayout("insets 0", "[]", "[grow]"));
    }

    public void setUIModule(ITmmUIModule module) {
        this.btnUpdate.setAction(module.getUpdateAction());
        this.btnUpdate.setIcons(module.getSearchButtonIcon(), module.getSearchButtonHoverIcon());
        this.menuUpdate.setPopupMenu(module.getUpdateMenu());
        this.btnSearch.setAction(module.getSearchAction());
        this.menuSearch.setPopupMenu(module.getSearchMenu());
        this.btnEdit.setAction(module.getEditAction());
        this.menuEdit.setPopupMenu(module.getEditMenu());
        this.btnRename.setAction(module.getRenameAction());
        this.menuRename.setPopupMenu(module.getRenameMenu());
    }

    private JPopupMenu buildToolsMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new ClearImageCacheAction());
        menu.add(new RebuildImageCacheAction());
        menu.add(new ClearHttpCacheAction());
        menu.addSeparator();
        JMenuItem tmmLogs = new JMenuItem(BUNDLE.getString("tmm.errorlogs"));
        menu.add(tmmLogs);
        tmmLogs.addActionListener(arg0 -> {
            LogDialog logDialog = new LogDialog();
            logDialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            ((Dialog)logDialog).setVisible(true);
        });
        JMenuItem tmmMessages = new JMenuItem(BUNDLE.getString("tmm.messages"));
        tmmMessages.setMnemonic(76);
        menu.add(tmmMessages);
        tmmMessages.addActionListener(arg0 -> {
            MessageHistoryDialog messageDialog = MessageHistoryDialog.getInstance();
            ((Dialog)messageDialog).setVisible(true);
        });
        JMenuItem tmmFolder = new JMenuItem(BUNDLE.getString("tmm.gotoinstalldir"));
        menu.add(tmmFolder);
        tmmFolder.addActionListener(arg0 -> {
            Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    TmmUIHelper.openFile(path);
                }
            }
            catch (Exception ex) {
                LOGGER.error("open filemanager", (Throwable)ex);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        menu.addSeparator();
        final JMenu menuWakeOnLan = new JMenu(BUNDLE.getString("tmm.wakeonlan"));
        menuWakeOnLan.setMnemonic(87);
        menuWakeOnLan.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuSelected(MenuEvent arg0) {
                menuWakeOnLan.removeAll();
                for (WolDevice device : Globals.settings.getWolDevices()) {
                    JMenuItem item = new JMenuItem(device.getName());
                    item.addActionListener(arg01 -> Utils.sendWakeOnLanPacket(device.getMacAddress()));
                    menuWakeOnLan.add(item);
                }
            }
        });
        menu.add(menuWakeOnLan);
        if (!Boolean.parseBoolean(System.getProperty("tmm.noupdate"))) {
            menu.addSeparator();
            menu.add(new LaunchUpdaterAction());
        }
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            JMenuItem trace = new JMenuItem("set Console Logger to TRACE");
            trace.addActionListener(arg0 -> {
                System.setProperty("tmm.consoleloglevel", "TRACE");
                TinyMediaManager.setConsoleLogLevel();
                MessageManager.instance.pushMessage(new Message("Trace levels set!", "Test"));
                LOGGER.trace("if you see that, we're now on TRACE logging level ;)");
            });
            debugMenu.add(trace);
            JMenuItem traceLogs = new JMenuItem("Show all logs from this session");
            debugMenu.add(traceLogs);
            traceLogs.addActionListener(arg0 -> {
                FullLogDialog logDialog = new FullLogDialog();
                logDialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                ((Dialog)logDialog).setVisible(true);
            });
            menu.addSeparator();
            menu.add(debugMenu);
        }
        final JMenu kodiRPCMenu = KodiRPCMenu.KodiMenuTop();
        menu.add(kodiRPCMenu);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (!Globals.settings.getWolDevices().isEmpty()) {
                    menuWakeOnLan.setEnabled(true);
                } else {
                    menuWakeOnLan.setEnabled(false);
                }
                kodiRPCMenu.setText(KodiRPC.getInstance().getVersion());
                if (KodiRPC.getInstance().isConnected()) {
                    kodiRPCMenu.setEnabled(true);
                } else {
                    kodiRPCMenu.setEnabled(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        menu.addSeparator();
        menu.add(new BugReportAction());
        menu.add(new ExportLogAction());
        if (SystemUtils.IS_OS_LINUX) {
            menu.addSeparator();
            menu.add(new CreateDesktopFileAction());
        }
        return menu;
    }

    private JPopupMenu buildInfoMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new FaqAction());
        menu.add(new DocsAction());
        menu.add(new ForumAction());
        menu.add(new ShowChangelogAction());
        menu.addSeparator();
        menu.add(new BugReportAction());
        menu.add(new FeedbackAction());
        menu.addSeparator();
        menu.add(new HomepageAction());
        menu.add(new AboutAction());
        return menu;
    }
}

