/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.interfaces.IMediaArtworkProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.ToggleButtonUI;
import org.tinymediamanager.ui.UIConstants;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImageChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = 8193355920006275933L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageChooserDialog.class);
    private static final String DIALOG_ID = "imageChooser";
    private static final Insets BUTTON_MARGIN = UIConstants.SMALL_BUTTON_MARGIN;
    private Map<String, Object> ids;
    private ImageType type;
    private MediaType mediaType;
    private ImageLabel imageLabel;
    private List<String> extraThumbs;
    private List<String> extraFanarts;
    private List<MediaScraper> artworkScrapers;
    private JProgressBar progressBar;
    private JLabel lblProgressAction;
    private JPanel panelImages;
    private JScrollPane scrollPane;
    private LockableViewPort viewport;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private List<JToggleButton> buttons = new ArrayList<JToggleButton>();
    private JTextField tfImageUrl;
    private ToggleButtonUI toggleButtonUI = new ToggleButtonUI();
    private DownloadTask task;

    public ImageChooserDialog(Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, MediaType mediaType) {
        this(ids, type, artworkScrapers, imageLabel, new ArrayList<String>(), new ArrayList<String>(), mediaType);
    }

    public ImageChooserDialog(Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType) {
        super("", DIALOG_ID);
        this.imageLabel = imageLabel;
        this.type = type;
        this.mediaType = mediaType;
        this.extraThumbs = extraThumbs;
        this.extraFanarts = extraFanarts;
        this.ids = ids;
        this.artworkScrapers = artworkScrapers;
        this.init();
    }

    public ImageChooserDialog(JDialog parent, Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, MediaType mediaType) {
        this(parent, ids, type, artworkScrapers, imageLabel, new ArrayList<String>(), new ArrayList<String>(), mediaType);
    }

    public ImageChooserDialog(JDialog parent, Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType) {
        super(parent, "", DIALOG_ID);
        this.imageLabel = imageLabel;
        this.type = type;
        this.mediaType = mediaType;
        this.extraThumbs = extraThumbs;
        this.extraFanarts = extraFanarts;
        this.ids = ids;
        this.artworkScrapers = artworkScrapers;
        this.init();
    }

    private void init() {
        switch (this.type) {
            case FANART: {
                this.setTitle(BUNDLE.getString("image.choose.fanart"));
                break;
            }
            case POSTER: {
                this.setTitle(BUNDLE.getString("image.choose.poster"));
                break;
            }
            case BANNER: {
                this.setTitle(BUNDLE.getString("image.choose.banner"));
                break;
            }
            case SEASON_POSTER: 
            case SEASON_BANNER: 
            case SEASON_THUMB: {
                Object season = this.ids.get("tvShowSeason");
                if (season != null) {
                    this.setTitle(BUNDLE.getString("image.choose.season") + " - " + BUNDLE.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(BUNDLE.getString("image.choose.season"));
                break;
            }
            case CLEARART: {
                this.setTitle(BUNDLE.getString("image.choose.clearart"));
                break;
            }
            case DISC: {
                this.setTitle(BUNDLE.getString("image.choose.disc"));
                break;
            }
            case LOGO: {
                this.setTitle(BUNDLE.getString("image.choose.logo"));
                break;
            }
            case CLEARLOGO: {
                this.setTitle(BUNDLE.getString("image.choose.clearlogo"));
                break;
            }
            case CHARACTERART: {
                this.setTitle(BUNDLE.getString("image.choose.characterart"));
                break;
            }
            case THUMB: {
                this.setTitle(BUNDLE.getString("image.choose.thumb"));
                break;
            }
            case KEYART: {
                this.setTitle(BUNDLE.getString("image.choose.keyart"));
            }
        }
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("hidemode 1", "[850lp,grow][]", "[500lp,grow][shrink 0][][][]"));
        this.scrollPane = new JScrollPane();
        this.viewport = new LockableViewPort();
        this.scrollPane.setViewport(this.viewport);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        contentPanel.add((Component)this.scrollPane, "cell 0 0 2 1,grow");
        this.panelImages = new JPanel();
        this.viewport.setView(this.panelImages);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panelImages.setLayout(new WrapLayout(0));
        JSeparator separator = new JSeparator();
        contentPanel.add((Component)separator, "cell 0 1 2 1,growx");
        this.tfImageUrl = new EnhancedTextField(BUNDLE.getString("image.inserturl"));
        contentPanel.add((Component)this.tfImageUrl, "cell 0 2,growx");
        this.tfImageUrl.setColumns(10);
        JButton btnAddImage = new JButton(BUNDLE.getString("image.downloadimage"));
        btnAddImage.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.tfImageUrl.getText())) {
                this.downloadAndPreviewImage(this.tfImageUrl.getText());
            }
        });
        contentPanel.add((Component)btnAddImage, "cell 1 2");
        if (this.type == ImageType.FANART && this.extraThumbs != null) {
            JLabel labelThumbs = new JLabel("Extrathumbs:");
            contentPanel.add((Component)labelThumbs, "flowx,cell 0 2");
            JButton btnMarkExtrathumbs = new JButton("");
            contentPanel.add((Component)btnMarkExtrathumbs, "cell 0 2");
            btnMarkExtrathumbs.setMargin(BUTTON_MARGIN);
            btnMarkExtrathumbs.setIcon(IconManager.CHECK_ALL);
            btnMarkExtrathumbs.setToolTipText(BUNDLE.getString("image.extrathumbs.markall"));
            btnMarkExtrathumbs.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb");
                    chkbx.setSelected(true);
                }
            });
            JButton btnUnMarkExtrathumbs = new JButton("");
            contentPanel.add((Component)btnUnMarkExtrathumbs, "cell 0 2");
            btnUnMarkExtrathumbs.setMargin(BUTTON_MARGIN);
            btnUnMarkExtrathumbs.setIcon(IconManager.CLEAR_ALL);
            btnUnMarkExtrathumbs.setToolTipText(BUNDLE.getString("image.extrathumbs.unmarkall"));
            btnUnMarkExtrathumbs.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb");
                    chkbx.setSelected(false);
                }
            });
        }
        if (this.type == ImageType.FANART && this.extraFanarts != null) {
            JLabel labelFanart = new JLabel("Extrafanart:");
            contentPanel.add((Component)labelFanart, "flowx,cell 0 3");
            JButton btnMarkExtrafanart = new JButton("");
            contentPanel.add((Component)btnMarkExtrafanart, "cell 0 3");
            btnMarkExtrafanart.setMargin(BUTTON_MARGIN);
            btnMarkExtrafanart.setIcon(IconManager.CHECK_ALL);
            btnMarkExtrafanart.setToolTipText(BUNDLE.getString("image.extrafanart.markall"));
            JButton btnUnMarkExtrafanart = new JButton("");
            contentPanel.add((Component)btnUnMarkExtrafanart, "cell 0 3");
            btnUnMarkExtrafanart.setMargin(BUTTON_MARGIN);
            btnUnMarkExtrafanart.setIcon(IconManager.CLEAR_ALL);
            btnUnMarkExtrafanart.setToolTipText(BUNDLE.getString("image.extrafanart.unmarkall"));
            btnUnMarkExtrafanart.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart");
                    chkbx.setSelected(false);
                }
            });
            btnMarkExtrafanart.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart");
                    chkbx.setSelected(true);
                }
            });
        }
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        CancelAction actionCancel = new CancelAction();
        cancelButton.setAction(actionCancel);
        cancelButton.setActionCommand("Cancel");
        this.addButton(cancelButton);
        JButton btnAddFile = new JButton(BUNDLE.getString("Button.addfile"));
        LocalFileChooseAction actionLocalFile = new LocalFileChooseAction();
        btnAddFile.setAction(actionLocalFile);
        this.addButton(btnAddFile);
        JButton okButton = new JButton(BUNDLE.getString("Button.ok"));
        OkAction actionOK = new OkAction();
        okButton.setAction(actionOK);
        okButton.setActionCommand("OK");
        this.addDefaultButton(okButton);
        this.task = new DownloadTask(this.ids, this.artworkScrapers);
        this.task.execute();
    }

    private void startProgressBar(String description) {
        this.lblProgressAction.setText(description);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    private void stopProgressBar() {
        this.lblProgressAction.setText("");
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(false);
    }

    private void addImage(BufferedImage originalImage, MediaArtwork artwork) {
        JCheckBox chkbx;
        JLabel label;
        Point size = null;
        GridBagLayout gbl = new GridBagLayout();
        switch (this.type) {
            case FANART: 
            case CLEARART: 
            case DISC: 
            case CHARACTERART: 
            case THUMB: {
                gbl.columnWidths = new int[]{130};
                gbl.rowHeights = new int[]{180};
                size = ImageUtils.calculateSize(300, 150, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            case BANNER: 
            case LOGO: 
            case CLEARLOGO: {
                gbl.columnWidths = new int[]{130};
                gbl.rowHeights = new int[]{120};
                size = ImageUtils.calculateSize(300, 100, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            default: {
                gbl.columnWidths = new int[]{180};
                gbl.rowHeights = new int[]{270};
                size = ImageUtils.calculateSize(150, 250, originalImage.getWidth(), originalImage.getHeight(), true);
            }
        }
        gbl.columnWeights = new double[]{Double.MIN_VALUE};
        gbl.rowWeights = new double[]{Double.MIN_VALUE};
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        JToggleButton button = new JToggleButton();
        button.setBackground(Color.white);
        button.setUI(this.toggleButtonUI);
        button.setMargin(new Insets(10, 10, 10, 10));
        if (artwork.isAnimated()) {
            button.setText("<html><img width=\"" + size.x + "\" height=\"" + size.y + "\" src='" + artwork.getPreviewUrl() + "'/></html>");
            button.setBorder(BorderFactory.createLineBorder(Color.GREEN, 3));
        } else {
            ImageIcon imageIcon = new ImageIcon(Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS}));
            button.setIcon(imageIcon);
        }
        button.putClientProperty("MediaArtwork", artwork);
        this.buttonGroup.add(button);
        this.buttons.add(button);
        imagePanel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 25;
        gbc.insets = new Insets(0, 5, 0, 0);
        JComboBox<Object> cb = null;
        cb = !artwork.getImageSizes().isEmpty() ? new JComboBox<Object>(artwork.getImageSizes().toArray()) : new JComboBox<String>(new String[]{originalImage.getWidth() + "x" + originalImage.getHeight()});
        button.putClientProperty("MediaArtworkSize", cb);
        imagePanel.add(cb, gbc);
        int row = 0;
        if (this.type == ImageType.FANART && this.extraThumbs != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = ++row;
            gbc.anchor = 22;
            label = new JLabel("Extrathumb");
            imagePanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = row;
            gbc.anchor = 22;
            chkbx = new JCheckBox();
            button.putClientProperty("MediaArtworkExtrathumb", chkbx);
            imagePanel.add((Component)chkbx, gbc);
        }
        if (this.type == ImageType.FANART && this.extraFanarts != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = ++row;
            gbc.anchor = 22;
            label = new JLabel("Extrafanart");
            imagePanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = row;
            gbc.anchor = 22;
            chkbx = new JCheckBox();
            button.putClientProperty("MediaArtworkExtrafanart", chkbx);
            imagePanel.add((Component)chkbx, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 25;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        LinkLabel lblShowImage = new LinkLabel(BUNDLE.getString("image.showoriginal"));
        lblShowImage.addActionListener(e -> {
            ImagePreviewDialog dialog = new ImagePreviewDialog(artwork.getDefaultUrl());
            dialog.setVisible(true);
        });
        imagePanel.add((Component)lblShowImage, gbc);
        this.panelImages.add(imagePanel);
        this.viewport.setLocked(true);
        this.revalidate();
        SwingUtilities.invokeLater(() -> this.viewport.setLocked(false));
    }

    private void downloadAndPreviewImage(String url) {
        Runnable task = () -> {
            try {
                MediaArtwork art;
                switch (this.type) {
                    case BANNER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BANNER);
                        break;
                    }
                    case CLEARART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARART);
                        break;
                    }
                    case DISC: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.DISC);
                        break;
                    }
                    case FANART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BACKGROUND);
                        break;
                    }
                    case LOGO: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.LOGO);
                        break;
                    }
                    case CLEARLOGO: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARLOGO);
                        break;
                    }
                    case CHARACTERART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CHARACTERART);
                        break;
                    }
                    case POSTER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.POSTER);
                        break;
                    }
                    case SEASON_POSTER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_POSTER);
                        break;
                    }
                    case SEASON_BANNER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_BANNER);
                        break;
                    }
                    case SEASON_THUMB: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_THUMB);
                        break;
                    }
                    case THUMB: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.THUMB);
                        break;
                    }
                    case KEYART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.KEYART);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                art.setDefaultUrl(url);
                art.setPreviewUrl(url);
                Url url1 = new Url(art.getPreviewUrl());
                BufferedImage bufferedImage = ImageUtils.createImage(url1.getBytesWithRetry(5));
                SwingUtilities.invokeLater(() -> this.addImage(bufferedImage, art));
                this.tfImageUrl.setText("");
            }
            catch (Exception e) {
                LOGGER.error("could not download manually entered image url: {} - {}", (Object)this.tfImageUrl.getText(), (Object)e.getMessage());
            }
        };
        task.run();
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, MediaType mediaType) {
        return ImageChooserDialog.chooseImage(parent, ids, type, artworkScrapers, null, null, mediaType);
    }

    public static String chooseImage(Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, MediaType mediaType) {
        return ImageChooserDialog.chooseImage(ids, type, artworkScrapers, null, null, mediaType);
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType) {
        if (ids.isEmpty()) {
            return "";
        }
        ImageLabel lblImage = new ImageLabel();
        ImageChooserDialog dialog = new ImageChooserDialog(parent, ids, type, artworkScrapers, lblImage, extraThumbs, extraFanarts, mediaType);
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
        return lblImage.getImageUrl();
    }

    public static String chooseImage(Map<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType) {
        if (ids.isEmpty()) {
            return "";
        }
        ImageLabel lblImage = new ImageLabel();
        ImageChooserDialog dialog = new ImageChooserDialog(ids, type, artworkScrapers, lblImage, extraThumbs, extraFanarts, mediaType);
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
        return lblImage.getImageUrl();
    }

    private final class LockableViewPort
    extends JViewport {
        private boolean locked = false;

        private LockableViewPort() {
        }

        @Override
        public void setViewPosition(Point p) {
            if (this.locked) {
                return;
            }
            super.setViewPosition(p);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }
    }

    private class LocalFileChooseAction
    extends AbstractAction {
        private static final long serialVersionUID = -1178325861474276709L;

        public LocalFileChooseAction() {
            this.putValue("Name", TmmDialog.BUNDLE.getString("image.choose.file"));
            this.putValue("ShortDescription", TmmDialog.BUNDLE.getString("image.choose.file"));
            this.putValue("SmallIcon", IconManager.FILE_OPEN_INV);
            this.putValue("SwingLargeIconKey", IconManager.FILE_OPEN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = TmmProperties.getInstance().getProperty("imageChooser.path");
            Path file = TmmUIHelper.selectFile(TmmDialog.BUNDLE.getString("image.choose"), path, new FileNameExtensionFilter("Image files", ".jpg", ".jpeg", ".png", ".bmp", ".gif", ".tbn"));
            if (file != null && Utils.isRegularFile(file)) {
                String fileName = file.toAbsolutePath().toString();
                ImageChooserDialog.this.imageLabel.clearImage();
                ImageChooserDialog.this.imageLabel.setImageUrl("file:/" + fileName);
                ImageChooserDialog.this.task.cancel(true);
                TmmProperties.getInstance().putProperty("imageChooser.path", file.getParent().toString());
                ImageChooserDialog.this.setVisible(false);
            }
        }
    }

    private class DownloadChunk {
        private BufferedImage image;
        private MediaArtwork artwork;

        private DownloadChunk() {
        }
    }

    private class DownloadTask
    extends SwingWorker<Void, DownloadChunk> {
        private Map<String, Object> ids;
        private List<MediaScraper> artworkScrapers;
        private boolean imagesFound = false;

        public DownloadTask(Map<String, Object> ids, List<MediaScraper> artworkScrapers) {
            this.ids = ids;
            this.artworkScrapers = artworkScrapers;
        }

        @Override
        public Void doInBackground() {
            if (this.ids.isEmpty()) {
                JOptionPane.showMessageDialog(null, TmmDialog.BUNDLE.getString("image.download.noid"));
                return null;
            }
            SwingUtilities.invokeLater(() -> ImageChooserDialog.this.startProgressBar(TmmDialog.BUNDLE.getString("image.download.progress")));
            if (this.artworkScrapers == null || this.artworkScrapers.isEmpty()) {
                return null;
            }
            ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            pool.allowCoreThreadTimeOut(true);
            ExecutorCompletionService<DownloadChunk> service = new ExecutorCompletionService<DownloadChunk>(pool);
            for (MediaScraper scraper : this.artworkScrapers) {
                try {
                    IMediaArtworkProvider artworkProvider = (IMediaArtworkProvider)scraper.getMediaProvider();
                    ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(ImageChooserDialog.this.mediaType);
                    if (ImageChooserDialog.this.mediaType == MediaType.MOVIE || ImageChooserDialog.this.mediaType == MediaType.MOVIE_SET) {
                        options.setLanguage(MovieModuleManager.SETTINGS.getImageScraperLanguage());
                        options.setFanartSize(MovieModuleManager.SETTINGS.getImageFanartSize());
                        options.setPosterSize(MovieModuleManager.SETTINGS.getImagePosterSize());
                    } else {
                        if (ImageChooserDialog.this.mediaType != MediaType.TV_SHOW) continue;
                        options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage());
                    }
                    switch (ImageChooserDialog.this.type) {
                        case POSTER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                            break;
                        }
                        case FANART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.BACKGROUND);
                            break;
                        }
                        case BANNER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.BANNER);
                            break;
                        }
                        case SEASON_POSTER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_POSTER);
                            break;
                        }
                        case SEASON_BANNER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_BANNER);
                            break;
                        }
                        case SEASON_THUMB: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_THUMB);
                            break;
                        }
                        case CLEARART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARART);
                            break;
                        }
                        case DISC: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.DISC);
                            break;
                        }
                        case LOGO: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.LOGO);
                            break;
                        }
                        case CLEARLOGO: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARLOGO);
                            break;
                        }
                        case CHARACTERART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CHARACTERART);
                            break;
                        }
                        case KEYART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.KEYART);
                            break;
                        }
                        case THUMB: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
                        }
                    }
                    for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
                        Object v = entry.getValue();
                        if (v == null) continue;
                        options.setId(entry.getKey(), v.toString());
                    }
                    List<MediaArtwork> artwork = artworkProvider.getArtwork(options);
                    if (artwork == null || artwork.isEmpty()) continue;
                    for (MediaArtwork art : artwork) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        if (art.getPreviewUrl().isEmpty()) continue;
                        Callable<DownloadChunk> callable = () -> {
                            Url url = new Url(art.getPreviewUrl());
                            DownloadChunk chunk = new DownloadChunk();
                            chunk.artwork = art;
                            try {
                                chunk.image = ImageUtils.createImage(url.getBytesWithRetry(5));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return chunk;
                        };
                        service.submit(callable);
                    }
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                }
                catch (MissingIdException e) {
                    LOGGER.debug("could not fetch artwork: {}", (Object[])e.getIds());
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                        pool.getQueue().clear();
                        pool.shutdownNow();
                        return null;
                    }
                    LOGGER.error("could not process artwork downloading - {}", (Object)e.getMessage());
                }
            }
            pool.shutdown();
            while (true) {
                try {
                    while (true) {
                        Future future;
                        if ((future = service.poll(1L, TimeUnit.SECONDS)) != null) {
                            DownloadChunk dc = (DownloadChunk)future.get();
                            if (dc.image == null) continue;
                            this.publish(dc);
                            this.imagesFound = true;
                            continue;
                        }
                        if (pool.isTerminated()) break;
                    }
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    LOGGER.error("ThreadPool imageChooser: Error getting result! - {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        protected void process(List<DownloadChunk> chunks) {
            for (DownloadChunk chunk : chunks) {
                ImageChooserDialog.this.addImage(chunk.image, chunk.artwork);
            }
        }

        @Override
        public void done() {
            if (!this.imagesFound) {
                JLabel lblNothingFound = new JLabel(TmmDialog.BUNDLE.getString("image.download.nothingfound"));
                TmmFontHelper.changeFont((JComponent)lblNothingFound, 1.33);
                ImageChooserDialog.this.panelImages.add(lblNothingFound);
                ImageChooserDialog.this.panelImages.validate();
                ImageChooserDialog.this.panelImages.getParent().validate();
            }
            SwingUtilities.invokeLater(() -> ImageChooserDialog.this.stopProgressBar());
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 403327079655572423L;

        public CancelAction() {
            this.putValue("Name", TmmDialog.BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmDialog.BUNDLE.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -1255049344169945137L;

        public OkAction() {
            this.putValue("Name", TmmDialog.BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", TmmDialog.BUNDLE.getString("image.seteselected"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaArtwork artwork = null;
            MediaArtwork.ImageSizeAndUrl resolution = null;
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JComboBox cb;
                Object clientProperty;
                if (!button.isSelected() || !((clientProperty = button.getClientProperty("MediaArtwork")) instanceof MediaArtwork)) continue;
                artwork = (MediaArtwork)clientProperty;
                clientProperty = button.getClientProperty("MediaArtworkSize");
                if (!(clientProperty instanceof JComboBox) || !((cb = (JComboBox)clientProperty).getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl)) break;
                resolution = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                break;
            }
            if (artwork == null) {
                JOptionPane.showMessageDialog(null, TmmDialog.BUNDLE.getString("image.noneselected"));
                return;
            }
            if (artwork != null) {
                ImageChooserDialog.this.imageLabel.clearImage();
                if (resolution != null) {
                    ImageChooserDialog.this.imageLabel.setImageUrl(resolution.getUrl());
                } else {
                    ImageChooserDialog.this.imageLabel.setImageUrl(artwork.getDefaultUrl());
                }
            }
            if (ImageChooserDialog.this.type == ImageType.FANART && ImageChooserDialog.this.extraThumbs != null) {
                this.processExtraThumbs();
            }
            if (ImageChooserDialog.this.type == ImageType.FANART && ImageChooserDialog.this.extraFanarts != null) {
                this.processExtraFanart();
            }
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }

        private void processExtraThumbs() {
            ImageChooserDialog.this.extraThumbs.clear();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                if (cb.getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                    if (size != null) {
                        ImageChooserDialog.this.extraThumbs.add(size.getUrl());
                        continue;
                    }
                    ImageChooserDialog.this.extraThumbs.add(artwork.getDefaultUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                ImageChooserDialog.this.extraThumbs.add(artwork.getDefaultUrl());
            }
        }

        private void processExtraFanart() {
            ImageChooserDialog.this.extraFanarts.clear();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                if (cb.getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                    if (size != null) {
                        ImageChooserDialog.this.extraFanarts.add(size.getUrl());
                        continue;
                    }
                    ImageChooserDialog.this.extraFanarts.add(artwork.getDefaultUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                ImageChooserDialog.this.extraFanarts.add(artwork.getDefaultUrl());
            }
        }
    }

    public static enum ImageType {
        POSTER,
        FANART,
        BANNER,
        SEASON_POSTER,
        SEASON_BANNER,
        SEASON_THUMB,
        LOGO,
        CLEARLOGO,
        CLEARART,
        CHARACTERART,
        DISC,
        THUMB,
        KEYART;

    }
}

