/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImagePreviewDialog
extends TmmDialog {
    private static final long serialVersionUID = -7479476493187235867L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagePreviewDialog.class);
    private String imageUrl;
    private String imagePath;
    private ImageLabel image;

    public ImagePreviewDialog(String urlToImage) {
        super(BUNDLE.getString("image.show"), "imagePreview");
        this.init();
        this.imageUrl = urlToImage;
    }

    public ImagePreviewDialog(Path pathToImage) {
        super(BUNDLE.getString("image.show"), "imagePreview");
        this.init();
        this.imagePath = pathToImage.toString();
    }

    private void init() {
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new SaveToDiskAction());
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout((LayoutManager)new MigLayout("", "[300lp,grow]", "[300lp,grow]"));
        this.getContentPane().add(imagePanel);
        this.image = new ImageLabel(true);
        this.image.setPreferCache(false);
        this.image.setIsLightbox(true);
        this.image.setPosition(ImageLabel.Position.CENTER);
        this.image.setCacheUrl(true);
        this.image.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        imagePanel.add((Component)this.image, "cell 0 0,grow");
        JButton closeButton = new JButton(BUNDLE.getString("Button.close"));
        closeButton.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(closeButton);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth();
            int height = gd.getDisplayMode().getHeight();
            this.setMaximumSize(new Dimension(width, height));
            SwingUtilities.invokeLater(() -> {
                if (StringUtils.isNotBlank((CharSequence)this.imagePath)) {
                    this.image.setImagePath(this.imagePath);
                } else if (StringUtils.isNotBlank((CharSequence)this.imageUrl)) {
                    this.image.setImageUrl(this.imageUrl);
                }
            });
            this.pack();
            this.setLocationRelativeTo(MainWindow.getActiveInstance());
            super.setVisible(true);
        } else {
            super.setVisible(false);
            this.dispose();
        }
    }

    private class SaveToDiskAction
    extends TmmAction {
        private SaveToDiskAction() {
            this.putValue("SwingLargeIconKey", IconManager.EXPORT);
            this.putValue("SmallIcon", IconManager.EXPORT);
            this.putValue("Name", BUNDLE.getString("image.savetodisk"));
        }

        @Override
        protected void processAction(ActionEvent e) {
            block10: {
                try {
                    String filename = "";
                    if (StringUtils.isNotBlank((CharSequence)ImagePreviewDialog.this.imagePath)) {
                        filename = FilenameUtils.getBaseName((String)ImagePreviewDialog.this.imagePath);
                    } else if (StringUtils.isNotBlank((CharSequence)ImagePreviewDialog.this.imageUrl)) {
                        filename = FilenameUtils.getBaseName((String)ImagePreviewDialog.this.imageUrl);
                    }
                    Path file = TmmUIHelper.saveFile(BUNDLE.getString("image.savetodisk"), "", filename, new FileNameExtensionFilter("Image files", ".jpg", ".png"));
                    if (file == null) break block10;
                    try (FileOutputStream os = new FileOutputStream(file.toFile());){
                        IOUtils.write((byte[])ImagePreviewDialog.this.image.getOriginalImageBytes(), (OutputStream)os);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not save image file: {}", (Object)ex.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"", "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        }
    }
}

