/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class PersonEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 535326891112742179L;
    private final Person personToEdit;
    private JTextField tfName;
    private JTextField tfRole;
    private JTextField tfImageUrl;
    private JTextField tfProfileUrl;

    public PersonEditorDialog(Window owner, String title, Person person) {
        super(owner, title, "personEditor");
        this.personToEdit = person;
        this.initComponents();
        this.tfName.setText(this.personToEdit.getName());
        this.tfRole.setText(this.personToEdit.getRole());
        this.tfImageUrl.setText(this.personToEdit.getThumbUrl());
        this.tfProfileUrl.setText(this.personToEdit.getProfileUrl());
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add(panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][300lp:n,grow][]", "[][][][]"));
        JLabel lblNameT = new JLabel(BUNDLE.getString("metatag.name"));
        panelContent.add((Component)lblNameT, "cell 0 0,alignx trailing");
        this.tfName = new JTextField();
        panelContent.add((Component)this.tfName, "cell 1 0,growx");
        this.tfName.setColumns(10);
        JLabel lblRoleT = new JLabel(BUNDLE.getString("metatag.role"));
        panelContent.add((Component)lblRoleT, "cell 0 1,alignx trailing");
        this.tfRole = new JTextField();
        panelContent.add((Component)this.tfRole, "cell 1 1,growx");
        this.tfRole.setColumns(10);
        JLabel lblImageUrlT = new JLabel(BUNDLE.getString("image.url"));
        panelContent.add((Component)lblImageUrlT, "cell 0 2,alignx trailing");
        this.tfImageUrl = new JTextField();
        panelContent.add((Component)this.tfImageUrl, "cell 1 2,growx");
        this.tfImageUrl.setColumns(10);
        JButton btnShowImage = new JButton(IconManager.IMAGE_INV);
        btnShowImage.setToolTipText(BUNDLE.getString("image.show"));
        btnShowImage.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.tfImageUrl.getText())) {
                try {
                    URL url = new URL(this.tfImageUrl.getText());
                    ImagePreviewDialog dialog = new ImagePreviewDialog(url.toExternalForm());
                    ((Dialog)dialog).setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        panelContent.add((Component)btnShowImage, "cell 2 2");
        JLabel lblProfileUrlT = new JLabel(BUNDLE.getString("profile.url"));
        panelContent.add((Component)lblProfileUrlT, "cell 0 3,alignx trailing");
        this.tfProfileUrl = new JTextField();
        panelContent.add((Component)this.tfProfileUrl, "cell 1 3,growx");
        this.tfProfileUrl.setColumns(10);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.addActionListener(e -> this.setVisible(false));
        this.addButton(btnCancel);
        JButton btnOk = new JButton(BUNDLE.getString("Button.save"));
        btnOk.addActionListener(e -> {
            this.personToEdit.setName(this.tfName.getText());
            this.personToEdit.setRole(this.tfRole.getText());
            this.personToEdit.setThumbUrl(this.tfImageUrl.getText());
            this.personToEdit.setProfileUrl(this.tfProfileUrl.getText());
            this.setVisible(false);
        });
        this.addDefaultButton(btnOk);
    }
}

