/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class UpdateDialog
extends TmmDialog {
    private static final long serialVersionUID = 535315282932742179L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateDialog.class);

    public UpdateDialog(String changelog) {
        super(BUNDLE.getString("tmm.update.title"), "update");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][10lp:n][][400lp,grow]"));
        ReadOnlyTextPane lblUpdateInfo = new ReadOnlyTextPane();
        lblUpdateInfo.setText(BUNDLE.getString("tmm.update.message"));
        panelContent.add((Component)lblUpdateInfo, "cell 0 0,growx");
        JLabel lblChangelog = new JLabel(BUNDLE.getString("whatsnew.title"));
        panelContent.add((Component)lblChangelog, "cell 0 2,growx");
        JScrollPane scrollPane = new JScrollPane();
        panelContent.add((Component)scrollPane, "cell 0 3,grow");
        JTextPane textPane = new JTextPane();
        textPane.setFont(new Font("Monospaced", 0, Globals.settings.getFontSize() + 1));
        scrollPane.setViewportView(textPane);
        textPane.setContentType("text/html");
        textPane.setText(this.prepareTextAsHtml(changelog));
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        textPane.addHyperlinkListener(hle -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                try {
                    TmmUIHelper.browseUrl(hle.getURL().toString());
                }
                catch (Exception e) {
                    LOGGER.error("error browsing to " + hle.getURL().toString() + " :" + e.getMessage());
                }
            }
        });
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        JButton btnUpdate = new JButton(BUNDLE.getString("Button.update"));
        btnUpdate.addActionListener(arg0 -> {
            this.setVisible(false);
            LOGGER.info("Updating...");
            MainWindow.getActiveInstance().closeTmmAndStart(Utils.getPBforTMMupdate());
        });
        this.addButton(btnUpdate);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension((int)(700.0 > superPref.getWidth() ? superPref.getWidth() : 700.0), (int)(500.0 > superPref.getHeight() ? superPref.getHeight() : 500.0));
    }

    private String prepareTextAsHtml(String originalText) {
        Pattern pattern = Pattern.compile("(http[s]?://.*?)[ )]");
        Matcher matcher = pattern.matcher(originalText);
        while (matcher.find()) {
            originalText = originalText.replace(matcher.group(1), "<a href=\"" + matcher.group(1) + "\">" + matcher.group(1) + "</a>");
        }
        Color foreground = UIManager.getColor("TextPane.foreground");
        String color = Integer.toHexString(foreground.getRed()) + Integer.toHexString(foreground.getGreen()) + Integer.toHexString(foreground.getBlue());
        return "<html><pre style=\"color: #" + color + "\">" + originalText + "</pre><html>";
    }
}

