/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class UpgradeDialog
extends TmmDialog {
    private static final long serialVersionUID = -4071143363981892283L;
    private JButton btnUpgrade;
    private JCheckBox chckbxAccept;

    public UpgradeDialog() {
        super(BUNDLE.getString("tmm.upgradev4"), "upgradev4");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][][][shrink 0][400lp,grow][shrink 0][]"));
        JLabel lblTinymediamanagerV = new JLabel("tinyMediaManager v4");
        TmmFontHelper.changeFont(lblTinymediamanagerV, TmmFontHelper.H1, 1);
        panelContent.add((Component)lblTinymediamanagerV, "cell 0 0");
        ReadOnlyTextPane tpTop = new ReadOnlyTextPane(BUNDLE.getString("tmm.upgradev4.desc"));
        panelContent.add((Component)tpTop, "cell 0 1,grow");
        LinkLabel lblLinkLabel = new LinkLabel("https://www.tinymediamanager.org/blog/version-4-0/");
        lblLinkLabel.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl("https://www.tinymediamanager.org/blog/version-4-0/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        panelContent.add((Component)lblLinkLabel, "cell 0 2, grow");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 3,growx");
        JScrollPane scrollPane = new JScrollPane();
        panelContent.add((Component)scrollPane, "cell 0 4,grow");
        ReadOnlyTextPane tpChangelog = new ReadOnlyTextPane(this.changelogV4());
        scrollPane.setViewportView(tpChangelog);
        JSeparator separator_1 = new JSeparator();
        panelContent.add((Component)separator_1, "cell 0 5,growx");
        this.chckbxAccept = new JCheckBox(BUNDLE.getString("tmm.upgradev4.accept"));
        panelContent.add((Component)this.chckbxAccept, "flowx,cell 0 6");
        this.btnUpgrade = new JButton(BUNDLE.getString("tmm.upgradev4"));
        this.btnUpgrade.addActionListener(e -> {
            try {
                Path path = Paths.get("getdown.txt", new String[0]);
                String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                content = content.replace("tinymediamanager.org/v3/build/", "tinymediamanager.org/v4/build/");
                Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                MainWindow.getActiveInstance().checkForUpdate(false);
                this.setVisible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Component horizontalGlue = Box.createHorizontalGlue();
        panelContent.add(horizontalGlue, "cell 0 6,growx");
        panelContent.add((Component)this.btnUpgrade, "cell 0 6");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        this.initDataBindings();
    }

    protected void initDataBindings() {
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        BeanProperty jButtonBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxAccept, (Property)jCheckBoxBeanProperty, (Object)this.btnUpgrade, (Property)jButtonBeanProperty);
        autoBinding.bind();
    }

    private String changelogV4() {
        try {
            return IOUtils.resourceToString((String)"/changelogv4.txt", (Charset)Charset.defaultCharset());
        }
        catch (Exception exception) {
            return "";
        }
    }
}

