/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.util.Locale;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.ScraperInTable;

public class MovieScraper
extends ScraperInTable
implements Comparable<MovieScraper> {
    private boolean defaultScraper = false;

    public MovieScraper(MediaScraper scraper) {
        super(scraper);
    }

    private boolean isKodiScraper() {
        return this.scraper.getName().startsWith("Kodi");
    }

    public Boolean getDefaultScraper() {
        return this.defaultScraper;
    }

    public void setDefaultScraper(Boolean newValue) {
        if (this.scraper.isEnabled()) {
            Boolean oldValue = this.defaultScraper;
            this.defaultScraper = newValue;
            this.firePropertyChange("defaultScraper", oldValue, newValue);
        }
    }

    public MediaScraper getMediaScraper() {
        return this.scraper;
    }

    @Override
    public int compareTo(MovieScraper o) {
        if (this.isKodiScraper() && !o.isKodiScraper()) {
            return 1;
        }
        if (!this.isKodiScraper() && o.isKodiScraper()) {
            return -1;
        }
        return this.scraper.getName().toLowerCase(Locale.ROOT).compareTo(o.scraper.getName().toLowerCase(Locale.ROOT));
    }
}

