/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieDownloadMissingArtworkDialog
extends TmmDialog {
    private static final long serialVersionUID = -2126984610197979241L;
    private MediaScraperCheckComboBox cbArtworkScraper;
    private boolean startScrape = false;
    private ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig> cbScraperConfig;

    public MovieDownloadMissingArtworkDialog() {
        super(BUNDLE.getString("movie.downloadmissingartwork"), "downloadMissingArtwork");
        ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper artworkScraper : MovieList.getInstance().getAvailableArtworkScrapers()) {
            if (!MovieModuleManager.SETTINGS.getArtworkScrapers().contains(artworkScraper.getId())) continue;
            selectedArtworkScrapers.add(artworkScraper);
        }
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new MigLayout("", "[][300lp:400lp,grow]", "[][][][][shrink 0][150lp:n, grow]"));
        TmmLabel lblArtworkScraper = new TmmLabel(BUNDLE.getString("scraper.artwork"));
        panelCenter.add((Component)lblArtworkScraper, "cell 0 2,alignx right");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(MovieList.getInstance().getAvailableArtworkScrapers());
        panelCenter.add((Component)this.cbArtworkScraper, "cell 1 2,growx");
        JSeparator separator = new JSeparator();
        panelCenter.add((Component)separator, "cell 0 4 2 1,growx");
        JPanel panelScraperConfig = new JPanel();
        panelCenter.add((Component)panelScraperConfig, "cell 0 5 2 1,grow");
        panelScraperConfig.setLayout((LayoutManager)new MigLayout("", "[300lp:400lp,grow]", "[][]"));
        TmmLabel lblScrapeFollowingItems = new TmmLabel(BUNDLE.getString("scraper.metadata.select"));
        panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox((ScraperMetadataConfig[])MovieScraperMetadataConfig.getArtworkTypes());
        panelScraperConfig.add(this.cbScraperConfig, "cell 0 1 ,wmin 0,grow");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (!selectedArtworkScrapers.isEmpty()) {
            this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
        }
        this.cbScraperConfig.setSelectedItems(MovieModuleManager.SETTINGS.getScraperMetadataConfig());
    }

    public MovieSearchAndScrapeOptions getMovieSearchAndScrapeOptions() {
        MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
        movieSearchAndScrapeConfig.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        return movieSearchAndScrapeConfig;
    }

    public List<MovieScraperMetadataConfig> getMovieScraperMetadataConfig() {
        return this.cbScraperConfig.getSelectedItems();
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

