/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 3826984454317979241L;
    private JComboBox<MediaLanguages> cbLanguage;
    private MediaScraperComboBox cbMetadataScraper;
    private MediaScraperCheckComboBox cbArtworkScraper;
    private MediaScraperCheckComboBox cbTrailerScraper;
    private boolean startScrape = false;
    private ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig> cbScraperConfig;

    public MovieScrapeMetadataDialog(String title) {
        super(title, "updateMetadata");
        MediaScraper defaultScraper = MediaScraper.getMediaScraperById(MovieModuleManager.SETTINGS.getMovieScraper(), ScraperType.MOVIE);
        ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper mediaScraper : MovieList.getInstance().getAvailableArtworkScrapers()) {
            if (!MovieModuleManager.SETTINGS.getArtworkScrapers().contains(mediaScraper.getId())) continue;
            selectedArtworkScrapers.add(mediaScraper);
        }
        ArrayList<MediaScraper> selectedTrailerScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper trailerScraper : MovieList.getInstance().getAvailableTrailerScrapers()) {
            if (!MovieModuleManager.SETTINGS.getTrailerScrapers().contains(trailerScraper.getId())) continue;
            selectedTrailerScrapers.add(trailerScraper);
        }
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][600lp:800lp,grow]", "[][][][][shrink 0][150lp:n, grow]"));
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("metatag.language"));
        jPanel.add((Component)lblLanguageT, "cell 0 0,alignx trailing");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        this.cbLanguage.setSelectedItem((Object)MovieModuleManager.SETTINGS.getScraperLanguage());
        jPanel.add(this.cbLanguage, "cell 1 0,growx");
        TmmLabel lblMetadataScraperT = new TmmLabel(BUNDLE.getString("scraper.metadata"));
        jPanel.add((Component)lblMetadataScraperT, "cell 0 1,alignx right");
        this.cbMetadataScraper = new MediaScraperComboBox(MovieList.getInstance().getAvailableMediaScrapers());
        jPanel.add((Component)this.cbMetadataScraper, "cell 1 1,growx");
        this.cbMetadataScraper.setSelectedItem(defaultScraper);
        TmmLabel lblArtworkScraper = new TmmLabel(BUNDLE.getString("scraper.artwork"));
        jPanel.add((Component)lblArtworkScraper, "cell 0 2,alignx right");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(MovieList.getInstance().getAvailableArtworkScrapers());
        jPanel.add((Component)this.cbArtworkScraper, "cell 1 2,growx");
        TmmLabel lblTrailerScraper = new TmmLabel(BUNDLE.getString("scraper.trailer"));
        jPanel.add((Component)lblTrailerScraper, "cell 0 3,alignx right");
        this.cbTrailerScraper = new MediaScraperCheckComboBox(MovieList.getInstance().getAvailableTrailerScrapers());
        jPanel.add((Component)this.cbTrailerScraper, "cell 1 3,growx");
        JSeparator separator = new JSeparator();
        jPanel.add((Component)separator, "cell 0 4 2 1,growx");
        JPanel panelScraperConfig = new JPanel();
        jPanel.add((Component)panelScraperConfig, "cell 0 5 2 1,grow");
        panelScraperConfig.setLayout((LayoutManager)new MigLayout("", "[300lp:500lp,grow]", "[][]"));
        TmmLabel lblScrapeFollowingItems = new TmmLabel(BUNDLE.getString("scraper.metadata.select"));
        panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox((ScraperMetadataConfig[])MovieScraperMetadataConfig.values());
        panelScraperConfig.add(this.cbScraperConfig, "cell 0 1 ,wmin 0,grow");
        JButton jButton = new JButton(BUNDLE.getString("Button.cancel"));
        jButton.setIcon(IconManager.CANCEL_INV);
        jButton.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(jButton);
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (!selectedArtworkScrapers.isEmpty()) {
            this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
        }
        if (!selectedTrailerScrapers.isEmpty()) {
            this.cbTrailerScraper.setSelectedItems(selectedTrailerScrapers);
        }
        this.cbScraperConfig.setSelectedItems(MovieModuleManager.SETTINGS.getScraperMetadataConfig());
    }

    public MovieSearchAndScrapeOptions getMovieSearchAndScrapeOptions() {
        MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
        movieSearchAndScrapeConfig.setLanguage((MediaLanguages)((Object)this.cbLanguage.getSelectedItem()));
        movieSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        movieSearchAndScrapeConfig.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        movieSearchAndScrapeConfig.setTrailerScraper(this.cbTrailerScraper.getSelectedItems());
        return movieSearchAndScrapeConfig;
    }

    public List<MovieScraperMetadataConfig> getMovieScraperMetadataConfig() {
        return this.cbScraperConfig.getSelectedItems();
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

