/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioChannelFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private static final String CHANNEL_1 = "1 (Mono)";
    private static final String CHANNEL_2 = "2 (Stereo)";
    private static final String CHANNEL_3 = "3 (2.1)";
    private static final String CHANNEL_6 = "6 (5.1)";
    private static final String CHANNEL_8 = "8 (7.1)";

    public MovieAudioChannelFilter() {
        this.setValues(CHANNEL_1, CHANNEL_2, CHANNEL_3, CHANNEL_6, CHANNEL_8);
    }

    @Override
    public String getId() {
        return "movieAudioChannel";
    }

    @Override
    public boolean accept(Movie movie) {
        List<String> selectedValues = this.checkComboBox.getSelectedItems();
        List<String> audioChannels = this.prepareSelectesAudioChannels(selectedValues);
        List<MediaFile> mediaFiles = movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO);
        for (MediaFile mf : mediaFiles) {
            for (String channels : mf.getAudioChannelsList()) {
                if (!audioChannels.contains(channels)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> prepareSelectesAudioChannels(List<String> selectedValues) {
        ArrayList<String> selectedAudioChannels = new ArrayList<String>();
        Iterator<String> iterator = selectedValues.iterator();
        while (iterator.hasNext()) {
            String channel;
            switch (channel = iterator.next()) {
                case "1 (Mono)": {
                    selectedAudioChannels.add("1ch");
                    break;
                }
                case "2 (Stereo)": {
                    selectedAudioChannels.add("2ch");
                    break;
                }
                case "3 (2.1)": {
                    selectedAudioChannels.add("3ch");
                    break;
                }
                case "6 (5.1)": {
                    selectedAudioChannels.add("6ch");
                    break;
                }
                case "8 (7.1)": {
                    selectedAudioChannels.add("8ch");
                    break;
                }
            }
        }
        return selectedAudioChannels;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.channels"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

