/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieInMovieSetFilter
extends AbstractMovieUIFilter {
    private JComboBox<MovieInMovieSet> combobox;

    @Override
    public String getId() {
        return "movieInMovieSet";
    }

    @Override
    public String getFilterValueAsString() {
        try {
            return ((MovieInMovieSet)((Object)this.combobox.getSelectedItem())).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        MovieInMovieSet movieInMovieSet;
        if (value == null) {
            return;
        }
        if (value instanceof MovieInMovieSet) {
            this.combobox.setSelectedItem(value);
        } else if (value instanceof String && (movieInMovieSet = MovieInMovieSet.valueOf((String)value)) != null) {
            this.combobox.setSelectedItem((Object)movieInMovieSet);
        }
    }

    @Override
    public boolean accept(Movie movie) {
        if (this.combobox.getSelectedItem() == MovieInMovieSet.IN_MOVIESET) {
            return movie.getMovieSet() != null;
        }
        return movie.getMovieSet() == null;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.movieset"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.combobox = new JComboBox<MovieInMovieSet>(MovieInMovieSet.values());
        return this.combobox;
    }

    static /* synthetic */ ResourceBundle access$000() {
        return BUNDLE;
    }

    static /* synthetic */ ResourceBundle access$100() {
        return BUNDLE;
    }

    private static enum MovieInMovieSet {
        IN_MOVIESET(MovieInMovieSetFilter.access$000().getString("movie.inmovieset")),
        NOT_IN_MOVIESET(MovieInMovieSetFilter.access$100().getString("movie.notinmovieset"));

        private String title;

        private MovieInMovieSet(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

