/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieLanguageFilter
extends AbstractMovieUIFilter {
    private JTextField textField;

    @Override
    public String getId() {
        return "movieLanguage";
    }

    @Override
    public String getFilterValueAsString() {
        return this.textField.getText();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value instanceof String) {
            this.textField.setText((String)value);
        }
    }

    @Override
    public boolean accept(Movie movie) {
        String language = StrgUtils.normalizeString(this.textField.getText());
        if (StringUtils.isBlank((CharSequence)language)) {
            return true;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)movie.getSpokenLanguages())) {
                Pattern pattern = Pattern.compile(language, 2);
                Matcher matcher = pattern.matcher(StrgUtils.normalizeString(movie.getSpokenLanguages()));
                return matcher.find();
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.language"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.textField = new JTextField();
        return this.textField;
    }
}

